//	Zinc Interface Library - D_SYS.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

// ----- UIW_SYSTEM_BUTTON --------------------------------------------------

extern UIW_POP_UP_MENU *_genericSystemMenu;
extern int _genericSystemMenuCount;

static char *_tNormal = "[-]";

static UCHAR _gNormal[29] =
{
	7, 3,
	BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK,
	BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK,
	BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK
};

EVENT_TYPE UIW_SYSTEM_BUTTON::Event(const UI_EVENT &event)
{
	static initializedTime = FALSE;
	static UI_TIME lastTime;
	if (!initializedTime)
	{
		lastTime.Import();
		initializedTime = TRUE;
	}

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_SYSTEM_BUTTON);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		UI_WINDOW_OBJECT::Event(event);
		if (display->isText)
		{
			bitmapArray = NULL;
			bitmapWidth = bitmapHeight = 0;
			text = _tNormal;
			true.right = true.left + 2;
			true.bottom = true.top;
		}
		else
		{
			text = NULL;
			UCHAR *bitmap = _gNormal;
			bitmapWidth = bitmap[0];
			bitmapHeight = bitmap[1];
			bitmapArray = &bitmap[2];
			true.bottom = --true.top + (display->cellHeight - display->preSpace - display->postSpace);
			true.right = --true.left + (display->cellHeight - display->preSpace - display->postSpace);
		}
		break;

	case S_RESET_DISPLAY:
		ccode = UIW_BUTTON::Event(event);
		menu.Event(event);
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;

	case L_BEGIN_SELECT:
		{
		UI_TIME currentTime;
		long elapsedTime = currentTime - lastTime;							// BUG.1228
		if (Abs(elapsedTime) < doubleClickRate && !parent->parent)
		{
			UI_EVENT tEvent = event;
			while (ccode != L_END_SELECT)
			{
				eventManager->Get(tEvent);
				ccode = LogicalEvent(tEvent, ID_SYSTEM_BUTTON);
				// Send all user messages to the window manager.
				if (tEvent.type > 9999)
					windowManager->Event(tEvent);
			}
			eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		}
		lastTime = currentTime;
		}
		// Continue to L_SELECT.
	case L_SELECT:
		if (FlagSet(syFlags, SYF_GENERIC) || menu.First())
		{
			UIW_POP_UP_MENU *sMenu = FlagSet(syFlags, SYF_GENERIC) ? _genericSystemMenu : &menu;
			if (windowManager->Index(sMenu) != -1)
				break;
			sMenu->parent = this;
	 		sMenu->RegionConvert(sMenu->relative, TRUE);
//			if (FlagSet(parent->woStatus, WOS_MINIMIZED))						// BUG.1373
//				true = parent->true;
			sMenu->relative.left = true.left;
			sMenu->relative.top = true.bottom;
			if (display->isText)
				sMenu->relative.top++;
			if (sMenu->Current())
			{
				sMenu->Current()->woStatus &= ~WOS_CURRENT;
				sMenu->SetCurrent(NULL);
			}
			sMenu->true = sMenu->relative;
			for (UI_WINDOW_OBJECT *object = sMenu->First(); object; object = object->Next())
			{
				switch (object->NumberID())
				{
				case NUMID_OPT_RESTORE:
					if (FlagSet(parent->woStatus, WOS_MAXIMIZED | WOS_MINIMIZED))
						object->woFlags &= ~WOF_NON_SELECTABLE;
					else
						object->woFlags |= WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_MOVE:
					if (FlagSet(parent->woAdvancedFlags, WOAF_NO_MOVE) ||
						FlagSet(parent->woStatus, WOS_MAXIMIZED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_SIZE:
					if (FlagSet(parent->woAdvancedFlags, WOAF_NO_SIZE) ||
						FlagSet(parent->woStatus, WOS_MAXIMIZED | WOS_MINIMIZED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_MINIMIZE:
				case NUMID_OPT_MAXIMIZE:
					if (FlagSet(parent->woStatus, WOS_MAXIMIZED | WOS_MINIMIZED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_CLOSE:
					if (parent->parent || FlagSet(parent->woAdvancedFlags, WOAF_LOCKED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;
				}
				if (!sMenu->Current() && !FlagSet(object->woFlags, WOF_NON_SELECTABLE))
				{
					object->woStatus |= WOS_CURRENT;
					sMenu->SetCurrent(object);
				}
			}
			*windowManager + sMenu;
		}
		else
			UIW_BUTTON::Event(event);
		break;

	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		if (display->isText)
		{
			lastPalette = LogicalPalette(ccode);
			UIW_BUTTON::DrawItem(event, ccode);
			woStatus &= ~WOS_REDISPLAY;
			break;
		}
		else
		{
			UI_WINDOW_OBJECT::Event(event);	// Get the palette and status.
			int i, j;
			UCHAR *bitmap = bitmapArray;
			COLOR foregroundColor = display->MapColor(lastPalette, TRUE);
			for (i = 0; i < bitmapHeight; i++)
				for (j = 0; j < bitmapWidth; j++, bitmap++)
					if (*bitmap != BACKGROUND)
						*bitmap = foregroundColor;
			UIW_BUTTON::Event(event);
		}
		break;

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}


