//	Zinc Interface Library - G_EVENT.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#define USE_RAW_KEYS			// Zinc raw keys.
#include "ui_win.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif
#if defined(ZIL_LINKBUG)
void z_event_dummy(void) { }	// Bug fix for broken linkers.
#endif

#if defined(ZIL_MSDOS)
static UI_EVENT_MAP eventMapTable[] =
{
	{ ID_WINDOW_OBJECT, 	L_SELECT,		E_KEY, 		ENTER },
	{ ID_WINDOW_OBJECT, 	L_SELECT,		E_KEY, 		GRAY_ENTER },
	{ ID_WINDOW_OBJECT, 	L_CANCEL,		E_KEY, 		ESCAPE },
	{ ID_WINDOW_OBJECT, 	L_VIEW,			E_MOUSE, 	0 },
	{ ID_WINDOW_OBJECT, 	L_BEGIN_SELECT,		E_MOUSE, 	M_LEFT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_BEGIN_SELECT,		E_MOUSE, 	M_LEFT | M_RIGHT | M_LEFT_CHANGE | M_RIGHT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_SELECT,	E_MOUSE, 	M_LEFT },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_SELECT,	E_MOUSE, 	M_LEFT | M_RIGHT },
	{ ID_WINDOW_OBJECT, 	L_END_SELECT,		E_MOUSE, 	M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_END_SELECT,		E_MOUSE, 	M_RIGHT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_UP,			E_KEY, 		GRAY_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_UP,			E_KEY, 		WHITE_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_DOWN,			E_KEY, 		GRAY_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_DOWN,			E_KEY, 		WHITE_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_LEFT,			E_KEY, 		GRAY_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_LEFT,			E_KEY, 		WHITE_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,		E_KEY, 		GRAY_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,		E_KEY, 		WHITE_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_PREVIOUS,		E_KEY, 		BACKTAB },
	{ ID_WINDOW_OBJECT, 	L_PREVIOUS,		E_KEY, 		SHIFT_F6 },
	{ ID_WINDOW_OBJECT, 	L_NEXT,			E_KEY, 		TAB },
	{ ID_WINDOW_OBJECT, 	L_NEXT,			E_KEY, 		F6 },
	{ ID_WINDOW_OBJECT,	L_HELP,			E_KEY, 		F1 },

	{ ID_WINDOW_OBJECT, 	L_BEGIN_ESCAPE,		E_MOUSE, 	M_RIGHT | M_RIGHT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_ESCAPE,	E_MOUSE, 	M_RIGHT },
	{ ID_WINDOW_OBJECT, 	L_END_ESCAPE,		E_MOUSE, 	M_RIGHT_CHANGE },

	{ ID_STRING,		L_MARK,			E_KEY,		CTRL_F5},
	{ ID_STRING,		L_BEGIN_MARK,		E_MOUSE, 	M_LEFT | M_LEFT_CHANGE },
	{ ID_STRING,		L_CONTINUE_MARK,	E_MOUSE, 	M_LEFT },
	{ ID_STRING,		L_END_MARK,		E_MOUSE, 	M_LEFT_CHANGE },
//	{ ID_STRING,            L_CUT,			E_KEY,     GRAY_DELETE, S_SHIFT },
	{ ID_STRING,		L_CUT,			E_KEY,		CTRL_F6 },
	{ ID_STRING,		L_COPY_MARK,		E_KEY,		CTRL_GRAY_INSERT },
	{ ID_STRING,		L_COPY_MARK,		E_KEY,		CTRL_WHITE_INSERT },
	{ ID_STRING,		L_PASTE,		E_KEY,		CTRL_F8},
//	{ ID_STRING,            L_PASTE,		E_KEY,      GRAY_INSERT, S_SHIFT },
	{ ID_STRING,		L_BACKSPACE,		E_KEY,		BACKSPACE},
	{ ID_STRING,		L_DELETE,		E_KEY,		WHITE_DELETE},
	{ ID_STRING,		L_DELETE,		E_KEY,		GRAY_DELETE},
	{ ID_STRING,		L_DELETE_EOL,		E_KEY,		CTRL_WHITE_DELETE},
	{ ID_STRING,		L_DELETE_EOL,		E_KEY,		CTRL_GRAY_DELETE},
	{ ID_STRING,		L_WORD_LEFT,		E_KEY,		CTRL_WHITE_LEFT_ARROW},
	{ ID_STRING,		L_WORD_LEFT,		E_KEY,		CTRL_GRAY_LEFT_ARROW},
	{ ID_STRING,		L_WORD_LEFT,		E_KEY,		ALT_GRAY_LEFT_ARROW},
	{ ID_STRING,		L_WORD_RIGHT,		E_KEY,		CTRL_WHITE_RIGHT_ARROW},
	{ ID_STRING,		L_WORD_RIGHT,		E_KEY,		CTRL_GRAY_RIGHT_ARROW},
	{ ID_STRING,		L_WORD_RIGHT,		E_KEY,		ALT_GRAY_RIGHT_ARROW},
	{ ID_STRING,		L_BOL,			E_KEY,		WHITE_HOME},
	{ ID_STRING,		L_BOL,			E_KEY,		GRAY_HOME},
	{ ID_STRING,		L_BOL,			E_KEY,		CTRL_WHITE_HOME},
	{ ID_STRING,		L_BOL,			E_KEY,		CTRL_GRAY_HOME},
	{ ID_STRING,		L_EOL,			E_KEY,		WHITE_END},
	{ ID_STRING,		L_EOL,			E_KEY,		GRAY_END},
	{ ID_STRING,		L_EOL,			E_KEY,		CTRL_WHITE_END},
	{ ID_STRING,		L_EOL,			E_KEY,		CTRL_GRAY_END},
	{ ID_STRING,		L_INSERT_TOGGLE,	E_KEY,		WHITE_INSERT},		// BUG.1229
	{ ID_STRING,		L_INSERT_TOGGLE,	E_KEY,		GRAY_INSERT},		// BUG.1229
	{ ID_STRING,		L_PGUP,			E_KEY, 		WHITE_PGUP },		// BUG.1229
	{ ID_STRING,		L_PGUP,			E_KEY, 		GRAY_PGUP },		// BUG.1229
	{ ID_STRING,		L_PGDN,			E_KEY, 		WHITE_PGDN },		// BUG.1229
	{ ID_STRING,		L_PGDN,			E_KEY, 		GRAY_PGDN },		// BUG.1229

	{ ID_WINDOW,		L_PGUP,			E_KEY, 		WHITE_PGUP },
	{ ID_WINDOW,		L_PGUP,			E_KEY, 		GRAY_PGUP },
	{ ID_WINDOW,		L_PGDN,			E_KEY, 		WHITE_PGDN },
	{ ID_WINDOW,		L_PGDN,			E_KEY, 		GRAY_PGDN },
	{ ID_WINDOW,		L_TOP,			E_KEY,	 	WHITE_HOME},
	{ ID_WINDOW,		L_TOP,			E_KEY,	 	GRAY_HOME},
	{ ID_WINDOW,		L_BOTTOM,		E_KEY,	 	WHITE_END},
	{ ID_WINDOW,		L_BOTTOM,		E_KEY,	 	GRAY_END},
	{ ID_WINDOW,		L_MOVE,			E_KEY, 		ALT_F7 },
	{ ID_WINDOW,		L_SIZE,			E_KEY, 		ALT_F8 },
	{ ID_WINDOW,		L_RESTORE,		E_KEY, 		ALT_F5 },
	{ ID_WINDOW,		S_ALT_KEY,		E_KEY, 		F10 },

	{ ID_WINDOW, L_MDICHILD_EVENT+L_NEXT_WINDOW, E_KEY, CTRL_F6 },
	{ ID_WINDOW, S_MDICHILD_EVENT+S_CLOSE, E_KEY, CTRL_F4 },

	{ ID_BUTTON,		L_SELECT,		E_KEY, 		SPACE },
	{ ID_LIST,		L_SELECT,		E_KEY, 		SPACE },
	{ ID_GROUP,		L_SELECT,		E_KEY, 		SPACE },

	{ ID_TEXT,		L_TOP,			E_KEY,	 	CTRL_WHITE_HOME},
	{ ID_TEXT,		L_TOP,			E_KEY,	 	CTRL_GRAY_HOME},
	{ ID_TEXT,		L_BOTTOM,		E_KEY,	 	CTRL_WHITE_END},
	{ ID_TEXT,		L_BOTTOM,		E_KEY,	 	CTRL_GRAY_END},
	{ ID_TEXT,		L_INSERT_TOGGLE,	E_KEY,	 	WHITE_INSERT},		// BUG.1229
	{ ID_TEXT,		L_INSERT_TOGGLE,	E_KEY,	 	GRAY_INSERT},		// BUG.1229

	{ ID_WINDOW_MANAGER, 	L_BEGIN_SELECT,		E_MOUSE, 	M_RIGHT | M_RIGHT_CHANGE },
	{ ID_WINDOW_MANAGER, 	L_CONTINUE_SELECT,	E_MOUSE, 	M_RIGHT },
	{ ID_WINDOW_MANAGER, 	L_END_SELECT,		E_MOUSE, 	M_RIGHT_CHANGE },
	{ ID_WINDOW_MANAGER, 	L_EXIT_FUNCTION,	E_KEY, 		SHIFT_F3 },
	{ ID_WINDOW_MANAGER, 	L_EXIT_FUNCTION,	E_KEY, 		CTRL_BREAK },
	{ ID_WINDOW_MANAGER, 	L_EXIT_FUNCTION,	E_KEY, 		CTRL_C },
	{ ID_WINDOW_MANAGER, 	S_CLOSE_TEMPORARY,	E_KEY, 		ESCAPE },
	{ ID_WINDOW_MANAGER, 	S_CLOSE,		E_KEY, 		SHIFT_F4 },
	{ ID_WINDOW_MANAGER, 	S_CLOSE,		E_KEY, 		ALT_F4 },
	{ ID_WINDOW_MANAGER, 	S_CLOSE,		E_KEY, 		F3 },
	{ ID_WINDOW_MANAGER, 	S_REDISPLAY,		E_KEY, 		F5 },
	{ ID_WINDOW_MANAGER, 	L_NEXT_WINDOW,		E_KEY, 		ALT_F6 },
	{ ID_WINDOW_MANAGER, 	L_NEXT_WINDOW,		E_KEY, 		CTRL_TAB },
	{ ID_WINDOW_MANAGER, 	L_MOVE,			E_KEY, 		ALT_F7 },
	{ ID_WINDOW_MANAGER, 	L_SIZE,			E_KEY, 		ALT_F8 },
	{ ID_WINDOW_MANAGER, 	L_HELP,			E_KEY, 		ALT_F1 },

	// End of array.
	{ ID_END, 0, 0, 0 }
};
#elif defined(ZIL_MSWINDOWS)
static UI_EVENT_MAP eventMapTable[] =
{
	{ ID_WINDOW_OBJECT, 	L_UP,				WM_KEYDOWN, 	GRAY_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_UP,				WM_KEYDOWN, 	WHITE_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_DOWN,				WM_KEYDOWN, 	GRAY_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_DOWN,				WM_KEYDOWN, 	WHITE_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_LEFT,				WM_KEYDOWN, 	GRAY_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_LEFT,				WM_KEYDOWN, 	WHITE_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,			WM_KEYDOWN, 	GRAY_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,			WM_KEYDOWN, 	WHITE_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_PREVIOUS,			WM_CHAR, 		BACKTAB },
	{ ID_WINDOW_OBJECT, 	L_NEXT,				WM_CHAR, 		TAB },
	{ ID_WINDOW_OBJECT, 	L_SELECT,			WM_CHAR, 		ENTER },
	{ ID_WINDOW_OBJECT,		L_HELP,				WM_KEYUP, 		F1 },

	{ ID_STRING, 			L_BACKSPACE,		WM_KEYDOWN, 	BACKSPACE },
	{ ID_STRING, 			L_DELETE,			WM_KEYDOWN, 	GRAY_DELETE },
	{ ID_STRING, 			L_DELETE,			WM_KEYDOWN, 	WHITE_DELETE },
	{ ID_STRING, 			L_DELETE_EOL,		WM_KEYDOWN,		CTRL_WHITE_DELETE },
	{ ID_STRING, 			L_DELETE_EOL,		WM_KEYDOWN,		CTRL_GRAY_DELETE },

	{ ID_BUTTON, 			L_SELECT,			WM_CHAR, 		' ' },

	{ ID_LIST, 				L_SELECT,			WM_CHAR, 		' ' },

	{ ID_WINDOW_MANAGER, 	L_NEXT_WINDOW,		WM_SYSKEYDOWN, 	ALT_F6 },
	{ ID_WINDOW_MANAGER, 	L_HELP,				WM_SYSKEYUP, 	ALT_F1 },

	// End of array.
	{ ID_END, 0, 0, 0 }
};
#elif defined(ZIL_OS2)
static UI_EVENT_MAP eventMapTable[] =
{
	{ ID_WINDOW_OBJECT, 	L_EXIT,				WM_QUIT, 				0 },

	{ ID_WINDOW_OBJECT, 	L_BEGIN_SELECT,		WM_BUTTON1DOWN, 		M_LEFT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_BEGIN_SELECT,		WM_BUTTON1DBLCLK, 		M_LEFT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_SELECT,	WM_MOUSEMOVE, 			M_LEFT },
	{ ID_WINDOW_OBJECT, 	L_END_SELECT,		WM_BUTTON1UP, 			M_LEFT_CHANGE },

	{ ID_WINDOW_OBJECT, 	L_BEGIN_ESCAPE,		WM_BUTTON2DOWN, 		M_RIGHT | M_RIGHT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_BEGIN_ESCAPE,		WM_BUTTON2DBLCLK, 		M_RIGHT | M_RIGHT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_ESCAPE,	WM_MOUSEMOVE, 			M_RIGHT },
	{ ID_WINDOW_OBJECT, 	L_END_ESCAPE,		WM_BUTTON2UP, 			M_RIGHT_CHANGE },

	{ ID_WINDOW_OBJECT, 	L_SELECT,			WM_CHAR, 		ENTER },

	{ ID_WINDOW_OBJECT, 	L_UP,				WM_CHAR, 		GRAY_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_UP,				WM_CHAR, 		WHITE_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_DOWN,				WM_CHAR, 		GRAY_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_DOWN,				WM_CHAR, 		WHITE_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_LEFT,				WM_CHAR, 		GRAY_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_LEFT,				WM_CHAR, 		WHITE_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,			WM_CHAR, 		GRAY_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,			WM_CHAR, 		WHITE_RIGHT_ARROW },

	{ ID_COMBO_BOX, 		L_PGUP,				WM_CHAR, 		GRAY_PGUP },
	{ ID_COMBO_BOX, 		L_PGUP,				WM_CHAR, 		WHITE_PGUP },
	{ ID_COMBO_BOX, 		L_PGDN,				WM_CHAR, 		GRAY_PGDN },
	{ ID_COMBO_BOX, 		L_PGDN,				WM_CHAR, 		WHITE_PGDN },

	{ ID_BUTTON, 			L_SELECT,			WM_CHAR, 		' ' },

	// End of array.
	{ ID_END, 0, 0, 0 }
};
#elif defined(ZIL_MOTIF)
static UI_EVENT_MAP eventMapTable[] =
{
	{ ID_WINDOW_OBJECT,		L_BEGIN_SELECT,		ButtonPress,	M_LEFT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT,		L_CONTINUE_SELECT,	MotionNotify,	M_LEFT },
	{ ID_WINDOW_OBJECT,		L_END_SELECT,		ButtonRelease,	M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT,		L_BEGIN_ESCAPE,		ButtonPress,	M_RIGHT | M_RIGHT_CHANGE },
	{ ID_WINDOW_OBJECT,		L_CONTINUE_ESCAPE,	MotionNotify,	M_RIGHT },
	{ ID_WINDOW_OBJECT,		L_END_ESCAPE,		ButtonRelease,	M_RIGHT_CHANGE },
	{ ID_WINDOW_OBJECT,		L_SELECT,			KeyPress,		XK_Return,
		0 },
	{ ID_WINDOW_OBJECT,		L_SELECT,			KeyPress,		XK_KP_Enter,
		0 },
	{ ID_WINDOW_OBJECT, 	L_CANCEL,			KeyPress, 		XK_Escape },
	{ ID_WINDOW_OBJECT,		S_SIZE,				ConfigureNotify,0 },
	{ ID_WINDOW_OBJECT,		L_HELP,				KeyPress, 		XK_F1 },
	{ ID_WINDOW_OBJECT,		L_HELP,				KeyPress, 		XK_F1, Mod1Mask },
#if defined(__hpux)
	{ ID_WINDOW_OBJECT, 	L_UP,				KeyPress, 		osfXK_Up },
	{ ID_WINDOW_OBJECT, 	L_DOWN,				KeyPress, 		osfXK_Down },
	{ ID_WINDOW_OBJECT, 	L_LEFT,				KeyPress, 		osfXK_Left },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,			KeyPress, 		osfXK_Right },
	{ ID_WINDOW_OBJECT, 	L_PGUP,				KeyPress, 		osfXK_PageUp },
	{ ID_WINDOW_OBJECT, 	L_PGDN,				KeyPress, 		osfXK_PageDown },
#endif
	{ ID_WINDOW_OBJECT, 	L_UP,				KeyPress, 		XK_Up },
	{ ID_WINDOW_OBJECT, 	L_DOWN,				KeyPress, 		XK_Down },
	{ ID_WINDOW_OBJECT, 	L_LEFT,				KeyPress, 		XK_Left },
	{ ID_WINDOW_OBJECT, 	L_RIGHT,			KeyPress, 		XK_Right },
	{ ID_WINDOW_OBJECT, 	L_PGUP,				KeyPress, 		XK_Prior },
	{ ID_WINDOW_OBJECT, 	L_PGDN,				KeyPress, 		XK_Next },

	{ ID_BUTTON, 			L_SELECT,			KeyPress, 		XK_space },

	// End of array.
	{ ID_END, 0, 0, 0 }
};
#endif

UI_EVENT_MAP *_eventMapTable = eventMapTable;

