//	Zinc Interface Library - I_ZTCAT.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <conio.h>
#include <signal.h>
#include <dos.h>
#include <disp.h>
#include <controlc.h>
#include <stdlib.h>
#ifdef DOSX286
#include <phapi.h>
#endif
#include "ui_evt.hpp"

// ---- UI_TEXT_DISPLAY ----
static int _originalMode = -1;
static int _newLines = -1;

#define OutPortByte outp

void I_ScreenOpen(int *mode, int *lines, int *columns)
{
	union REGS inregs, outregs;

	// Save original text mode.
	if (_originalMode == -1)
		_originalMode = disp_getmode();
	if (*mode == TDM_43x80 &&
		_originalMode != 0 && _originalMode != 2 && _originalMode != 7)
	{
		disp_open();
		disp_close();
		disp_set43();
	}
	else if (*mode != TDM_AUTO)
		disp_setmode(*mode);
	disp_open();
	I_CursorRemove();

	// Check for special text mode monitors.
	*mode = disp_getmode();

	_newLines = *lines = disp_numrows;
	*columns = disp_numcols;
	// Turn the blink attribute off.
	inregs.x.ax = 0x1003;
	inregs.h.bl = 0x00;
	int86(0x10, &inregs, &outregs);

//	UCHAR newSetting = *((UCHAR _far *)MK_FP(0x40,0x65));
//	newSetting &= ~0x20;
//	OutPortByte(*((USHORT _far *)MK_FP(0x40, 0x63)) + 4, newSetting);
//	// Update BIOS data area
//	*((UCHAR _far *)MK_FP(0x40, 0x65)) = newSetting;
}

void I_ScreenClose(void)
{
	// Turn the blink attribute back on.
	union REGS inregs, outregs;
	inregs.x.ax = 0x1003;
	inregs.h.bl = 0x01;
	int86(0x10, &inregs, &outregs);

	disp_setcursortype(DISP_CURSORBLOCK);
	disp_move(0, 0);
	disp_eeop();
	disp_showcursor();
	disp_close();
	if (_newLines > 25)
		disp_reset43();
}

void I_ScreenPut(int left, int top, int right, int bottom, void *buffer)
{
	disp_pokebox(buffer, top - 1, left - 1, bottom - 1, right - 1);
}

void I_ScreenGet(int left, int top, int right, int bottom, void *buffer)
{
	disp_peekbox(buffer, top - 1, left - 1, bottom - 1, right - 1);
}

int I_ScreenColor(int color)
{
	return (color & 0x0f);
}

void I_CursorRemove(void)
{
	// Turn cursor off by positioning it off of the screen.
	disp_move(-1, -1);
	disp_flush();
}

void I_CursorPosition(int y, int x, int val)
{
	disp_move(y-1, x-1);
	disp_setcursortype((val == DC_INSERT) ? DISP_CURSORUL : DISP_CURSORBLOCK); \
	disp_flush();
}

//		  Narrow, Wide
#if defined(OEM)
	ichar_t _iCornerUL[] = { 0xDA, 0xC9 };
	ichar_t _iCornerUR[] = { 0xBF, 0xBB };
	ichar_t _iCornerLL[] = { 0xC0, 0xC8 };
	ichar_t _iCornerLR[] = { 0xD9, 0xBC };
	ichar_t _iHorizontal[] = { 0xC4, 0xCD };
	ichar_t _iVertical[] = { 0xB3, 0xBA };
	ichar_t _iLowerBox = 0xdc;
	ichar_t _iUpperBox = 0xdf;
	ichar_t _iFullBox = 0xdb;
	ichar_t *_iSBMiddleArrow = "\xfe";
#else
	ichar_t _iCornerUL[] = { 0x8d, 0x9d };
	ichar_t _iCornerUR[] = { 0x85, 0x95 };
	ichar_t _iCornerLL[] = { 0x86, 0x96 };
	ichar_t _iCornerLR[] = { 0x8c, 0x9c };
	ichar_t _iHorizontal[] = { 0x8a, 0x9a };
	ichar_t _iVertical[] = { 0x83, 0x93 };
	ichar_t _iLowerBox = 0x91;
	ichar_t _iUpperBox = 0x90;
	ichar_t _iFullBox = 0x92;
	ichar_t *_iSBMiddleArrow = "\x9e";
#endif
ichar_t *_iSBUpArrow = "";
ichar_t *_iSBDownArrow = "";
ichar_t *_iSBLeftArrow = "";
ichar_t *_iSBRightArrow = "";
ichar_t *_iWDownArrow = "[]";
ichar_t *_iWNormalMin = "[]";
ichar_t *_iWMinimized = "[]";
ichar_t *_iWNormalMax = "[]";
ichar_t *_iWMaximized = "[]";
ichar_t *_iActiveCheck   = "[X] ";
ichar_t *_iInactiveCheck = "[ ] ";
ichar_t *_iActiveRadio   = "() ";
ichar_t *_iInactiveRadio = "( ) ";
ichar_t *_iCheckMark = "*";

// ---- UID_MOUSE ----
static unsigned _oldMouseMask = 0;
static unsigned char _oldMouseState = 0;
static unsigned _mouseState = 0;
static int _horizontalMickeys = 0;
static int _verticalMickeys = 0;

#define mouseInt	0x33
#define mouseInit	0
#define mouseUninit	0
#define mouseMickeys	11
#define mouseSetFunction	12
#define mouseExgFunction	20
static int _stopInterrupt = FALSE;

#include <msmouse.h>

#if defined(DOS386)
extern void *_x386_zero_base_ptr;
#endif

static char _mouseStack[1024];

#if defined(DOS386) && defined(ZORTECH_BUG)
static msm_inited = 0;
static unsigned oldX = 0, oldY = 0;
#endif

void _cdecl MouseISR(unsigned, unsigned state, unsigned x, unsigned y)
{
	// Get the mouse information.
	if (!_stopInterrupt)
	{
		_stopInterrupt = TRUE;	// Prevent the interrupt from multiple calls.

		// Set up new mouse state. (Current state is in state)
#if defined(DOS386)
		_mouseState = ((((_oldMouseState ^ state) << 4) | state) << 8) |
			(*((UCHAR *) _x386_zero_base_ptr + 0x417L) & 0xF);
#else
		_mouseState = ((((_oldMouseState ^ state) << 4) | state) << 8) | (*((UCHAR far *)MK_FP(0x40, 0x17)) & 0xF);
#endif
		_oldMouseState = state;

		// Compute the mouse movement.
		int xCounter, yCounter;
#if defined(DOS386) && defined(ZORTECH_BUG)
		if (msm_inited)
		{
			xCounter = (int)(x - oldX);
			yCounter = (int)(y - oldY);
		}
		else
		{
			xCounter = yCounter = 0;
			msm_inited = 1;
		}
		oldX = x; oldY = y;
#else
		msm_readcounters(&xCounter, &yCounter);
#endif
		_horizontalMickeys += xCounter;
		_verticalMickeys += yCounter;

		// Set the internal mouse information for use in the Poll routine.
		if (mouseQueueEvent)
			mouseQueueEvent(_mouseState, &_horizontalMickeys, &_verticalMickeys);
		_stopInterrupt = FALSE;
	}
}

int I_MouseOpen(void)
{
	if (msm_init() != 0xFFFF)
		return FALSE;
	msm_signal(0xFF, MouseISR, &_mouseStack[1024]);
	return TRUE;
}

void I_MouseClose(void)
{
	msm_term();
}

void I_MouseHalt(int halt)
{
	_stopInterrupt = halt;
}

// ---- UID_KEYBOARD ----
static int _enhancedBios = 0;		// 0 or 0x10 (keyboard read)
static int _oldBreakState = 0;

#if __ZTC__ >= 0x310
static void _cdecl CtrlCHandler(void)
#else
static void _far _cdecl CtrlCHandler(void)
#endif
{
	if (UID_KEYBOARD::breakHandlerSet == 0)
		exit(1);
}

void I_KeyboardOpen(void)
{
	union REGS inregs, outregs;

	// Check for enhaced keyboard by calling extended shift status function.
	inregs.x.ax = 0x12FF;
	int86(0x16, &inregs, &outregs);
	if (outregs.h.al != 0xFF)
	{
		_enhancedBios = 0x10;
	}
	else
	{
		// Double check for enhanced keyboard BIOS according to the
		// IBM PS/2 Technical Reference manual, page 2-103
		inregs.h.ah = 0x05;
		inregs.x.cx = 0xFFFF;
		int86(0x16, &inregs, &outregs);
		if (outregs.h.al == 0x00)
		{
			// success, carry on, read that guy back ...
			inregs.h.ah = 0x10;
			for (int bufferIndex = 0; bufferIndex < 16; bufferIndex++)
			{
				int86(0x16, &inregs, &outregs);
				if (outregs.x.ax == 0xFFFF)
				{
					_enhancedBios = 0x10;
					break;
				}
			}
		}
	}
	// Set break interupt to ignore Control-Break/Control-C.
	_controlc_handler = CtrlCHandler;
	controlc_open();
	// Save previous state of Control-Break using INT 21H, 00H.
	inregs.x.ax = 0x3300;
	int86(0x21, &inregs, &outregs);
	_oldBreakState = outregs.h.dl;

	// Set Control-Break ON using INT 21H, 01H.
	inregs.x.ax = 0x3301;
	inregs.h.dl = 0x01;
	int86(0x21, &inregs, &outregs);
}

void I_KeyboardClose(void)
{
	union REGS inregs, outregs;

	// Set Control-Break status to previous status.
	inregs.x.ax = 0x3301;
	inregs.h.dl = _oldBreakState;
	int86(0x21, &inregs, &outregs);
}

void I_KeyboardRead(unsigned *rawCode, unsigned *shiftState, unsigned *value)
{
	union REGS inregs, outregs;

	inregs.h.ah = _enhancedBios + 0x00;
	int86(0x16, &inregs, &outregs);
	*rawCode = outregs.x.ax;
	*value = outregs.h.al;

	// Get the shift state using INT 16H, 12H(or 02H if not enhanced).
	inregs.h.ah = _enhancedBios + 0x02;
	int86(0x16, &inregs, &outregs);
	*shiftState = outregs.h.al;
	if (_enhancedBios && (outregs.x.ax & 0x0800) && *value != 0)
		*shiftState &= ~0x08;
}

int I_KeyboardQuery(unsigned *shiftState)
{
	union REGS inregs, outregs;

	// Test if keystroke waiting.
	inregs.h.ah = _enhancedBios + 0x01;
	int86(0x16, &inregs, &outregs);
	if (outregs.x.flags & 0x40)
	{
		// No keystroke waiting.
		// Check for ALT key using INT 16H, 02H.
		inregs.h.ah = _enhancedBios + 0x02;
		int86(0x16, &inregs, &outregs);
		*shiftState = outregs.h.al;
		return FALSE;
	}
	return TRUE;
}

