//	DRAW.C (PERSIST) - Draw functions (compiler specific).
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "draw.h"

#if defined(_MSC_VER)
#include <stdlib.h>
#include <graph.h>

void InitializeDisplay(void)
{
	if (!_setvideomode(_MAXRESMODE))
		exit(1);
}
void RestoreDisplay(void)
{
	_setvideomode(_DEFAULTMODE);
}
void DrawCircle(short column, short line, short radius)
{
	_ellipse(_GBORDER, column - radius, line - radius,
		column + radius, line + radius);
}
void DrawRectangle(short left, short top, short right, short bottom)
{
	_rectangle(_GBORDER, left, top, right, bottom);
}
void DrawTriangle(short *triangle)
{
	_polygon(_GBORDER, (struct _xycoord *)triangle, 4);
}

#elif defined(__ZTC__)
#include <stdlib.h>
#include <fg.h>

void InitializeDisplay(void)
{
	if (!fg_init())
		exit(1);
}
void RestoreDisplay(void)
{
	fg_term();
}
void DrawCircle(short column, short line, short radius)
{
	fg_drawellipse(FG_WHITE, FG_MODE_SET, ~0, column, line,
		radius, radius, 0, 3600, fg.displaybox);
}
void DrawRectangle(short left, short top, short right, short bottom)
{
	fg_box_t box;
	box[FG_X1] = left;
	box[FG_Y1] = top;
	box[FG_X2] = right;
	box[FG_Y2] = bottom;
	fg_drawbox(FG_WHITE, FG_MODE_SET, ~0, FG_LINE_SOLID,
		box, fg.displaybox);
}
void DrawTriangle(short *triangle)
{
	fg_drawpolygon(FG_WHITE, FG_MODE_SET, ~0, FG_LINE_SOLID,
		3, (int *)triangle, fg.displaybox);
}

#elif defined(__BORLANDC__)
#include <stdlib.h>
#include <graphics.h>

void InitializeDisplay(void)
{
	int mode;
	int driver = DETECT;
	initgraph(&driver, &mode, NULL);
	if (graphresult() != grOk)
		exit(1);
}
void RestoreDisplay(void)
{
	closegraph();
}
void DrawCircle(short column, short line, short radius)
{
	circle(column, line, radius);
}
void DrawRectangle(short left, short top, short right, short bottom)
{
	rectangle(left, top, right, bottom);
}
void DrawTriangle(short *triangle)
{
	drawpoly(4, (int *)triangle);
}
#endif
