# PERSIST tutorial makefile

#    make -fmicrosft.mak dos		      	(makes all the DOS persist tutorials)
#    make -fmicrosft.mak windows	      	(makes all the Windows persist tutorials)

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\C700\INCLUDE
#    set LIB=.;C:\ZINC\LIB\MSCPP700;C:\C700\LIB

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP_OPTS=-c -AL -BATCH -Gs
DOS_LINK_OPTS=/NOD /NOI /BATCH /STACK:5120 /SEGMENTS:256
DOS_OBJS=
DOS_LIBS=ms_lgfx llibce graphics oldnames

# ----- Windows compiler options --------------------------------------------

# --- Use the next 2 lines for Windows 3.0 compatibility ---
WIN_CPP_OPTS=-c -AL -BATCH -Gsw -DWINVER=0x0300
WIN_RC_OPTS=-k -30
# --- Use the next 2 lines for Windows 3.1 compatibility ---
#WIN_CPP_OPTS=-c -AL -BATCH -Gsw
#WIN_RC_OPTS=-k
WIN_LINK_OPTS=/NOD /NOI /BATCH /STACK:5120 /SEGMENTS:256
WIN_OBJS=
WIN_LIBS=libw llibcew oldnames

CPP=cl
LINK=link
RC=rc

.c.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.c.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc tutorial for Microsoft C++ type:
	@echo make -fmicrosft.mak dos
	@echo make -fmicrosft.mak windows
	@echo (Microsoft does not support OS/2 programs.)
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- DOS -----------------------------------------------------------------
dos: persist1.exe persist2.exe persist3.exe persist4.exe persist5.exe persist6.exe persist7.exe

persist1.exe: persist1.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist1.obj
$*,NUL,$(DOS_LIBS),NUL
<<

persist2.exe: persist2.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist2.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<

persist3.exe: persist3.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist3.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<

persist4.exe: persist4.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist4.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<

persist5.exe: persist5.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist5.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<

persist6.exe: persist6.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist6.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<

persist7.exe: persist7.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist7.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<

# ----- Windows -------------------------------------------------------------
windows: wpersist.exe

wpersist.exe: wpersist.obw wdraw.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+wpersist.obw+wdraw.obw
$*,NUL,$(WIN_LIBS),wpersist.def
<<
	$(RC) $(WIN_RC_OPTS) wpersist.rc $*.exe
