//	Zinc Interface Library - OEM_SYST.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "gfx.h"
#if defined(DOS386)
#	define _far
#endif

static unsigned short _far oem_syst_offset_table[] =
{
	0x0000, 0x0000, 0x0009, 0x0012, 0x001B, 0x0024, 0x002D, 0x0036,
	0x003F, 0x0048, 0x0051, 0x005A, 0x0063, 0x006C, 0x0075, 0x007E,
	0x0087, 0x0090, 0x0099, 0x00A2, 0x00AB, 0x00B4, 0x00BD, 0x00C6,
	0x00CF, 0x00D8, 0x00E1, 0x00EA, 0x00F3, 0x00FC, 0x0105, 0x010E,
	0x0117, 0x011E, 0x0121, 0x0127, 0x012F, 0x0136, 0x013E, 0x0148,
	0x014C, 0x0151, 0x0156, 0x015F, 0x0166, 0x016B, 0x0172, 0x0176,
	0x0180, 0x0188, 0x018F, 0x0197, 0x019F, 0x01A7, 0x01AF, 0x01B7,
	0x01BF, 0x01C7, 0x01CF, 0x01D2, 0x01D5, 0x01DC, 0x01E3, 0x01EA,
	0x01F1, 0x01F9, 0x0201, 0x0209, 0x0211, 0x0219, 0x0220, 0x0227,
	0x022F, 0x0237, 0x023A, 0x0241, 0x024A, 0x0251, 0x025A, 0x0262,
	0x026A, 0x0272, 0x027C, 0x0284, 0x028C, 0x0295, 0x029D, 0x02A6,
	0x02AF, 0x02B8, 0x02C1, 0x02CA, 0x02CF, 0x02D9, 0x02DE, 0x02E5,
	0x02ED, 0x02F1, 0x02F8, 0x02FF, 0x0306, 0x030D, 0x0314, 0x031A,
	0x0321, 0x0328, 0x032B, 0x0331, 0x0338, 0x033B, 0x0344, 0x034B,
	0x0352, 0x0359, 0x0360, 0x0367, 0x036E, 0x0373, 0x037A, 0x0381,
	0x038C, 0x0392, 0x0399, 0x039F, 0x03A5, 0x03A8, 0x03AE, 0x03B6,
	0x03BF, 0x03C7, 0x03CE, 0x03D5, 0x03DC, 0x03E3, 0x03EA, 0x03F1,
	0x03F9, 0x0400, 0x0407, 0x040E, 0x0415, 0x041C, 0x0421, 0x0429,
	0x0431, 0x0438, 0x0443, 0x044F, 0x0456, 0x045D, 0x0464, 0x046B,
	0x0472, 0x0479, 0x0481, 0x0489, 0x0492, 0x049B, 0x04A4, 0x04AC,
	0x04B5, 0x04BC, 0x04C1, 0x04C8, 0x04CF, 0x04D7, 0x04DF, 0x04E6,
	0x04ED, 0x04F4, 0x04FA, 0x0500, 0x050B, 0x0516, 0x0519, 0x0521,
	0x0529, 0x052B, 0x052D, 0x052F, 0x0531, 0x0533, 0x0535, 0x0537,
	0x0539, 0x053B, 0x053D, 0x053F, 0x0541, 0x0543, 0x0545, 0x0547,
	0x0549, 0x054B, 0x054D, 0x054F, 0x0551, 0x0553, 0x0555, 0x0557,
	0x0559, 0x055B, 0x055D, 0x055F, 0x0561, 0x0563, 0x0565, 0x0567,
	0x0569, 0x056B, 0x056D, 0x056F, 0x0571, 0x0573, 0x0575, 0x0577,
	0x0579, 0x057B, 0x057D, 0x057F, 0x0581, 0x0583, 0x0585, 0x0587,
	0x0589, 0x0592, 0x059A, 0x05A2, 0x05AB, 0x05B4, 0x05BD, 0x05C5,
	0x05CE, 0x05D7, 0x05DF, 0x05E9, 0x05F0, 0x05FB, 0x0603, 0x060A,
	0x0612, 0x061A, 0x0623, 0x062A, 0x0631, 0x0638, 0x063F, 0x0645,
	0x064D, 0x0654, 0x0658, 0x065C, 0x0667, 0x066E, 0x0674, 0x0679,
	0x067B
};


static unsigned char _far oem_syst_data_table[] =
{

	// Scan Line #1.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x61, 0x80, 0x0C, 0x0E, 0x00, 0x18, 0x00, 0xC0, 0x01, 0x8C,
	0x63, 0x1C, 0x0C, 0x00, 0x00, 0x00, 0x60, 0x03, 0x03, 0x0C, 0x00, 0x63,
	0x63, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 0xC3, 0x0C, 0x18, 0x00, 0xEC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,

	// Scan Line #2.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x6C, 0xD8, 0x60, 0x00, 0xE0, 0x63, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7C, 0x30, 0xF8, 0xF8, 0x19, 0xFC, 0xF9, 0xFC, 0xF8, 0xF8, 0x00, 0x60,
	0x18, 0x1E, 0x3E, 0x1C, 0x7E, 0x3E, 0x7C, 0x7E, 0xFC, 0xF9, 0x8D, 0x83,
	0x63, 0x30, 0x61, 0xB1, 0x9F, 0x3F, 0x1F, 0x0F, 0xC7, 0xCF, 0xF6, 0x36,
	0x1B, 0x0D, 0x86, 0xC3, 0x7F, 0xBC, 0x00, 0x78, 0x00, 0x06, 0x00, 0xC0,
	0x00, 0x30, 0x00, 0x00, 0x60, 0xC3, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xE0, 0x00, 0x00,
	0xF9, 0x98, 0xC3, 0xCC, 0xC6, 0x1B, 0x00, 0x3C, 0xCC, 0x63, 0x33, 0xC6,
	0x63, 0x36, 0x18, 0x00, 0x07, 0xFC, 0xF3, 0x31, 0x87, 0x86, 0x33, 0x63,
	0x63, 0x0C, 0x0F, 0x18, 0x6C, 0xC0, 0xE1, 0x86, 0x18, 0x30, 0xED, 0xB8,
	0xF1, 0xE1, 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
	0x80, 0x1F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0xF8, 0xFE, 0x3E, 0x00, 0x00,
	0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xF1, 0xE0, 0x00,

	// Scan Line #3.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x6C, 0xD8, 0x60, 0x01, 0xB0, 0x66, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06,
	0xC6, 0x71, 0x8D, 0x8C, 0x39, 0x81, 0x8D, 0x8D, 0x8D, 0x8C, 0x00, 0xC0,
	0x0C, 0x33, 0x63, 0x36, 0x63, 0x63, 0x66, 0x60, 0xC1, 0x8D, 0x8D, 0x83,
	0x66, 0x30, 0x73, 0xB9, 0xB1, 0xB1, 0xB1, 0x8C, 0x6C, 0x61, 0x86, 0x36,
	0x1B, 0x0D, 0x86, 0xC3, 0x01, 0xB1, 0x80, 0x18, 0xC0, 0x06, 0x00, 0xC0,
	0x00, 0x30, 0x03, 0x00, 0x60, 0xC3, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0x31, 0xD8, 0x01,
	0x8D, 0x99, 0x86, 0x6C, 0xC3, 0x0E, 0x00, 0x66, 0xCC, 0x33, 0x36, 0x63,
	0x00, 0x1C, 0x00, 0x00, 0x0D, 0xC1, 0x9B, 0x30, 0xCC, 0xC3, 0x33, 0x00,
	0x00, 0x0C, 0x19, 0x98, 0x6C, 0xC1, 0xB3, 0x0C, 0x30, 0x61, 0xB8, 0x00,
	0x1B, 0x31, 0x80, 0x00, 0x60, 0x0C, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
	0x80, 0x0C, 0x60, 0x00, 0x00, 0x00, 0x61, 0x8D, 0x83, 0x60, 0x00, 0x00,
	0x0C, 0x1F, 0x00, 0x06, 0x18, 0x03, 0x66, 0x0C, 0xE0, 0x03, 0xC0, 0x00,
	0x01, 0x9B, 0x60, 0x00,

	// Scan Line #4.
	0x7E, 0x3F, 0x0D, 0x81, 0x01, 0x80, 0xC0, 0x01, 0xFE, 0x00, 0x7F, 0x8F,
	0xC7, 0x81, 0xF1, 0xF8, 0x60, 0x80, 0x01, 0x0C, 0x19, 0x8F, 0xE3, 0xE0,
	0x00, 0x60, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC3, 0xFC, 0x03,
	0x6C, 0xD8, 0xF3, 0x81, 0xB0, 0x6C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x0C,
	0xC6, 0xF0, 0x0C, 0x0C, 0x79, 0x81, 0x80, 0x0D, 0x8D, 0x8D, 0x81, 0x80,
	0x06, 0x33, 0x63, 0x63, 0x63, 0x60, 0x63, 0x60, 0xC1, 0x81, 0x8D, 0x83,
	0x6C, 0x30, 0x7F, 0xB9, 0xB1, 0xB1, 0xB1, 0x8C, 0x6C, 0x01, 0x86, 0x36,
	0x1B, 0x0C, 0xCC, 0x66, 0x03, 0x30, 0xC0, 0x19, 0xE0, 0x06, 0x00, 0xC0,
	0x00, 0x30, 0x07, 0x80, 0x60, 0x00, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0x33, 0x70, 0x01,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1C, 0x1C, 0x7E, 0x00, 0x18, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E,
	0x63, 0x3F, 0x18, 0x0C, 0xCC, 0xC1, 0x80, 0x00, 0x00, 0x00, 0x01, 0x8C,
	0xFB, 0x30, 0x00, 0x00, 0x63, 0x0C, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x31,
	0x80, 0x06, 0x00, 0x00, 0x00, 0x01, 0xF9, 0x8D, 0x83, 0x30, 0x00, 0x00,
	0xD8, 0x31, 0xBF, 0x86, 0x0E, 0x0E, 0x60, 0x0C, 0xE3, 0xB6, 0x60, 0x00,
	0x3D, 0x98, 0xC0, 0x00,

	// Scan Line #5.
	0xA5, 0x6D, 0x9F, 0xC3, 0x83, 0xC1, 0xE0, 0x01, 0xFE, 0x3C, 0x61, 0x83,
	0x4C, 0xC1, 0xB1, 0x99, 0x68, 0xE0, 0x07, 0x1E, 0x19, 0x9B, 0x66, 0x10,
	0x00, 0xF0, 0x78, 0x18, 0x02, 0x08, 0x00, 0x02, 0x41, 0xE1, 0xF8, 0x03,
	0x01, 0xFD, 0x9B, 0x99, 0xB0, 0xCC, 0x19, 0x98, 0x60, 0x00, 0x00, 0x18,
	0xCE, 0x30, 0x18, 0x0C, 0xD9, 0x81, 0x80, 0x19, 0x8D, 0x8D, 0xB3, 0x00,
	0x03, 0x06, 0x6F, 0x63, 0x63, 0x60, 0x63, 0x60, 0xC1, 0x81, 0x8D, 0x83,
	0x78, 0x30, 0x6D, 0xBD, 0xB1, 0xB1, 0xB1, 0x8C, 0x6C, 0x01, 0x86, 0x36,
	0x1B, 0x0C, 0x78, 0x3C, 0x06, 0x30, 0x60, 0x1B, 0x30, 0x03, 0x3C, 0xF8,
	0xF9, 0xF3, 0xC6, 0x1F, 0x7C, 0xC3, 0x66, 0xDF, 0xCF, 0x8F, 0x3E, 0x3E,
	0xF8, 0xFB, 0xD9, 0xB3, 0x66, 0x6D, 0xB3, 0x7C, 0xC6, 0x30, 0x00, 0x01,
	0x81, 0x99, 0xE3, 0xC7, 0x8F, 0x1E, 0x63, 0x3C, 0x78, 0xF0, 0xC1, 0x86,
	0x36, 0x36, 0x60, 0x7F, 0x98, 0xC0, 0xF1, 0xE3, 0xCC, 0xD9, 0xB3, 0x63,
	0x63, 0x6D, 0x98, 0x07, 0x8F, 0x81, 0x83, 0xC6, 0x3C, 0xCD, 0xF1, 0xCD,
	0x9B, 0x31, 0x80, 0x00, 0x66, 0x0C, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xB1, 0xB0,
	0x3F, 0xC3, 0x07, 0xF3, 0x33, 0xFB, 0x0D, 0x8D, 0x83, 0x18, 0x7F, 0x8F,
	0x98, 0x31, 0x80, 0x3F, 0xC3, 0xB8, 0x60, 0x0C, 0x06, 0xE6, 0x60, 0x00,
	0x61, 0x99, 0x80, 0x00,

	// Scan Line #6.
	0xA5, 0x6D, 0x9F, 0xC7, 0xC3, 0xC3, 0xF0, 0x61, 0xFE, 0x7E, 0x4C, 0x86,
	0x4C, 0xC1, 0xF1, 0xF8, 0xF0, 0xF8, 0x1F, 0x3F, 0x19, 0x9B, 0x63, 0xC0,
	0x01, 0xF8, 0xFC, 0x18, 0x03, 0x18, 0x18, 0x06, 0x61, 0xE1, 0xF8, 0x03,
	0x00, 0xD9, 0x80, 0x30, 0xE0, 0x0C, 0x18, 0xF0, 0x60, 0x00, 0x00, 0x30,
	0xDE, 0x30, 0x30, 0x79, 0x99, 0xF9, 0xF8, 0x30, 0xF8, 0xFC, 0x36, 0x0F,
	0xC1, 0x8C, 0x6F, 0x63, 0x7E, 0x60, 0x63, 0x7C, 0xF9, 0x81, 0xFD, 0x83,
	0x70, 0x30, 0x61, 0xBD, 0xB1, 0xBF, 0x31, 0x8F, 0xC7, 0xC1, 0x86, 0x36,
	0x1B, 0x0C, 0x30, 0x18, 0x0C, 0x30, 0x30, 0x18, 0x00, 0x00, 0x06, 0xCD,
	0x83, 0x36, 0x6F, 0x33, 0x66, 0xC3, 0x6C, 0xDB, 0x6C, 0xD9, 0xB3, 0x66,
	0xCD, 0x81, 0x99, 0xB3, 0x66, 0x6D, 0xB3, 0x0D, 0x80, 0x18, 0x00, 0x61,
	0x81, 0x9B, 0x30, 0x60, 0xC1, 0x83, 0x60, 0x66, 0xCD, 0x98, 0xC1, 0x86,
	0x63, 0x63, 0x60, 0x0C, 0xDF, 0xF9, 0x9B, 0x36, 0x6C, 0xD9, 0xB3, 0x63,
	0x63, 0x6C, 0x3E, 0x03, 0x0C, 0x01, 0x80, 0x66, 0x66, 0xCD, 0x99, 0xCD,
	0x9B, 0x31, 0x80, 0x00, 0x6C, 0x0D, 0xB3, 0x1B, 0x6C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x31, 0xB0,
	0x19, 0x81, 0x8C, 0xC3, 0x36, 0xE3, 0x0D, 0xFD, 0x83, 0x3C, 0xCC, 0xD9,
	0xDF, 0x31, 0xBF, 0x86, 0x07, 0x1C, 0x60, 0x0D, 0xF0, 0x03, 0xC0, 0x00,
	0x61, 0x9B, 0xE0, 0x00,

	// Scan Line #7.
	0x81, 0x7F, 0x9F, 0xCF, 0xEF, 0xF7, 0xF8, 0xF1, 0xCE, 0x66, 0x5E, 0x9F,
	0x0C, 0xC1, 0x81, 0x9B, 0x9C, 0xFE, 0x7F, 0x0C, 0x19, 0x9B, 0x66, 0x60,
	0x00, 0x60, 0x30, 0x18, 0x7F, 0xBF, 0xD8, 0x0F, 0xF3, 0xF0, 0xF0, 0x03,
	0x00, 0xD8, 0xF0, 0x61, 0xEC, 0x0C, 0x1B, 0xFD, 0xF8, 0x1F, 0x80, 0x60,
	0xF6, 0x30, 0x60, 0x0D, 0xFC, 0x0D, 0x8C, 0x61, 0x8C, 0x0C, 0x06, 0x00,
	0x01, 0x8C, 0x6F, 0x7F, 0x63, 0x60, 0x63, 0x60, 0xC1, 0x9D, 0x8D, 0x83,
	0x78, 0x30, 0x61, 0xB7, 0xB1, 0xB0, 0x31, 0x8C, 0xC0, 0x61, 0x86, 0x36,
	0x1B, 0x0C, 0x78, 0x18, 0x18, 0x30, 0x18, 0x18, 0x00, 0x00, 0x3E, 0xCD,
	0x83, 0x36, 0x66, 0x33, 0x66, 0xC3, 0x78, 0xDB, 0x6C, 0xD9, 0xB3, 0x66,
	0xC1, 0x81, 0x99, 0xB3, 0x66, 0x67, 0x33, 0x19, 0x80, 0x18, 0x00, 0xF1,
	0x81, 0x9B, 0x33, 0xE7, 0xCF, 0x9F, 0x60, 0x66, 0xCD, 0x98, 0xC1, 0x86,
	0x63, 0x63, 0x7C, 0x7C, 0xD8, 0xC1, 0x9B, 0x36, 0x6C, 0xD9, 0xB3, 0x63,
	0x63, 0x6C, 0x18, 0x0F, 0xCC, 0xC3, 0xC3, 0xE6, 0x66, 0xCD, 0x99, 0xEC,
	0xF9, 0xE1, 0x80, 0x00, 0x7B, 0xCF, 0x73, 0x36, 0x36, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3F, 0x30,
	0x19, 0x81, 0x8C, 0xC3, 0x36, 0xC3, 0x0D, 0x8C, 0xC6, 0x66, 0xCC, 0xDB,
	0xD8, 0x31, 0x80, 0x06, 0x1C, 0x07, 0x60, 0x0C, 0x03, 0xB0, 0x00, 0x00,
	0xC0, 0x00, 0x0F, 0x00,

	// Scan Line #8.
	0xBD, 0x7F, 0x9F, 0xC7, 0xCF, 0xF7, 0xF8, 0xF1, 0xCE, 0x66, 0x5E, 0xB1,
	0x87, 0x81, 0x81, 0x9B, 0x9C, 0xFC, 0x3F, 0x0C, 0x19, 0x8F, 0x66, 0x60,
	0x01, 0xF8, 0x30, 0x18, 0x7F, 0xBF, 0xD8, 0x0F, 0xF3, 0xF0, 0xF0, 0x03,
	0x01, 0xFC, 0x18, 0xC3, 0x38, 0x0C, 0x18, 0xF0, 0x60, 0x00, 0x00, 0xC0,
	0xE6, 0x30, 0xC0, 0x0C, 0x18, 0x0D, 0x8C, 0x61, 0x8C, 0x0D, 0x83, 0x0F,
	0xC3, 0x0C, 0x6E, 0x63, 0x63, 0x60, 0x63, 0x60, 0xC1, 0x8D, 0x8D, 0x83,
	0x6C, 0x30, 0x61, 0xB7, 0xB1, 0xB0, 0x33, 0x8C, 0x60, 0x61, 0x86, 0x36,
	0x1B, 0x6C, 0xCC, 0x18, 0x30, 0x30, 0x0C, 0x18, 0x00, 0x00, 0x66, 0xCD,
	0x83, 0x37, 0xE6, 0x33, 0x66, 0xC3, 0x70, 0xDB, 0x6C, 0xD9, 0xB3, 0x66,
	0xC0, 0xF1, 0x99, 0xB3, 0x66, 0x67, 0x33, 0x30, 0xC6, 0x30, 0x01, 0x99,
	0x81, 0x9B, 0xF6, 0x6C, 0xD9, 0xB3, 0x60, 0x7E, 0xFD, 0xF8, 0xC1, 0x86,
	0x7F, 0x7F, 0x60, 0xCF, 0xD8, 0xC1, 0x9B, 0x36, 0x6C, 0xD9, 0xB3, 0x63,
	0x63, 0x6D, 0x98, 0x03, 0x0D, 0xE1, 0x86, 0x66, 0x66, 0xCD, 0x99, 0xBC,
	0x00, 0x03, 0x00, 0x00, 0x36, 0xC6, 0xF3, 0x6C, 0x1B, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x31, 0xB0,
	0x19, 0x83, 0x0C, 0xC3, 0x30, 0xC3, 0x0D, 0x8C, 0xC6, 0x66, 0xCC, 0xDE,
	0xD8, 0x31, 0xBF, 0x80, 0x00, 0x00, 0x60, 0x0C, 0xE6, 0xE0, 0x00, 0x00,
	0xC0, 0x00, 0x0F, 0x00,

	// Scan Line #9.
	0x99, 0x61, 0x8F, 0x83, 0x8D, 0xB3, 0xF0, 0x61, 0xFE, 0x7E, 0x4C, 0xB1,
	0x83, 0x07, 0x83, 0xB8, 0xF0, 0xF0, 0x0F, 0x3F, 0x00, 0x03, 0x63, 0xC7,
	0xF8, 0xF0, 0x30, 0x7E, 0x03, 0x18, 0x1F, 0xE6, 0x67, 0xF8, 0x60, 0x00,
	0x00, 0xD9, 0x99, 0x83, 0x18, 0x0C, 0x19, 0x98, 0x60, 0x00, 0x01, 0x80,
	0xC6, 0x31, 0x80, 0x0C, 0x18, 0x0D, 0x8C, 0x61, 0x8C, 0x0D, 0x81, 0x80,
	0x06, 0x00, 0x60, 0x63, 0x63, 0x60, 0x63, 0x60, 0xC1, 0x8D, 0x8D, 0xB3,
	0x66, 0x30, 0x61, 0xB3, 0xB1, 0xB0, 0x31, 0x8C, 0x60, 0x61, 0x86, 0x33,
	0x33, 0xFD, 0x86, 0x18, 0x60, 0x30, 0x06, 0x18, 0x00, 0x00, 0x66, 0xCD,
	0x83, 0x36, 0x06, 0x33, 0x66, 0xC3, 0x78, 0xDB, 0x6C, 0xD9, 0xB3, 0x66,
	0xC0, 0x19, 0x99, 0xB3, 0x66, 0x6D, 0xB3, 0x60, 0xC6, 0x30, 0x03, 0x0D,
	0x8D, 0x9B, 0x06, 0x6C, 0xD9, 0xB3, 0x63, 0x60, 0xC1, 0x80, 0xC1, 0x86,
	0x63, 0x63, 0x60, 0xCC, 0x18, 0xC1, 0x9B, 0x36, 0x6C, 0xD9, 0xB3, 0x63,
	0x63, 0x3F, 0x18, 0x0F, 0xCC, 0xC1, 0x86, 0x66, 0x66, 0xCD, 0x99, 0x9D,
	0xFB, 0xF6, 0x6F, 0xBE, 0x61, 0x8D, 0xFB, 0x36, 0x36, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x31, 0xB0,
	0x19, 0x86, 0x0C, 0xC3, 0x30, 0xC1, 0xF9, 0x8C, 0x6C, 0x66, 0x7F, 0x9C,
	0xCC, 0x31, 0x80, 0x3F, 0xDF, 0xBF, 0x60, 0x0C, 0xE0, 0x00, 0x0E, 0x0D,
	0x80, 0x00, 0x0F, 0x00,

	// Scan Line #10.
	0x81, 0x73, 0x87, 0x01, 0x01, 0x80, 0xC0, 0x01, 0xFE, 0x3C, 0x61, 0xB1,
	0x8F, 0xCF, 0x87, 0xB9, 0x68, 0xC0, 0x03, 0x1E, 0x19, 0x83, 0x68, 0x67,
	0xF8, 0x60, 0x30, 0x3C, 0x02, 0x08, 0x00, 0x02, 0x47, 0xF8, 0x60, 0x03,
	0x00, 0xD8, 0xF3, 0x3B, 0x1C, 0x06, 0x30, 0x00, 0x01, 0xC0, 0x3B, 0x00,
	0xC6, 0x31, 0x8D, 0x8C, 0x19, 0x8D, 0x8C, 0x61, 0x8D, 0x8C, 0x30, 0xC0,
	0x0C, 0x0C, 0x60, 0x63, 0x63, 0x63, 0x66, 0x60, 0xC1, 0x8D, 0x8D, 0xB3,
	0x63, 0x30, 0x61, 0xB3, 0xB1, 0xB0, 0x31, 0xCC, 0x6C, 0x61, 0x86, 0x31,
	0xE3, 0x9D, 0x86, 0x18, 0x60, 0x30, 0x03, 0x18, 0x00, 0x00, 0x66, 0xCD,
	0x83, 0x36, 0x66, 0x33, 0x66, 0xC3, 0x6C, 0xDB, 0x6C, 0xD9, 0xB3, 0x66,
	0xC0, 0x19, 0x99, 0x9E, 0x3F, 0xCD, 0xB3, 0x60, 0xC6, 0x30, 0x03, 0x0C,
	0xF9, 0x9B, 0x36, 0x6C, 0xD9, 0xB3, 0x3E, 0x66, 0xCD, 0x98, 0xC1, 0x86,
	0x63, 0x63, 0x60, 0xCC, 0xD8, 0xC1, 0x9B, 0x36, 0x6C, 0xD9, 0xB3, 0x63,
	0x63, 0x0C, 0x18, 0xC3, 0x0C, 0xC1, 0x86, 0x66, 0x66, 0xCD, 0x99, 0x9C,
	0x00, 0x06, 0x68, 0x02, 0xC3, 0x18, 0x33, 0x1B, 0x6C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x3F, 0x30,
	0x19, 0x8C, 0x6C, 0xC3, 0xE0, 0xC0, 0x61, 0x8C, 0x6C, 0x66, 0x00, 0x0F,
	0x87, 0xB1, 0x80, 0x00, 0x00, 0x00, 0x60, 0x0C, 0x00, 0x00, 0x0E, 0xE7,
	0x80, 0x00, 0x0F, 0x00,

	// Scan Line #11.
	0x7E, 0x3F, 0x02, 0x00, 0x03, 0xC1, 0xE0, 0x01, 0xFE, 0x00, 0x7F, 0x9F,
	0x03, 0x07, 0x03, 0x80, 0x60, 0x00, 0x00, 0x0C, 0x19, 0x83, 0x67, 0xC7,
	0xFB, 0xFC, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0xD8, 0x60, 0x39, 0xF6, 0x03, 0x60, 0x00, 0x01, 0xC0, 0x38, 0x00,
	0x7C, 0xFD, 0xFC, 0xF8, 0x3C, 0xF8, 0xF8, 0x60, 0xF8, 0xF8, 0x30, 0x60,
	0x18, 0x0C, 0x3F, 0x63, 0x7E, 0x3E, 0x7C, 0x7E, 0xC0, 0xF9, 0x8D, 0x9E,
	0x61, 0xBF, 0x61, 0xB1, 0x9F, 0x30, 0x1F, 0x6C, 0x67, 0xC1, 0x83, 0xE0,
	0xC3, 0x0D, 0x86, 0x18, 0x7F, 0xBC, 0x00, 0x78, 0x00, 0x00, 0x3E, 0xF8,
	0xF9, 0xF3, 0xC6, 0x1F, 0x66, 0xC3, 0x66, 0xDB, 0x6C, 0xCF, 0x3E, 0x3E,
	0xC1, 0xF1, 0x8F, 0x8C, 0x19, 0x8D, 0x9F, 0x7C, 0x76, 0xE0, 0x03, 0xFC,
	0x30, 0xF9, 0xE3, 0xE7, 0xCF, 0x9F, 0x0C, 0x3C, 0x78, 0xF0, 0xC1, 0x86,
	0x63, 0x63, 0x7E, 0x7F, 0x98, 0xFC, 0xF1, 0xE3, 0xC7, 0xCF, 0x9F, 0x3E,
	0x3E, 0x0C, 0x3F, 0x83, 0x0C, 0x61, 0x83, 0xE6, 0x3C, 0x7D, 0x99, 0x8C,
	0x00, 0x03, 0xC8, 0x02, 0x07, 0xC0, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xB0, 0x30,
	0x19, 0x9F, 0xE7, 0x83, 0x00, 0xC3, 0xFC, 0xF9, 0xEF, 0x3C, 0x00, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0C, 0x00, 0x00, 0x0E, 0xE3,
	0x00, 0x00, 0x0F, 0x00,

	// Scan Line #12.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xCC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,

	// Scan Line #13.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x33, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,

	// Scan Line #14.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};


static FONT oem_syst =
{
	oem_syst_offset_table,
	oem_syst_data_table,

	208,		// The number of bytes in each row of the bitmap.
	 14,		// The number of rows in the bitmap.
	  0,		// The first character in the bitmap.
	255,		// The last character in the bitmap.
	 12,		// The widest character, in bits.
	 10,		// The distance from the baseline to the top of a character.
	 11,		// The distance from the top to the underline bar.
	  0 		// The flag for a ROM resident font.
};

FONT *GFX_oem_syst_font (void)
{
	return (&oem_syst);
}
