//	Zinc Interface Library - D_CURSOR.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_evt.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

#define gnd	BACKGROUND
#define BLK	BLACK
static UCHAR _insert[32] =
{
	0, 0, 2, 14,
	BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,
	BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK
};
static UCHAR _overstrike[18] =
{
	0, 0, 1, 14,
	BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK
};

// ----- UID_CURSOR ---------------------------------------------------------

static int _upToDate = TRUE;

EVENT_TYPE UID_CURSOR::Event(const UI_EVENT &event)
{
	// Switch on the raw code.
	DEVICE_STATE oldState = state;
	DEVICE_IMAGE oldImage = image;
	UI_POSITION oldPosition = position;
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		oldState = D_OFF;
		break;

	case S_DEINITIALIZE:
		state = D_HIDE;
		break;

	case D_OFF:
	case D_ON:
		state = event.type;
		break;

	case S_POSITION:
		position = event.position;
		if (state == D_HIDE)
			state = D_ON;
		break;

	case DC_INSERT:
	case DC_OVERSTRIKE:
		image = ccode;
		state = D_ON;
		break;
	}

	// Reset the cursor information.
	if (oldImage == image && oldState == state && oldPosition == position)
		return (ccode);
	if (state == D_ON && display->isText && position.column >= 0 &&
		position.column < display->columns && position.line >= 0 &&
		position.line < display->lines)
		I_CursorPosition(position.line+1, position.column+1, image);
	else if (display->isText)
		I_CursorRemove();		
	else if (state == D_ON)
	{
		UCHAR *bitmapImage = (image == DC_INSERT) ? _insert : _overstrike;
		offset.column = offset.line = 0;
		_upToDate = display->DeviceSet(CURSOR_IMAGE, position.column, 
			position.line, bitmapImage[2], display->TextHeight(NULL) + 1,
			&bitmapImage[4]);
	}
	else
		_upToDate = display->DeviceMove(CURSOR_IMAGE, display->columns,
			display->lines);

	// Return the control code.
	return (ccode);
}

void UID_CURSOR::Poll(void)
{
	// Make sure the cursor is valid.
	static UI_TIME lastTime;
	if (!installed || state == D_OFF || display->isText)
		return;

	// Check the blink state of the cursor.
	UI_TIME currentTime;
	long elapsedTime = currentTime - lastTime;								// BUG.1228
	if (Abs(elapsedTime) > blinkRate)
	{
		lastTime = currentTime;
		if (state == D_ON)
		{
			_upToDate = display->DeviceMove(CURSOR_IMAGE, display->columns,
				display->lines);
			state = D_HIDE;
		}
		else
		{
			_upToDate = display->DeviceMove(CURSOR_IMAGE,
				position.column + offset.column, position.line + offset.line);
			state = D_ON;
		}
	}
	// Cursor could not be updated during a previous paint operation.
	else if (!_upToDate)
	{
		DEVICE_IMAGE newImage = image;
		image = 0;
		Event(UI_EVENT(newImage));
		_upToDate = TRUE;
	}
}

