//	Zinc Interface Library - ISO_SMAL.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "gfx.h"
#if defined(DOS386)
#	define _far
#endif

static unsigned short _far iso_smal_offset_table[] =
{
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0006, 0x0008, 0x000D, 0x0014, 0x001A, 0x0021, 0x002A,
	0x002D, 0x0031, 0x0035, 0x003D, 0x0043, 0x0047, 0x004D, 0x0050,
	0x0058, 0x005F, 0x0065, 0x006C, 0x0073, 0x007A, 0x0081, 0x0088,
	0x008F, 0x0096, 0x009D, 0x00A0, 0x00A3, 0x00A9, 0x00AF, 0x00B5,
	0x00BB, 0x00C2, 0x00C9, 0x00D0, 0x00D7, 0x00DE, 0x00E4, 0x00EA,
	0x00F1, 0x00F8, 0x00FA, 0x0100, 0x0107, 0x010D, 0x0115, 0x011B,
	0x0122, 0x0129, 0x0132, 0x0139, 0x0140, 0x0148, 0x014F, 0x0157,
	0x015F, 0x0167, 0x016F, 0x0177, 0x017B, 0x0183, 0x0187, 0x018D,
	0x0194, 0x0196, 0x019C, 0x01A2, 0x01A8, 0x01AE, 0x01B4, 0x01B9,
	0x01BF, 0x01C5, 0x01C7, 0x01CC, 0x01D2, 0x01D4, 0x01DC, 0x01E2,
	0x01E8, 0x01EE, 0x01F4, 0x01FA, 0x0200, 0x0204, 0x020A, 0x0210,
	0x021A, 0x021F, 0x0225, 0x022A, 0x022F, 0x0231, 0x0236, 0x023D,
	0x0245, 0x0245, 0x0245, 0x0245, 0x0245, 0x0245, 0x0245, 0x0245,
	0x0245, 0x0245, 0x0245, 0x0245, 0x0245, 0x0245, 0x0245, 0x0245,
	0x0245, 0x0247, 0x0247, 0x0247, 0x0247, 0x0247, 0x0247, 0x0247,
	0x0247, 0x0247, 0x0247, 0x0247, 0x0247, 0x0247, 0x0247, 0x0247,
	0x0247, 0x024D, 0x024F, 0x0257, 0x025F, 0x0267, 0x026F, 0x0271,
	0x0278, 0x027E, 0x0289, 0x028F, 0x0296, 0x029D, 0x02A3, 0x02AE,
	0x02B4, 0x02BA, 0x02C2, 0x02C7, 0x02CC, 0x02CF, 0x02D6, 0x02DE,
	0x02E1, 0x02E7, 0x02EB, 0x02F1, 0x02F8, 0x0302, 0x030C, 0x0317,
	0x031D, 0x0324, 0x032B, 0x0332, 0x0339, 0x0340, 0x0347, 0x0352,
	0x0359, 0x035F, 0x0365, 0x036B, 0x0371, 0x0374, 0x0377, 0x037C,
	0x0381, 0x0389, 0x0390, 0x0397, 0x039E, 0x03A5, 0x03AC, 0x03B3,
	0x03BA, 0x03C3, 0x03CA, 0x03D1, 0x03D8, 0x03DF, 0x03E7, 0x03EF,
	0x03F6, 0x03FC, 0x0402, 0x0408, 0x040F, 0x0415, 0x041B, 0x0425,
	0x042C, 0x0432, 0x0438, 0x043E, 0x0444, 0x0448, 0x044C, 0x0452,
	0x0458, 0x045F, 0x0466, 0x046C, 0x0472, 0x0478, 0x047F, 0x0485,
	0x048A, 0x0491, 0x0497, 0x049D, 0x04A3, 0x04A9, 0x04AF, 0x04B6,
	0x04BC
};


static unsigned char _far iso_smal_data_table[] =
{

	// Scan Line #1.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x1C, 0x48, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0xE7, 0x00, 0x1C, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
	0x00, 0x06, 0x00, 0x01, 0x01, 0x06, 0x19, 0x24, 0x30, 0x00, 0x00, 0x20,
	0x23, 0x12, 0x44, 0xC9, 0x00, 0x32, 0x40, 0x20, 0xC3, 0x24, 0x80, 0x00,
	0x08, 0x04, 0x18, 0x48, 0x10, 0x00, 0x01, 0x01, 0x08, 0x00, 0x01, 0x80,
	0x00, 0x04, 0x04, 0x20, 0x08, 0x22, 0x00, 0x00, 0x01, 0x01, 0x08, 0x00,
	0x00, 0x00, 0x20, 0x21, 0x00, 0x00, 0x00, 0x00,

	// Scan Line #2.
	0x02, 0x92, 0x42, 0x00, 0x18, 0x11, 0x40, 0x00, 0x00, 0x00, 0x00, 0x78,
	0x43, 0xC7, 0x81, 0x3F, 0x3C, 0xFC, 0xF1, 0xE0, 0x01, 0x01, 0x03, 0x8F,
	0x0C, 0x7C, 0x79, 0xE3, 0xEF, 0x9E, 0x42, 0x82, 0x85, 0x04, 0x14, 0x4F,
	0x3E, 0x3C, 0x3E, 0x3C, 0xFE, 0x85, 0x05, 0x05, 0x05, 0x05, 0xFD, 0xC0,
	0x1C, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x01, 0x04, 0x28, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x60, 0x00,
	0x04, 0x04, 0x08, 0x70, 0x01, 0x05, 0x22, 0x48, 0xFC, 0x38, 0x00, 0x00,
	0x07, 0xE0, 0x08, 0x80, 0x25, 0x24, 0x00, 0x00, 0x01, 0x8E, 0x00, 0x40,
	0x10, 0x09, 0x00, 0x40, 0x82, 0x09, 0x26, 0x24, 0x48, 0x6F, 0x9E, 0x10,
	0x44, 0x92, 0x29, 0x29, 0x3C, 0x4C, 0x20, 0x41, 0x24, 0xC4, 0x80, 0x00,
	0x44, 0x08, 0x24, 0x48, 0x21, 0xC0, 0x00, 0x82, 0x14, 0x65, 0x12, 0x40,
	0x00, 0x02, 0x08, 0x52, 0x24, 0x45, 0x22, 0x7C, 0xC8, 0x82, 0x14, 0x65,
	0x10, 0x00, 0x10, 0x42, 0x91, 0x08, 0x02, 0x20,

	// Scan Line #3.
	0x02, 0x92, 0x42, 0x30, 0x24, 0x12, 0x20, 0x00, 0x00, 0x00, 0x02, 0x84,
	0xC4, 0x28, 0x43, 0x20, 0x42, 0x85, 0x0A, 0x10, 0x02, 0x00, 0x84, 0x50,
	0x92, 0x42, 0x85, 0x12, 0x08, 0x21, 0x42, 0x82, 0x89, 0x06, 0x36, 0x50,
	0xA1, 0x42, 0x21, 0x42, 0x10, 0x85, 0x05, 0x05, 0x05, 0x04, 0x05, 0x10,
	0x04, 0x40, 0x00, 0x08, 0x00, 0x08, 0x02, 0x01, 0x04, 0x28, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x90,
	0x04, 0x04, 0xF8, 0x89, 0x05, 0x05, 0x10, 0x01, 0x02, 0x04, 0x00, 0x00,
	0x08, 0x10, 0x08, 0x84, 0x08, 0x44, 0x01, 0xF8, 0x00, 0x91, 0x00, 0x42,
	0x10, 0x82, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x30, 0x98, 0x21, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF0, 0x44, 0x22, 0x99, 0x11, 0x80,
	0x00, 0x01, 0x10, 0x8A, 0x22, 0x88, 0xA2, 0x81, 0x30, 0x44, 0x22, 0x99,
	0x13, 0x01, 0x08, 0x84, 0x51, 0x11, 0xC2, 0x20,

	// Scan Line #4.
	0x02, 0x92, 0x47, 0x31, 0x24, 0x14, 0x12, 0x21, 0x00, 0x00, 0x04, 0x8D,
	0x40, 0x20, 0x45, 0x20, 0x40, 0x05, 0x0A, 0x16, 0x04, 0x00, 0x44, 0x50,
	0xA1, 0x42, 0x81, 0x0A, 0x08, 0x20, 0x42, 0x82, 0x91, 0x05, 0x56, 0x50,
	0xA1, 0x42, 0x21, 0x40, 0x10, 0x85, 0x05, 0x04, 0x88, 0x88, 0x09, 0x08,
	0x04, 0xA0, 0x00, 0x08, 0x00, 0x08, 0x05, 0x01, 0x00, 0x08, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x60,
	0x04, 0x01, 0x14, 0x80, 0xF8, 0x89, 0x08, 0x02, 0x39, 0x3C, 0x00, 0x00,
	0x13, 0x88, 0x07, 0x04, 0x11, 0x24, 0x02, 0x48, 0x00, 0x91, 0x00, 0x44,
	0x11, 0x09, 0x20, 0x01, 0x83, 0x06, 0x0C, 0x18, 0x31, 0x08, 0x20, 0x7D,
	0xF7, 0xDF, 0x28, 0x84, 0x21, 0x42, 0x78, 0xF1, 0xE3, 0xC7, 0x88, 0x91,
	0x90, 0xA1, 0x42, 0x85, 0x04, 0xF9, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,

	// Scan Line #5.
	0x02, 0x07, 0xE8, 0x82, 0x18, 0x04, 0x11, 0x41, 0x00, 0x00, 0x08, 0x94,
	0x40, 0x40, 0x49, 0x3E, 0x40, 0x09, 0x0A, 0x16, 0xC8, 0x7C, 0x20, 0x93,
	0xA1, 0x42, 0x81, 0x0A, 0x08, 0x20, 0x42, 0x82, 0xA1, 0x04, 0x95, 0x50,
	0xA1, 0x42, 0x21, 0x40, 0x10, 0x85, 0x05, 0x04, 0x50, 0x50, 0x11, 0x04,
	0x05, 0x10, 0x01, 0xCF, 0x1E, 0x79, 0xC4, 0x3D, 0xE4, 0x29, 0x2E, 0xCF,
	0x1C, 0xF1, 0xEF, 0x1E, 0xE8, 0xA2, 0x88, 0xA5, 0x17, 0x91, 0x10, 0x00,
	0x84, 0x05, 0x20, 0x81, 0x04, 0x51, 0x14, 0x02, 0x41, 0x44, 0x48, 0x00,
	0x12, 0x48, 0x00, 0x3F, 0xBC, 0xC8, 0x8A, 0x4B, 0x01, 0xD1, 0x48, 0x49,
	0x12, 0x06, 0x48, 0x42, 0x44, 0x89, 0x12, 0x24, 0x49, 0x08, 0x20, 0x41,
	0x04, 0x10, 0x28, 0x84, 0x21, 0x62, 0x85, 0x8A, 0x14, 0x28, 0x45, 0x22,
	0x50, 0xA1, 0x42, 0x84, 0x88, 0x85, 0x09, 0xC7, 0x1C, 0x70, 0xE3, 0x8E,
	0xE4, 0x27, 0x1C, 0x71, 0xC4, 0x42, 0x08, 0x21, 0xE1, 0xC7, 0x1C, 0x70,
	0xE0, 0x23, 0x45, 0x14, 0x51, 0x44, 0xF2, 0x20,

	// Scan Line #6.
	0x02, 0x02, 0x48, 0x04, 0x29, 0x04, 0x17, 0xF7, 0xC1, 0xF0, 0x10, 0xA4,
	0x40, 0x83, 0x91, 0x01, 0x7C, 0x10, 0xF1, 0xF0, 0xD0, 0x00, 0x11, 0x12,
	0xBF, 0x7C, 0x81, 0x0B, 0xCF, 0x23, 0x7E, 0x82, 0xC1, 0x04, 0x15, 0x50,
	0xBE, 0x42, 0x3E, 0x3C, 0x10, 0x85, 0x05, 0x04, 0x20, 0x20, 0x21, 0x02,
	0x04, 0x00, 0x00, 0x28, 0xA0, 0x8A, 0x2E, 0x45, 0x14, 0x2A, 0x29, 0x28,
	0xA2, 0x8A, 0x28, 0xA0, 0x48, 0xA2, 0x88, 0xA5, 0x10, 0xA0, 0x08, 0x01,
	0x44, 0x05, 0x21, 0xE1, 0x04, 0xF8, 0x22, 0x02, 0x41, 0x3C, 0x90, 0x07,
	0xD3, 0x88, 0x00, 0x04, 0x00, 0x00, 0x8A, 0x4B, 0x00, 0x0E, 0x24, 0x53,
	0x14, 0xE0, 0x98, 0x44, 0x28, 0x50, 0xA1, 0x42, 0x85, 0xFF, 0x20, 0x41,
	0x04, 0x10, 0x28, 0x84, 0x79, 0x52, 0x85, 0x0A, 0x14, 0x28, 0x42, 0x24,
	0x50, 0xA1, 0x42, 0x84, 0x50, 0x85, 0x70, 0x20, 0x82, 0x08, 0x10, 0x41,
	0x14, 0x08, 0xA2, 0x8A, 0x24, 0x42, 0x08, 0x71, 0x12, 0x28, 0xA2, 0x89,
	0x17, 0xA5, 0x45, 0x14, 0x51, 0x44, 0x8A, 0x20,

	// Scan Line #7.
	0x02, 0x07, 0xE7, 0x08, 0x46, 0x04, 0x11, 0x41, 0x00, 0x00, 0x20, 0xC4,
	0x41, 0x00, 0x5F, 0x81, 0x42, 0x21, 0x08, 0x10, 0x08, 0x7C, 0x21, 0x13,
	0x21, 0x42, 0x81, 0x0A, 0x08, 0x21, 0x42, 0x82, 0xA1, 0x04, 0x14, 0xD0,
	0xA0, 0x46, 0x22, 0x02, 0x10, 0x85, 0x05, 0x24, 0x50, 0x20, 0x41, 0x01,
	0x04, 0x00, 0x01, 0xE8, 0xA0, 0x8B, 0xE4, 0x45, 0x14, 0x2C, 0x29, 0x28,
	0xA2, 0x8A, 0x28, 0x1C, 0x48, 0xA2, 0x88, 0x99, 0x11, 0x11, 0x10, 0x02,
	0x24, 0x05, 0x44, 0x81, 0x04, 0x21, 0x22, 0x02, 0x41, 0x01, 0x20, 0x00,
	0x12, 0x48, 0x00, 0x04, 0x00, 0x00, 0x89, 0xCB, 0x00, 0x00, 0x12, 0x25,
	0x09, 0x21, 0x28, 0x84, 0x28, 0x50, 0xA1, 0x42, 0x85, 0x08, 0x20, 0x79,
	0xE7, 0x9E, 0x28, 0x84, 0x21, 0x4A, 0x85, 0x0A, 0x14, 0x28, 0x45, 0x24,
	0x50, 0xA1, 0x42, 0x84, 0x20, 0x85, 0x09, 0xE7, 0x9E, 0x78, 0xF3, 0xCF,
	0xF4, 0x0F, 0xBE, 0xFB, 0xE4, 0x42, 0x08, 0x89, 0x12, 0x28, 0xA2, 0x89,
	0x10, 0x29, 0x45, 0x14, 0x51, 0x44, 0x8A, 0x20,

	// Scan Line #8.
	0x00, 0x02, 0x40, 0x90, 0x42, 0x04, 0x12, 0x21, 0x00, 0x00, 0x40, 0x84,
	0x42, 0x00, 0x41, 0x01, 0x42, 0x21, 0x08, 0x16, 0x04, 0x00, 0x40, 0x10,
	0x21, 0x42, 0x81, 0x0A, 0x08, 0x21, 0x42, 0xA2, 0x91, 0x04, 0x14, 0xD0,
	0xA0, 0x42, 0x21, 0x02, 0x10, 0x84, 0x89, 0x54, 0x88, 0x20, 0x81, 0x00,
	0x84, 0x00, 0x02, 0x28, 0xA0, 0x8A, 0x04, 0x45, 0x14, 0x2A, 0x29, 0x28,
	0xA2, 0x8A, 0x28, 0x02, 0x48, 0xA2, 0x88, 0x99, 0x12, 0x11, 0x10, 0x04,
	0x14, 0x04, 0xF8, 0x80, 0xF8, 0xF9, 0x14, 0x02, 0x39, 0x7C, 0x93, 0xF0,
	0x13, 0x48, 0x00, 0x00, 0x00, 0x00, 0x88, 0x48, 0x00, 0x1F, 0x24, 0x4F,
	0x90, 0x42, 0x7D, 0x17, 0xEF, 0xDF, 0xBF, 0x7E, 0xFD, 0x08, 0x21, 0x41,
	0x04, 0x10, 0x28, 0x84, 0x21, 0x4A, 0x85, 0x0A, 0x14, 0x28, 0x48, 0x98,
	0x90, 0xA1, 0x42, 0x84, 0x20, 0xF9, 0x0A, 0x28, 0xA2, 0x89, 0x14, 0x51,
	0x04, 0x28, 0x20, 0x82, 0x04, 0x42, 0x08, 0x89, 0x12, 0x28, 0xA2, 0x89,
	0x13, 0x31, 0x45, 0x14, 0x51, 0x44, 0x8A, 0x20,

	// Scan Line #9.
	0x02, 0x02, 0x48, 0xA3, 0x43, 0x02, 0x20, 0x00, 0x0C, 0x06, 0x80, 0x84,
	0x44, 0x28, 0x41, 0x21, 0x42, 0x21, 0x0A, 0x16, 0xC2, 0x00, 0x81, 0x10,
	0x21, 0x42, 0x85, 0x12, 0x08, 0x21, 0x42, 0xA2, 0x89, 0x04, 0x14, 0x50,
	0xA0, 0x43, 0x21, 0x42, 0x10, 0x84, 0x51, 0x8D, 0x04, 0x21, 0x01, 0x00,
	0x44, 0x00, 0x02, 0x28, 0xA0, 0x8A, 0x24, 0x45, 0x14, 0x29, 0x29, 0x28,
	0xA2, 0x8A, 0x28, 0x02, 0x48, 0x94, 0x55, 0x25, 0x14, 0x11, 0x10, 0x04,
	0x14, 0x04, 0x80, 0x85, 0x04, 0x21, 0x08, 0x01, 0x02, 0x00, 0x48, 0x10,
	0x08, 0x10, 0x00, 0x3F, 0x80, 0x00, 0xF0, 0x48, 0x08, 0x00, 0x48, 0x81,
	0x20, 0x84, 0x09, 0x14, 0x28, 0x50, 0xA1, 0x42, 0x85, 0x08, 0x1E, 0x41,
	0x04, 0x10, 0x28, 0x84, 0x22, 0x46, 0x85, 0x0A, 0x14, 0x28, 0x40, 0x1F,
	0x10, 0xA1, 0x42, 0x84, 0x20, 0x81, 0x72, 0x28, 0xA2, 0x89, 0x14, 0x51,
	0x13, 0xC8, 0xA2, 0x8A, 0x24, 0x42, 0x08, 0x89, 0x12, 0x28, 0xA2, 0x89,
	0x13, 0x1E, 0x45, 0x14, 0x51, 0x44, 0xF2, 0x20,

	// Scan Line #10.
	0x02, 0x02, 0x47, 0x03, 0x3C, 0x81, 0x40, 0x00, 0x0C, 0x06, 0x00, 0x79,
	0xF7, 0xE7, 0x83, 0x9E, 0x3C, 0x20, 0xF1, 0xE0, 0xC1, 0x01, 0x01, 0x0F,
	0xA1, 0x7C, 0x79, 0xE3, 0xE8, 0x1E, 0x42, 0x9C, 0x85, 0xF4, 0x14, 0x4F,
	0x20, 0x3C, 0xA1, 0x3C, 0x10, 0x78, 0x21, 0x05, 0x04, 0x21, 0xFD, 0xC0,
	0x1C, 0x00, 0x01, 0xEF, 0x1E, 0x79, 0xC4, 0x3D, 0x14, 0x28, 0xA9, 0x28,
	0x9C, 0xF1, 0xE8, 0x3C, 0x47, 0x88, 0x22, 0x24, 0xF7, 0x8D, 0x60, 0x07,
	0xF4, 0x05, 0x01, 0xF8, 0x00, 0x31, 0x04, 0x00, 0xFC, 0x00, 0x00, 0x10,
	0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x80, 0x48, 0x08, 0x00, 0x00, 0x01,
	0x01, 0xE0, 0x08, 0xE4, 0x28, 0x50, 0xA1, 0x42, 0x85, 0x0F, 0x84, 0x7D,
	0xF7, 0xDF, 0x28, 0x84, 0x3C, 0x42, 0x78, 0xF1, 0xE3, 0xC7, 0x80, 0x20,
	0x0F, 0x1E, 0x3C, 0x78, 0x21, 0xC1, 0x01, 0xE7, 0x9E, 0x7C, 0xF3, 0xCF,
	0xE0, 0x87, 0x1C, 0x71, 0xC4, 0x42, 0x08, 0x71, 0x11, 0xC7, 0x1C, 0x70,
	0xE0, 0x20, 0x3C, 0xF3, 0xCF, 0x3C, 0x81, 0xE0,

	// Scan Line #11.
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xC0, 0x20,

	// Scan Line #12.
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x01, 0xC0, 0x00, 0x00,
	0x00, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x03, 0xC0
};


static FONT iso_smal =
{
	iso_smal_offset_table,
	iso_smal_data_table,

	152,		// The number of bytes in each row of the bitmap.
	 12,		// The number of rows in the bitmap.
	  0,		// The first character in the bitmap.
	255,		// The last character in the bitmap.
	 11,		// The widest character, in bits.
	  9,		// The distance from the baseline to the top of a character.
	 10,		// The distance from the top to the underline bar.
	  0 		// The flag for a ROM resident font.
};

FONT *GFX_iso_smal_font (void)
{
	return (&iso_smal);
}
