//	NOTEPAD.CPP (NOTEPAD) - Simple "Notepad" in a window.
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

//  May be freely copied, used and distributed.

#include <ui_win.hpp>

int UI_APPLICATION::Main(void)
{
	// The UI_APPLICATION constructor automatically initializes the 
	// display, eventManager, and windowManager variables.

	// Create two notepad windows.
	UIW_WINDOW *window1 = new UIW_WINDOW(5, 2, 45, 12);
	*window1
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON(SYF_GENERIC)
		+ new UIW_TITLE("Notepad 1")
		+ new UIW_PROMPT(2, 1, "&Subject:  ")
		+ new UIW_STRING(2, 2, 40, "", 50)
		+ new UIW_PROMPT(2, 3, "&Date:  ")
		+ new UIW_STRING(2, 4, 40, "", 50)
		+ new UIW_PROMPT(2, 5, "&Note:  ")
		+ new UIW_TEXT(2, 6, 40, 4, "", 256);
	UIW_WINDOW *window2 = new UIW_WINDOW(10, 4, 45, 12);
	*window2
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON(SYF_GENERIC)
		+ new UIW_TITLE("Notepad 2")
		+ new UIW_PROMPT(2, 1, "&Subject:  ")
		+ new UIW_STRING(2, 2, 40, "", 50)
		+ new UIW_PROMPT(2, 3, "&Date:  ")
		+ new UIW_STRING(2, 4, 40, "", 50)
		+ new UIW_PROMPT(2, 5, "&Note:  ")
		+ new UIW_TEXT(2, 6, 40, 4, "", 256);

	// Add the window to the window manager.
	*windowManager
		+ window1
		+ window2;

	// Wait for user response.
	UI_EVENT event;
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	return (0);
}
