# GENHELP, ICO2DAT, and BMP2DAT program makefile

#    make -fborland.mak dos		      	(makes the DOS genhelp/ico2dat programs)
#    make -fborland.mak windows	      	(makes the Windows genhelp/ico2dat program)
#    make -fborland.mak os2	      	 	(makes the OS/2 genhelp/ico2dat program)

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB\BTCPP310;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB\BTCPP310;C:BORLANDC\LIB

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
DOS_OBJS=c0l
# --- Use the next line for UI_GRAPHICS_DISPLAY ---
DOS_LIBS=dos_zil dos_gfx bc_lgfx emu mathl cl
# --- Use the next line for UI_BGI_DISPLAY ---
#DOS_LIBS=dos_zil dos_bgi graphics emu mathl cl

# ----- Windows compiler options --------------------------------------------
WIN_CPP_OPTS=-c -ml -O -WE -w
WIN_LINK_OPTS=/c /C /Twe /x
WIN_OBJS=c0wl
WIN_LIBS=win_zil mathwl import cwl

# ----- OS/2 compiler options -----------------------------------------------
OS2_CPP_OPTS=-c
OS2_LINK_OPTS=/c /B:0x10000 /aa
OS2_OBJS=c02.obj
OS2_LIBS=os2_zil.lib c2.lib os2.lib

CPP=bcc
LINK=tlink

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }

.cpp.obo:
	$(CPP) $(OS2_CPP_OPTS) -o$*.obo {$< }

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make the genhelp and ico2dat programs for Borland C++ type:
	@echo make -fborland.mak dos
	@echo make -fborland.mak windows
	@echo make -fborland.mak os2
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- DOS -----------------------------------------------------------------
dos: genhelp.exe ico2dat.exe bmp2dat.exe
	copy genhelp.exe ..\..\bin
	copy ico2dat.exe ..\..\bin
	copy bmp2dat.exe ..\..\bin

genhelp.exe: genhelp.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+genhelp.obj
$*, ,$(DOS_LIBS)
!

ico2dat.exe : ico2dat.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+ico2dat.obj
$*, ,$(DOS_LIBS)
!

bmp2dat.exe : bmp2dat.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+bmp2dat.obj
$*, ,$(DOS_LIBS)
!

# ----- Windows -------------------------------------------------------------
windows: wgenhelp.exe
	copy wgenhelp.exe ..\..\bin

wgenhelp.exe: genhelp.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+genhelp.obw
$*, ,$(WIN_LIBS),wgenhelp.def
!
	rc wgenhelp.rc $<

# ----- OS/2 ----------------------------------------------------------------
os2: ogenhelp.exe oico2dat.exe
	copy ogenhelp.exe ..\..\bin
	copy oico2dat.exe ..\..\bin

ogenhelp.exe: genhelp.obo
	$(LINK) $(OS2_LINK_OPTS) @&&!
$(OS2_OBJS)+genhelp.obo
$*, ,$(OS2_LIBS),ogenhelp.def
!
	rc ogenhelp.rc $<

