//	Zinc Interface Library - Z_UTILS.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <stdarg.h>
#include <locale.h>
#include <string.h>
#include <ctype.h>
#include "ui_gen.hpp"

#if defined(QDeckX)
static struct lconv _lconv = {
	".", ",", "\3", "USD", "$", ".", ",", "\3",
	"", "-", 2, 2, 1, 0, 1, 0, 0, 0
};

struct lconv *localeconv( void )
{
	return &_lconv;
}

char *setlocale( int category, const char *locale )
{
}

#endif


char *ui_strdup(const char *srcString)
{
	// strdup using new instead of malloc.
	if (!srcString || srcString[0] == '\0')
		return (NULL);
	char *destString = new char[strlen(srcString) + 1];
	strcpy(destString, srcString);
	return (destString);
}

int ui_strlen(const char *string)
{
	// Return the length of a string.
	return (string ? strlen(string) : 0);
}

void ui_strrepc(char *string, int c, int repc)
{
	if (!string)
		return;

	// Replace a character (c) in a string to a new character (repc).
	while (*string)
	{
		if (*string == c)
			*string = repc;
		string++;
	}
}

void ui_strstrip(char *string, int c)
{
	if (!string)
		return;

	// strip all occurances of c out of string
	char *src = string;
	char *dest = string;
	do {
		while (*src == c)
			src++;
	} while ((*dest++ = *src++) != 0);
}

char *ui_itoa(int value, char *string, int radix)
{
	switch(radix)
	{
		case 16:
			::sprintf(string, "%x", value);
			break;
		case 10:
			::sprintf(string, "%d", value);
			break;
	}
	return string;
}


//	ui_WildStrcmp() is a strcmp() that handles the * and ? wildcards
//	in pattern.
int ui_WildStrcmp(char *str, char *pattern)
{
	for ( ;  *str && (*str == *pattern || *pattern == '?' || *pattern == '*');
			str++, pattern++)
		if (*pattern == '*') {
			// Compress multiple astrisks, eg: "**".
			while (*++pattern == '*')
				;	// Update pattern count.
			if (!*pattern)
				return(0);		// pattern ended in *.
			char *nextTest = str;
			do {
				nextTest = strchr(nextTest, *pattern);
				if (!nextTest)
				{
					pattern--;
					break;
				}
				if (!ui_WildStrcmp(nextTest, pattern)) {
					str = nextTest;
					break;
				}
				nextTest++;
			} while (nextTest);
		}
	while (*pattern == '*')
		pattern++;
	return *str - *pattern;
}

int ui_stricmp(const char *a, const char *b)
{
	char la, lb;

	for (;;) {
		la = *a; lb = *b;
		if (islower(la)) la = toupper(la);
		if (islower(lb)) lb = toupper(lb);
	if (la != lb || !la) break;
		a++; b++;
	}
	return la - lb;
}

int ui_strnicmp(const char *a, const char *b, int n)
{
	char la, lb;

	for (;;) {
		la = *a; lb = *b;
		if (islower(la)) la = toupper(la);
		if (islower(lb)) lb = toupper(lb);
	if (la != lb || !la || !n) break;
		a++; b++; n--;
	}
	if (n)
		return la - lb;
	return(0);
}

void ui_strupr(char *a)
{
	while (*a)
	{
		if (islower(*a)) *a = toupper(*a);
		a++;
	}
}

void ui_strlwr(char *a)
{
	while (*a)
	{
		if (isupper(*a)) *a = tolower(*a);
		a++;
	}
}
