//	Zinc Interface Library - Z_WIN.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#define USE_RAW_KEYS			// Zinc raw keys.
#include "ui_win.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

#if defined(__hpux)
SCREENID UI_WINDOW_MANAGER::currentScreenID;	// Fix for HP compiler bug.
#else
SCREENID UI_WINDOW_MANAGER::currentScreenID = ID_SCREEN;
#endif

// ----- UI_WINDOW_MANAGER --------------------------------------------------

UI_WINDOW_MANAGER::UI_WINDOW_MANAGER(UI_DISPLAY *_display, UI_EVENT_MANAGER *_eventManager,
	EVENT_TYPE (*_exitFunction)(UI_DISPLAY *display, UI_EVENT_MANAGER *eventManager, UI_WINDOW_MANAGER *windowManager)) :
	UIW_WINDOW(0, 0, _display->columns, _display->lines),
	exitFunction(_exitFunction)
{
#if defined(ZIL_LINKBUG)
	extern void z_win2_dummy(void);		// Bug fix for broken linkers.
	z_win2_dummy();
	extern void z_event_dummy(void);	// Bug fix for broken linkers.
	z_event_dummy();
	extern void z_pnorm_dummy(void);	// Bug fix for broken linkers.
	z_pnorm_dummy();
	extern void z_hotkey_dummy(void);	// Bug fix for broken linkers.
	z_hotkey_dummy();
#if defined(ZIL_PERSISTENCE)
	extern void z_jump_dummy(void);		// Bug fix for broken linkers.
	z_jump_dummy();
#endif
#endif

	// Initialize the window manager information.
	windowID[0] = ID_WINDOW_MANAGER;
	windowID[1] = ID_WINDOW;

	if (!_display->isText)
		woStatus |= WOS_GRAPHICS;
	currentScreenID = screenID = ID_SCREEN;
	display = _display;
	eventManager = _eventManager;
	windowManager = this;

#if defined(ZIL_MSWINDOWS) && !defined(WIN32)
	// Initialize the class registration module.
	extern int ZincClassInitialize(HANDLE hInstance);
	ZincClassInitialize(display->hInstance);
#elif defined(ZIL_MOTIF)
	screenID = shell = display->topShell;
#endif
}

UI_WINDOW_MANAGER::~UI_WINDOW_MANAGER(void)
{
	UI_WINDOW_OBJECT *object;

	// Remove all objects from the window manager.
	for (object = First(); object; object = First())
	{
		UI_LIST::Subtract(object);
		if (object->screenID)
		{
#if defined(ZIL_MSWINDOWS)
			object->woStatus |= WOS_WINDOWS_ACTION;
			DestroyWindow(object->screenID);
#elif defined(ZIL_OS2)
			WinDestroyWindow(object->screenID);
#endif
		}
		object->Event(UI_EVENT(S_DEINITIALIZE, 0));
		if (!FlagSet(object->woAdvancedFlags, WOAF_NO_DESTROY))
			delete object;
	}

#if defined(ZIL_MSDOS)
	if (pasteBuffer)
		delete pasteBuffer;
	pasteBuffer = NULL;
	pasteLength = 0;
#elif defined(ZIL_MSWINDOWS) && !defined(WIN32)
	extern int ZincClassRestore(HANDLE hInstance);
	ZincClassRestore(display->hInstance);
	PostQuitMessage(0);
#endif

	windowManager = NULL;
	eventManager = NULL;
	display = NULL;
}

void UI_WINDOW_MANAGER::Center(UI_WINDOW_OBJECT *object)
{
	// Compute the actual screen size according to the window status.
	long columns = display->columns;
	long lines = display->lines;
	if (FlagSet(object->woStatus, WOS_GRAPHICS))
		;
	else if (FlagSet(object->woFlags, WOF_MINICELL))
	{
		columns = columns * display->miniNumeratorX / display->miniDenominatorX;
		lines = lines * display->miniNumeratorY / display->miniDenominatorY;
	}
	else
	{
		columns /= display->cellWidth;
		lines /= display->cellHeight;
	}

	// Compute the center location on the screen.
	int width = object->relative.Width();
	int height = object->relative.Height();

	// Update the window according to the center position.
	object->relative.left = (int)(columns - width) / 2;
	object->relative.top = (int)(lines - height) / 2;
	object->relative.right = object->relative.left + width - 1;
	object->relative.bottom = object->relative.top + height - 1;
	object->true = object->relative;

	// Re-display the window if it already is present on the screen.
	if (Index(object) != -1)
		UI_WINDOW_MANAGER::Add(object);
}

void *UI_WINDOW_MANAGER::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_WINDOW_MANAGER;
	switch (request)
	{
	case GET_NUMBERID_OBJECT:
	case GET_STRINGID_OBJECT:
		{
		void *match = NULL;
		for (UI_WINDOW_OBJECT *object = First(); object && !match; object = object->Next())
			match = object->UI_WINDOW_OBJECT::Information(request, data, objectID);
		data = match;
		}
		break;

	default:
		return (NULL);
	}

	// Return the information.
	return (data);
}


