//	MACRO.HPP (MACRO) - Macro tutorial program definitions.
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

//  May be freely copied, used and distributed.

const DEVICE_TYPE E_MACRO	= 89;		// Make sure we are last to be Polled.

struct MACRO_PAIR
{
	RAW_CODE rawCode;
	char *macro;
};

class MACRO_HANDLER : public UI_DEVICE
{
public:
	MACRO_HANDLER(MACRO_PAIR *_macroTable) : UI_DEVICE(E_MACRO, D_OFF),
		macroTable(_macroTable) { installed = TRUE; }
	EVENT_TYPE Event(const UI_EVENT &event);

private:
	MACRO_PAIR *macroTable;
	MACRO_PAIR *currentMacro;
	int offset;

	void Poll(void);
};
