# PERSIST tutorial makefile

#    make -fborland.mak dos		      	(makes all the DOS persist tutorials)
#    make -fborland.mak windows	      	(makes all the Windows persist tutorials)
#    make -fborland.mak os2		      	(makes all the OS/2 persist tutorials)

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:\BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
DOS_OBJS=c0l
DOS_LIBS=graphics emu mathl cl

# ----- Windows compiler options --------------------------------------------

# --- Use the next 2 lines for Windows 3.0 compatibility ---
WIN_CPP_OPTS=-c -ml -O -WE -w -DWINVER=0x0300
WIN_RC_OPTS=-k -30
# --- Use the next 2 lines for Windows 3.1 compatibility ---
#WIN_CPP_OPTS=-c -ml -O -WE -w
#WIN_RC_OPTS=-k
WIN_LINK_OPTS=/c /C /Twe /x
WIN_OBJS=c0wl
WIN_LIBS=mathwl import cwl

# ----- OS/2 compiler options -----------------------------------------------
OS2_CPP_OPTS=-c
OS2_LINK_OPTS=/c /B:0x10000 /aa
OS2_OBJS=c02.obj
OS2_LIBS=os2_zil.lib c2.lib os2.lib

CPP=bcc
LINK=tlink
RC=rc

.c.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.c.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }

.c.obo:
	$(CPP) $(OS2_CPP_OPTS) -o$*.obo {$< }

.cpp.obo:
	$(CPP) $(OS2_CPP_OPTS) -o$*.obo {$< }

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc tutorial for Borland C++ type:
	@echo make -fborland.mak dos
	@echo make -fborland.mak windows
	@echo make -fborland.mak os2
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- DOS -----------------------------------------------------------------
dos: persist1.exe persist2.exe persist3.exe persist4.exe persist5.exe persist6.exe persist7.exe

persist1.exe: persist1.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist1.obj
$*, ,$(DOS_LIBS)
!

persist2.exe: persist2.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist2.obj+draw.obj
$*, ,$(DOS_LIBS)
!

persist3.exe: persist3.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist3.obj+draw.obj
$*, ,$(DOS_LIBS)
!

persist4.exe: persist4.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist4.obj+draw.obj
$*, ,$(DOS_LIBS)
!

persist5.exe: persist5.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist5.obj+draw.obj
$*, ,$(DOS_LIBS)
!

persist6.exe: persist6.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist6.obj+draw.obj
$*, ,$(DOS_LIBS)
!

persist7.exe: persist7.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist7.obj+draw.obj
$*, ,$(DOS_LIBS)
!

# ----- Windows -------------------------------------------------------------
windows: wpersist.exe

wpersist.exe: wpersist.obw wdraw.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+wpersist.obw wdraw.obw
$*, ,$(WIN_LIBS),wpersist.def
!
	$(RC) $(WIN_RC_OPTS) wpersist.rc $<

# ----- OS/2 ----------------------------------------------------------------
os2: opersist.exe

opersist.exe: opersist.obo odraw.obo
	$(LINK) $(OS2_LINK_OPTS) @&&!
$(OS2_OBJS)+opersist.obo odraw.obo
$*, ,$(OS2_LIBS),opersist.def
!
	$(RC) opersist.rc $<

