//	PERSIST8.CPP (PERSIST) - Abstract read from disk into Microsoft Windows.
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

//  May be freely copied, used and distributed.

#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

// Persistent code definition files.
#include "draw.h"
#include "persist.hpp"

/*	_drawingArea is the blank widget we use for drawing. */
Widget _drawingArea;

/*#if (__BORLANDC__ >= 0x0300 || defined _MSC_VER) */
GRAPHIC_OBJECT::JUMP_ELEMENT GRAPHIC_OBJECT::_jumpTable[] =
/*#else */
/*JUMP_ELEMENT GRAPHIC_OBJECT::_jumpTable[] = */
/*#endif  */
{
	{ ID_CIRCLE, 	CIRCLE::New },
	{ ID_RECTANGLE,	RECTANGLE::New },
	{ ID_TRIANGLE,	TRIANGLE::New },
	{ 0, NULL }		// end of array.
};

#define byteSwap(val)	((val) = (unsigned short)(val) >> 8 | (val) << 8)

GRAPHIC_OBJECT *GRAPHIC_OBJECT::New(FILE *file)
{
	// Read the type from disk.
	short type;
	int fileObject = fread(&type, sizeof(type), 1, file);
	if (!fileObject)
		return (NULL);
	byteSwap(type);

	// Get the New pointer and create the object.
	for (int i = 0; _jumpTable[i].newFunction; i++)
		if (type == _jumpTable[i].type)
			return (_jumpTable[i].newFunction(file, L_SKIP_TYPE));
	return (NULL);
}

void ExposeCallback(Widget, caddr_t, caddr_t callData)
{

	if (((XmDrawingAreaCallbackStruct *)callData)->event->xexpose.count > 0)
		return;		// Ignore multiple exposure events.

	FILE *file = fopen("persist.dat", "r");
	int fileObjects = 1;
	do
	{
		GRAPHIC_OBJECT *object = GRAPHIC_OBJECT::New(file);
		if (object)
		{
			object->Draw();
			delete object;
		}
		else
			fileObjects = 0;
	} while (fileObjects);
	fclose(file);
}

main()
{
	// Initialize the Motif application
	XtAppContext appContext;
	Arg args[5]; int nargs;

	Widget topLevel = XtAppInitialize (&appContext, "Persistence", NULL, 0,
		NULL, NULL, NULL, NULL, 0);

	// Create the drawing widget.
	nargs = 0;
	XtSetArg(args[nargs], XmNwidth, 500); nargs++;
	XtSetArg(args[nargs], XmNheight, 300); nargs++;
	_drawingArea = XmCreateDrawingArea(topLevel, "Persist", args, nargs);
	XtAddCallback(_drawingArea, XmNexposeCallback, ExposeCallback, NULL);
	XtManageChild(_drawingArea);


	// Realize the tree and enter the loop.
	XtRealizeWidget(topLevel);
	XtAppMainLoop(appContext);

    return (0);
}
