# WORD tutorial makefile

#    make -fborland.mak dos		      	(makes all the DOS word tutorials)
#    make -fborland.mak windows	      	(makes all the Windows word tutorials)
#    make -fborland.mak os2	      		(makes all the OS/2 word tutorials)

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:\BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
DOS_OBJS=c0l
# --- Use the next line for UI_GRAPHICS_DISPLAY ---
DOS_LIBS=dos_zil dos_gfx bc_lgfx emu mathl cl
# --- Use the next line for UI_BGI_DISPLAY ---
#DOS_LIBS=dos_zil dos_bgi graphics emu mathl cl

# ----- Windows compiler options --------------------------------------------

# --- Use the next 2 lines for Windows 3.0 compatibility ---
WIN_CPP_OPTS=-c -ml -O -WE -w -DWINVER=0x0300
WIN_RC_OPTS=-k -30
# --- Use the next 2 lines for Windows 3.1 compatibility ---
#WIN_CPP_OPTS=-c -ml -O -WE -w
#WIN_RC_OPTS=-k
WIN_LINK_OPTS=/c /C /Twe /x
WIN_OBJS=c0wl
WIN_LIBS=win_zil mathwl import cwl

# ----- OS/2 compiler options -----------------------------------------------
OS2_CPP_OPTS=-c
OS2_LINK_OPTS=/c /B:0x10000 /aa
OS2_OBJS=c02.obj
OS2_LIBS=os2_zil.lib c2.lib os2.lib

CPP=bcc
LINK=tlink
RC=rc

.c.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }

.cpp.obo:
	$(CPP) $(OS2_CPP_OPTS) -o$*.obo {$< }

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc tutorial for Borland C++ type:
	@echo make -fborland.mak dos
	@echo make -fborland.mak windows
	@echo make -fborland.mak os2
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- DOS -----------------------------------------------------------------
dos: word1a.exe word1b.exe word2.exe word3.exe

word1a.exe: word1a.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+word1a.obj
$*, ,$(DOS_LIBS)
!

word1b.exe: word1b.obj list.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+word1b.obj+list.obj
$*, ,$(DOS_LIBS)
!

word2.exe: word2.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+word2.obj
$*, ,$(DOS_LIBS)
!

word3.exe: word3.obj word_win.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+word3.obj+word_win.obj
$*, ,$(DOS_LIBS)
!

# ----- Windows -------------------------------------------------------------
windows: wword2.exe wword3.exe

wword2.exe: word2.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+word2.obw
$*, ,$(WIN_LIBS),wword.def
!
	$(RC) $(WIN_RC_OPTS) wword.rc $<

wword3.exe: word3.obw word_win.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+word3.obw+word_win.obw
$*, ,$(WIN_LIBS),wword.def
!
	$(RC) $(WIN_RC_OPTS) wword.rc $<

# ----- OS/2 ----------------------------------------------------------------
os2: oword2.exe oword3.exe

oword2.exe: word2.obo
	$(LINK) $(OS2_LINK_OPTS) @&&!
$(OS2_OBJS)+word2.obo
$*, ,$(OS2_LIBS),oword.def
!
	$(RC) oword.rc $<

oword3.exe: word3.obo word_win.obo
	$(LINK) $(OS2_LINK_OPTS) @&&!
$(OS2_OBJS)+word3.obo+word_win.obo
$*, ,$(OS2_LIBS),oword.def
!
	$(RC) oword.rc $<

