//	CHECKBOX.CPP (CHECKBOX) - Checkbox example program.
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

//  May be freely copied, used and distributed.

#include <string.h>
#include <ui_win.hpp>

#include "checkwin.hpp"

EVENT_TYPE DefaultSettings(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	for (UI_WINDOW_OBJECT *window = object; window->parent;
		window = window->parent)
			;

	// Change the fields.
	UIW_BUTTON *displayObject;
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "BAUD_9600");
	*((UIW_GROUP *)displayObject->parent)
		+ displayObject;
	
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "FULL_DUPLEX");
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Information(CHANGED_STATUS, NULL);

	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "XON_XOFF");
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Information(CHANGED_STATUS, NULL);

	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "SCROLL");
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Information(CHANGED_STATUS, NULL);

	// Change the status window
	UI_WINDOW_OBJECT *baudObject = (UI_WINDOW_OBJECT *)window->Information(GET_STRINGID_OBJECT, "DISPLAY_BAUD");
	baudObject->Information(SET_TEXT, "9600 baud");

	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "DISPLAY_FULL_DUPLEX");
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Information(CHANGED_STATUS, NULL);

	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "DISPLAY_XON_XOFF");
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Information(CHANGED_STATUS, NULL);

	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "DISPLAY_SCROLL");
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Information(CHANGED_STATUS, NULL);

	return ccode;
}

EVENT_TYPE NewSettings(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	for (UI_WINDOW_OBJECT *window = object; window->parent;
		window = window->parent)
			;

	UI_WINDOW_OBJECT *displayObject;
	char stringID[30];
	strcpy(stringID, object->StringID());

	if (!strncmp(stringID, "BAUD", 4))
	{
       	char text[30];

		strcpy(text, (char *)object->Information(GET_TEXT, NULL));
       	displayObject = (UI_WINDOW_OBJECT *)window->Information(GET_STRINGID_OBJECT, "DISPLAY_BAUD");
       	displayObject->Information(SET_TEXT, &text, ID_STRING);
	}
	else
	{
		char string[30];
		strcpy(string, "DISPLAY_");
		strcat(string, stringID);
       	displayObject = (UI_WINDOW_OBJECT *)window->Information(GET_STRINGID_OBJECT, string);
       	if (FlagSet(object->woStatus, WOS_SELECTED))
           	displayObject->woStatus |= WOS_SELECTED;
       	else
           	displayObject->woStatus &= ~WOS_SELECTED;
		displayObject->Information(CHANGED_STATUS, NULL);
	}

	return ccode;
}

UIW_WINDOW *MakeWindow(void)
{
	UIW_WINDOW *window = new UIW_WINDOW("checkwin.dat~SETUP_WINDOW");
   	if (FlagSet(window->woStatus, WOS_READ_ERROR))
       	return window;

	// Select the radio button to display the default baud rate.
	UIW_BUTTON *button = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, "BAUD_9600");
	button->woStatus |= WOS_SELECTED | WOS_CURRENT;

   	// Set the default display baud rate string.
   	UI_WINDOW_OBJECT *object = (UI_WINDOW_OBJECT *)window->
       	Information(GET_STRINGID_OBJECT, "DISPLAY_BAUD");
   	object->Information(SET_TEXT, "9600 baud");

   	return window;
}

int UI_APPLICATION::Main(void)
{
	// The UI_APPLICATION constructor automatically initializes the 
	// display, eventManager, and windowManager variables.

	*windowManager
		+ MakeWindow();

	// Wait for user response.
	UI_EVENT event;
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	return (0);
}
