//	Zinc Interface Library Designer - Z_ADVANCE.HPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#define UIF_CONTROL					UIW_ADVANCED_FRAME
#include <string.h>
#include "ui_dsn.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

UIW_ADVANCED_FRAME::UIW_ADVANCED_FRAME(UI_WINDOW_OBJECT *_editObject) :
	UIW_WINDOW("ADVANCED_WINDOW", defaultStorage), editObject(_editObject)
{
	for (int i = 0; objectTable[i].data && objectTable[i].value != editObject->searchID; i++)
		;
//!! This is a special case for designing the designer with the designer.
//	if (objectTable[i].data && &objectTable[i] >= CONTROL_WINDOW::deriveTable)
//		Get("CLASS_NAME")->Information(SET_TEXT, objectTable[i].text);
	if (objectTable[i].data && &objectTable[i] >= CONTROL_WINDOW::deriveTable)
		Get("CLASS_NAME")->Information(SET_TEXT, objectTable[i].text);
	((FLAG_FIELD *)Get("FLAG_FIELD"))->DataSet(editObject->userFlags);
}

EVENT_TYPE UIW_ADVANCED_FRAME::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case OPTION_OK:
		{
		const char *className = (const char *)Get("CLASS_NAME")->Information(GET_TEXT, NULL);
		if (className && *className)
		{
			for (int i = 0; objectTable[i].data && strcmp(objectTable[i].text, className); i++)
				;
			if (!objectTable[i].data)
			{
				EVENT_TYPE newSearchID = ID_DERIVE_START;
				for (i = 0; CONTROL_WINDOW::deriveTable[i].data; i++)
					 if (CONTROL_WINDOW::deriveTable[i].value >= newSearchID)
						newSearchID = CONTROL_WINDOW::deriveTable[i].value + 1;
				if (CONTROL_WINDOW::deriveTable[i].value != ID_DERIVE_END)
				{
					CONTROL_WINDOW::deriveTable[i].value = newSearchID;
					for (int j = 0; objectTable[j].data; j++)
						if (objectTable[j].value == editObject->searchID)
						{
							CONTROL_WINDOW::deriveTable[i].data = objectTable[j].data;
							break;
						}
					CONTROL_WINDOW::deriveTable[i].text = ui_strdup(className);
					editObject->searchID = newSearchID;
				}
			}
//!! This is a special case for designing the designer with the designer.
//			else
//				editObject->searchID = objectTable[i].value;
			else if (&objectTable[i] >= CONTROL_WINDOW::deriveTable)
				editObject->searchID = objectTable[i].value;
		}
		editObject->userFlags = ((FLAG_FIELD *)Get("FLAG_FIELD"))->DataGet();
		}
		// Continue to OPTION_CANCEL.

	case OPTION_CANCEL:
		eventManager->Put(UI_EVENT(S_CLOSE, 0));
		break;

	case OPTION_HELP:
		helpSystem->DisplayHelp(windowManager, helpContext);
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}
	return ccode;
}

