//	Zinc Interface Library - G_PNORM.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif
#if defined(ZIL_LINKBUG)
void z_pnorm_dummy(void) { }	// Bug fix for broken linkers.
#endif

#if defined(ZIL_MSDOS) || defined(ZIL_MOTIF)
static UI_PALETTE_MAP paletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_ACTIVE | PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_DIM, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_DIM, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_DIM, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_ACTIVE | PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_LIST, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTCYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(OEM)
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(BLUE, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, BLACK, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,								// BUG.1243
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#elif defined(ZIL_MSWINDOWS)
static UI_PALETTE_MAP paletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_HIGHLIGHTTEXT, COLOR_HIGHLIGHT, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_MENUTEXT, COLOR_MENU, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_CAPTIONTEXT, COLOR_ACTIVECAPTION, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
#if (WINVER > 0x300)
	{ ID_ICON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_INACTIVECAPTIONTEXT, COLOR_INACTIVECAPTION, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
#else
	{ ID_ICON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_INACTIVECAPTION, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
#endif

	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, COLOR_MENUTEXT, COLOR_MENU, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_ACTIVECAPTION, COLOR_ACTIVEBORDER, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SYSTEM_COLOR, COLOR_ACTIVECAPTION, COLOR_ACTIVEBORDER, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#elif defined(ZIL_OS2)
static UI_PALETTE_MAP paletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_HILITEFOREGROUND, SYSCLR_HILITEBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_FIELDBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_ICON, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_HILITEFOREGROUND, SYSCLR_HILITEBACKGROUND,
		BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_ICON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_ICONTEXT, SYSCLR_DIALOGBACKGROUND,
		BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_LIST, PM_CURRENT,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_HILITEFOREGROUND, SYSCLR_HILITEBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_ENTRYFIELD,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_COMBO_BOX, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

UI_PALETTE_MAP *_normalPaletteMapTable = paletteMapTable;



