//	Zinc Interface Library - I_MAPFON.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_gen.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

static UCHAR _850_ISO[128] =
{
	0xc7, 0xfc, 0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7,
	0xea, 0xeb, 0xe8, 0xef, 0xee, 0xec, 0xc4, 0xc5,
	0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2, 0xfb, 0xf9,
	0xff, 0xd6, 0xdc, 0xf8, 0xa3, 0xd8, 0xd7,    0,
	0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba,
	0xbf, 0xae, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xbb,
	   0,    0,    0,    0,    0, 0xc1, 0xc2, 0xc0,
	0xa9,    0,    0,    0,    0, 0xa2, 0xa5,    0,
	   0,    0,    0,    0,    0,    0, 0xe3, 0xc3,
	   0,    0,    0,    0,    0,    0,    0, 0xa4,
	0xf0, 0xd0, 0xca, 0xcb, 0xc8, 0xb9, 0xcd, 0xce,
	0xcf,    0,    0,    0,    0, 0xa6, 0xcc,    0,
	0xd3, 0xdf, 0xd4, 0xd2, 0xf5, 0xd5, 0xb5, 0xfe,
	0xde, 0xda, 0xdb, 0xd9, 0xfd, 0xdd, 0xaf, 0xb4,
	0xad, 0xb1, 0x3d, 0xbe, 0xb6, 0xa7, 0xf7, 0xb8,
	0xb0, 0xa8, 0xb7, 0xb9, 0xb3, 0xb2,    0, 0xa0
};

UCHAR map850toISO(UCHAR val)
{
	if (val < 128) return val;
	return _850_ISO[val-128];
}

static UCHAR _ISO_850[128] =
{
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xbf, 0xc0, 0xc1,
	0xc2, 0xc3, 0xc4, 0xc5, 0xd9, 0xda,    0,    0,
	0xdf, 0xdc, 0xdb, 0xba, 0xb9, 0xbb, 0xc8, 0xca,
	0xcb, 0xcc, 0xcd, 0xce, 0xbc, 0xc9, 0xfe,    0,
	0xff, 0xad, 0xbd, 0x9c, 0xcf, 0xbe, 0xdd, 0xf5,
	0xf9, 0xb8, 0xa6, 0xae, 0xaa, 0xf0, 0xa9, 0xee,
	0xf8, 0xf1, 0xfd, 0xfc, 0xef, 0xe6, 0xf4, 0xfa,
	0xf7, 0xfb, 0xa7, 0xaf, 0xac, 0xab, 0xf3, 0xa8,
	0xb7, 0xb5, 0xb6, 0xc7, 0x8e, 0x8f, 0x92, 0x80,
	0xd4, 0x90, 0xd2, 0xd3, 0xde, 0xd6, 0xd7, 0xd8,
	0xd1, 0xa5, 0xe3, 0xe0, 0xe2, 0xe5, 0x99, 0x9e,
	0x9d, 0xeb, 0xe9, 0xea, 0x9a, 0xed, 0xe8, 0xe1,
	0x85, 0xa0, 0x83, 0xc6, 0x84, 0x86, 0x91, 0x87,
	0x8a, 0x82, 0x88, 0x89, 0x8d, 0xa1, 0x8c, 0x8b,
	0xd0, 0xa4, 0x95, 0xa2, 0x93, 0xe4, 0x94, 0xf6,
	0x9b, 0x97, 0xa3, 0x96, 0x81, 0xec, 0xe7, 0x98
};

UCHAR mapISOto850(UCHAR val)
{
	if (val < 128) return val;
	return _ISO_850[val-128];
}
