## Zinc Interface Library version 3.00 makefile
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## HP-UX 8.07

## Compiler and linker: (switch -g and -O for debug)
CPP=CC
LIBRARIAN=ar
UNIX_CPP_OPTS=-g -I/usr/include/X11R4 -I/usr/include/Motif1.1
UNIX_LINK_OPTS=
UNIX_LIB_OPTS=r
UNIX_LINK=CC
X_CPP_OPTS=-g
X_LINK_OPTS=-L/usr/lib/Motif1.1 -L/usr/lib/X11R4 
X_LIB_OPTS=
INCLUDE_DIR=.

## Storage locations in current tree:
INCDIR = ../include
LIBDIR = ../lib

## Library name:
LIB_NAME=$(LIBDIR)/lib_mtf_zil.a

## Include files:
INCLUDES = $(INCDIR)/ui_env.hpp $(INCDIR)/ui_gen.hpp $(INCDIR)/ui_dsp.hpp \
			$(INCDIR)/ui_evt.hpp $(INCDIR)/ui_win.hpp

## Libraries:
UNIX_OBJS=
UNIX_LIBS= -lc -lC
X_OBJS=
X_LIBS=/usr/lib/end.o $(LIB_NAME) -lXm -lXt -lX11 -lc

## Destinations
DESTLIBDIR=/usr/lib
DESTINCDIR=/usr/include
APPDEFAULTS=/usr/lib/X11/app-defaults

all: motif

.SUFFIXES:
.SUFFIXES: .a .o .s .c .h .cpp .hpp
VPATH=RCS

%.cpp: %.cpp,v
	co $<

%.hpp: %.hpp,v
	co $<

%.mak: %.mak,v
	co $<

.cpp.o:
	$(CPP) -c $(UNIX_CPP_OPTS) -I$(INCLUDE_DIR) $<

.c.o:
	 cc -c -I/users/src/X/mit/lib/Xt $(UNIX_CPP_OPTS) -I$(INCLUDE_DIR) $<


lib: $(LIB_NAME)


$(LIB_NAME): \
	g_bnum.o g_border.o g_date.o g_date1.o g_device.o \
	g_dsp.o g_event.o g_hotkey.o g_jump.o \
	g_perror.o g_phelp.o g_pnorm.o g_store.o g_time.o g_time1.o \
	g_win1.o g_win2.o g_sys.o g_int.o g_real.o \
	m_bitmap.o m_border.o m_button.o m_combo.o m_cursor.o m_dsp.o \
	m_error.o m_event.o m_group.o m_hlist.o m_icon.o m_keybrd.o \
	m_max.o m_min.o m_mouse.o m_plldn.o m_plldn1.o m_popup.o \
	m_popup1.o m_prompt.o m_scroll.o m_string.o m_sys.o m_tbar.o \
	m_text.o m_title.o m_vlist.o m_win.o m_win1.o m_win2.o \
	z_app.o z_bnum.o z_bnum1.o z_bnum2.o z_border.o z_button.o z_combo.o \
	z_cursor.o z_date.o z_date1.o z_device.o z_dsp.o z_error.o z_event.o \
	z_fmtstr.o z_group.o z_help.o z_hlist.o z_icon.o z_int.o \
	z_intl.o z_list.o z_list1.o z_map1.o z_map2.o z_max.o z_min.o \
	z_path.o z_plldn.o z_plldn1.o z_popup.o z_popup1.o z_prompt.o \
	z_real.o z_region.o z_scroll.o z_store.o z_string.o z_sys.o \
	z_tbar.o z_text.o z_time.o z_time1.o z_title.o z_vlist.o \
	z_win.o z_win1.o z_win2.o z_utils.o
	$(LIBRARIAN) $(UNIX_LIB_OPTS) $(LIB_NAME) $?


test: test.o $(LIB_NAME)
	$(UNIX_LINK) -g -o test $(UNIX_LINK_OPTS) test.o $(LIB_NAME) -L/usr/lib/Motif1.1 -lXm -L/usr/lib/X11R4 -lXt -lX11 -lc

motif:	$(LIB_NAME) $(INCLUDES)

$(INCLUDES):$$(@F)
	cp -f $? $@
	chmod 444 $@

install: motif
	cp -p *.hpp $(DESTINCDIR)
	cp -p $(LIB_NAME) $(DESTLIBDIR)
	cp -p appdefaults $(APPDEFAULTS)/ZincApp

clean:
	rm -f $(LIB_NAME) *.o test

###
g_bnum.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_border.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_cursor.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_date.o: ui_gen.hpp ui_env.hpp
g_date1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_device.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_dsp.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_event.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_fgdsp.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_hotkey.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_int.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_jump.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_keybrd.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_mscdsp.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_perror.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_phelp.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_pnorm.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_real.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_store.o: ui_gen.hpp ui_env.hpp
g_sys.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_time.o: ui_gen.hpp ui_env.hpp
g_time1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_win1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_win2.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
g_windsp.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_bitmap.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_border.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_button.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_combo.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_cursor.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_dsp.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_error.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_event.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_group.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_hlist.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_icon.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_keybrd.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_max.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_min.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_mouse.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_plldn.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_plldn1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_popup.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_popup1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_prompt.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_scroll.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_string.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_sys.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_tbar.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_text.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_title.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_vlist.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_win.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_win1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
m_win2.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_bnum.o: ui_gen.hpp ui_env.hpp
z_bnum1.o: ui_gen.hpp ui_env.hpp
z_bnum2.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_border.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_button.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_combo.o:  ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_cursor.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_date.o: ui_gen.hpp ui_env.hpp
z_date1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_device.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_dsp.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_error.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_event.o: ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_fmtstr.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_group.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_help.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_hlist.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_icon.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_int.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_intl.o: ui_gen.hpp ui_env.hpp
z_list.o: ui_gen.hpp ui_env.hpp
z_list1.o: ui_gen.hpp ui_env.hpp
z_map1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_map2.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_max.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_min.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_path.o: ui_gen.hpp ui_env.hpp
z_plldn.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_plldn1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_popup.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_popup1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_prompt.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_real.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_region.o: ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_scroll.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_store.o: ui_gen.hpp ui_env.hpp
z_string.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_sys.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_tbar.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_text.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_time.o: ui_gen.hpp ui_env.hpp
z_time1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_title.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_utils.o: ui_gen.hpp ui_env.hpp
z_vlist.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_win.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_win1.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
z_win2.o: ui_win.hpp ui_evt.hpp ui_dsp.hpp ui_gen.hpp ui_env.hpp
