//	Zinc Interface Library - Z_MIN.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

// ----- UIW_MINIMIZE_BUTTON ------------------------------------------------

UIW_MINIMIZE_BUTTON::UIW_MINIMIZE_BUTTON(void) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_SEND_MESSAGE | BTF_NO_TOGGLE | BTF_STATIC_BITMAPARRAY,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION,
	NULL, L_MINIMIZE)
{
	// Initialize the minimize button information.
	UIW_MINIMIZE_BUTTON::Information(INITIALIZE_CLASS, NULL);
}

UIW_MINIMIZE_BUTTON::~UIW_MINIMIZE_BUTTON(void)
{
	// Restore the minimize button information.
	text = NULL;		   	// text is a static string.
	bitmapArray = NULL;		// bitmapArray is a static array.
}

void *UIW_MINIMIZE_BUTTON::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_MINIMIZE_BUTTON;
	switch (request)
	{
	case INITIALIZE_CLASS:
		// Set the object identification and initial button settings.
		searchID = windowID[0] = ID_MINIMIZE_BUTTON;
		windowID[1] = ID_BUTTON;
		numberID = NUMID_MINIMIZE;
		strcpy(stringID, "NUMID_MINIMIZE");
		woAdvancedFlags |= WOAF_NON_CURRENT;
		btFlags |= BTF_SEND_MESSAGE | BTF_NO_TOGGLE;
		hotKey = HOT_KEY_MINIMIZE;
		depth = 1;
		break;

#if defined(ZIL_MSWINDOWS)
	case CHANGED_FLAGS:
		parent->Information(SET_DWSTYLE, &dwStyle);
		break;
#elif defined(ZIL_OS2)
	case CHANGED_FLAGS:
		parent->Information(SET_FLFLAG, &flFlag);
		break;
#endif

	default:
		data = UIW_BUTTON::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#if defined(ZIL_PERSISTENCE)
UIW_MINIMIZE_BUTTON::UIW_MINIMIZE_BUTTON(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_SEND_MESSAGE,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION,
	NULL, L_MINIMIZE)
{
	// Initialize the minimize button information.
	UIW_MINIMIZE_BUTTON::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::Information(INITIALIZE_CLASS, NULL);
	UIW_MINIMIZE_BUTTON::Information(INITIALIZE_CLASS, NULL);
}

void UIW_MINIMIZE_BUTTON::Load(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *)
{
}

void UIW_MINIMIZE_BUTTON::Store(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *)
{
	// Flag the object as being used.
	if (objectTable)
	{
		for (int i = 0; objectTable[i].data; i++)
			if (objectTable[i].value == searchID)
			{
				objectTable[i].flags = TRUE;
				break;
			}
	}
}
#endif


