# PERSIST tutorial makefile

#    make -fborland.mak dos		      	(makes all the DOS persist tutorials)
#    make -fborland.mak windows	      	(makes all the Windows persist tutorials)
#    make -fborland.mak os2		      	(makes all the OS/2 persist tutorials)

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE
#    set LIB=.;C:\ZINC\LIB\ZTCPP300;C:\ZTC\LIB

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP=ztc
DOS_LINK=blinkx
DOS_LIBRARIAN=zorlibx

DOS_CPP_OPTS=-c -a1 -bx -ml
DOS_LINK_OPTS=/NOI
DOS_OBJS=
DOS_LIBS=fg

# ----- Windows compiler options --------------------------------------------
WIN_CPP=ztc
WIN_LINK=blinkx
WIN_LIBRARIAN=zorlibx
WIN_RC=rc

# --- Use the next 2 lines for Windows 3.0 compatibility ---
WIN_CPP_OPTS=-c -a1 -bx -ml -W2 -DWINVER=0x0300
WIN_RC_OPTS=-k -30
# --- Use the next 2 lines for Windows 3.1 compatibility ---
#WIN_CPP_OPTS=-c -a1 -bx -ml -W2
#WIN_RC_OPTS=-k
WIN_LINK_OPTS=/NOI /PACKC:42000
WIN_OBJS=
WIN_LIBS=libw

# ----- OS/2 compiler options -----------------------------------------------
OS2_CPP=ztc
OS2_LINK=blinkos2
OS2_LIBRARIAN=zorlib
OS2_RC=rc

OS2_CPP_OPTS=-c -mf
OS2_LINK_OPTS=/BASE:0x10000 /PM:PM 
OS2_OBJS=
OS2_LIBS=os2_zil
OS2_RC_OPTS=

.c.obj:
	$(DOS_CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(DOS_CPP) $(DOS_CPP_OPTS) $<

.c.obw:
	$(WIN_CPP) $(WIN_CPP_OPTS) -o$*.obw $<

.cpp.obw:
	$(WIN_CPP) $(WIN_CPP_OPTS) -o$*.obw $<

.c.obo:
	$(OS2_CPP) $(OS2_CPP_OPTS) -o$*.obo $<

.cpp.obo:
	$(OS2_CPP) $(OS2_CPP_OPTS) -o$*.obo $<

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc tutorial for Zortech C++ type:
	@echo make -fzortech.mak dos
	@echo make -fzortech.mak windows
	@echo make -fzortech.mak os2
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean.bat

# ----- DOS -----------------------------------------------------------------
dos: persist1.exe persist2.exe persist3.exe persist4.exe persist5.exe persist6.exe persist7.exe

persist1.exe: persist1.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist1.obj,$*, ,$(DOS_LIBS),NUL

persist2.exe: persist2.obj draw.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist2.obj+draw.obj,$*, ,$(DOS_LIBS),NUL

persist3.exe: persist3.obj draw.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist3.obj+draw.obj,$*, ,$(DOS_LIBS),NUL

persist4.exe: persist4.obj draw.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist4.obj+draw.obj,$*, ,$(DOS_LIBS),NUL

persist5.exe: persist5.obj draw.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist5.obj+draw.obj,$*, ,$(DOS_LIBS),NUL

persist6.exe: persist6.obj draw.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist6.obj+draw.obj,$*, ,$(DOS_LIBS),NUL

persist7.exe: persist7.obj draw.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist7.obj+draw.obj,$*, ,$(DOS_LIBS),NUL

# ----- Windows -------------------------------------------------------------
windows: wpersist.exe

wpersist.exe: wpersist.obw wdraw.obw
	$(WIN_LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+wpersist.obw+wdraw.obw,$*, ,$(WIN_LIBS),wpersist.def
	$(WIN_RC) $(WIN_RC_OPTS) wpersist.rc $*.exe

# ----- OS/2 ----------------------------------------------------------------
os2: opersist.exe

opersist.exe: opersist.obo odraw.obo
	$(OS2_LINK) $(OS2_LINK_OPTS) @opersist.rsp
	$(OS2_RC) $(OS2_RC_OPTS) opersist.rc $*.exe

