//	Zinc Interface Library - D_MIN.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

#	if __BORLANDC__ >= 0X0500
#		undef true
#		define true OSRegion
#	endif

#include "ui_win.hpp"

// ----- UIW_MINIMIZE_BUTTON ------------------------------------------------

EVENT_TYPE UIW_MINIMIZE_BUTTON::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_MINIMIZE_BUTTON);
	switch (ccode)
	{

	case S_CHANGED:
	case S_CREATE:
		value = L_MINIMIZE;
		UI_WINDOW_OBJECT::Event(event);
		if (display->isText)
		{
#if !defined(ZIL_GRAPHICS_ONLY)
			bitmapArray = ZIL_NULLP(ZIL_UINT8);
			bitmapWidth = bitmapHeight = 0;
			text = myDecorations->GetText(FlagSet(parent->woStatus, WOS_MINIMIZED) ? ZIL_Minimized : ZIL_MinNormal);
#	if defined(ZIL_SHADOW_BORDER)
			true.bottom = true.top;
			true.left = true.right - display->TextWidth(text, screenID, font) + 1;
#	elif defined(ZIL_STANDARD_BORDER)
			true.top = true.bottom = parent->true.top;
			true.left = parent->true.right - 2;
			for (UI_WINDOW_OBJECT *object = Previous(); object; object = object->Previous())
				if (object->Inherited(ID_BORDER))
					true.left--;
				else if (object->Inherited(ID_MAXIMIZE_BUTTON))
					true.left -= 3;
			true.right = true.left + 2;
			clip = true;
#	elif defined(ZIL_3D_BORDER)
			true.top = true.bottom = parent->true.top;
			true.left = parent->true.right - 7;
			true.right = true.left + 2;
			clip = true;
#	endif
#endif
		}
		else
		{
#if !defined(ZIL_TEXT_ONLY)
			text = ZIL_NULLP(ZIL_ICHAR);
			ZIL_UINT8 *bitmap = myDecorations->GetBitmap(FlagSet(parent->woStatus, WOS_MINIMIZED) ? ZIL_Minimized : ZIL_MinNormal);
			bitmapWidth = bitmap[0];
			bitmapHeight = bitmap[1];
			bitmapArray = &bitmap[2];
#	if defined(ZIL_MSWINDOWS_STYLE)
			true.bottom = --true.top + (display->cellHeight - display->preSpace - display->postSpace);
			true.left = ++true.right - (display->cellHeight - display->preSpace - display->postSpace);
#	elif defined(ZIL_OS2_STYLE)
			// OS/2 style does not overlap parent region.
			true.bottom = true.top - 1 + (display->cellHeight - display->preSpace - display->postSpace);
			true.left = true.right + 1 - (display->cellHeight - display->preSpace - display->postSpace);
#	elif defined(ZIL_MOTIF_STYLE)
			// Motif clip region overlaps parent for shadowing.
			true.bottom = --true.top + (display->cellHeight - display->preSpace - display->postSpace);
			true.left = true.right - (display->cellHeight - display->preSpace - display->postSpace);
			clip = true;
#	endif
#endif
		}
		break;

	case L_CONTINUE_SELECT:
		return ccode;

	case L_BEGIN_SELECT:
		UIW_BUTTON::Event(event);
		while (ccode != L_END_SELECT)
		{
			UI_EVENT sEvent;
			eventManager->Get(sEvent);
			ccode = LogicalEvent(sEvent, ID_MINIMIZE_BUTTON);
			// Send all user messages to the window manager.
			if (sEvent.type > 9999)
				windowManager->Event(sEvent);
			else
				UIW_BUTTON::Event(sEvent);
		}
		break;

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

// ----- OS Specific Functions ----------------------------------------------

void UIW_MINIMIZE_BUTTON::OSUpdateSettings(ZIL_OBJECTID)
{
	// No code necessary.
}

#	if __BORLANDC__ >= 0X0500
#		undef true
#	endif

