PROG = main

CC = CC
LINK = CC
CPP_EXTENSION = .cpp
CC_FLAGS = 
LINK_FLAGS = 
ZINC_INC_DIR = ../../include
ZINC_LIB_DIR = ../../lib
ZINC_BIN_DIR = ../../bin
ZINC_MOTIF_LIB = _mtf_zil
ZINC_CURSES_LIB = _crs_zil
ZINC_LIB_NAME = $(ZINC_MOTIF_LIB)
ZINC_LIB_PATH = $(ZINC_LIB_DIR)/lib$(ZINC_LIB_NAME).a
INCLUDE_DIR = -I/usr/include/X11R5 -I/usr/include/Motif1.2

LIBS = 
LIB_DIRS = -L/usr/lib/Motif1.2 -L/usr/lib/X11R5
RANLIB =
Z_INCLUDE_DIR = -I$(ZINC_INC_DIR) $(INCLUDE_DIR)
GUI_LIBS = -lXm -lXt -lX11
MODULE_LIBRARY = $(ZINC_LIB_DIR)/libZi18n.a
DESIGN_LIBS = $(MODULE_LIBRARY) -lZservice -lZdirect -lZstorage -lZstredit
Z_LIBS = $(DESIGN_LIBS) -l$(ZINC_LIB_NAME) $(GUI_LIBS) $(LIBS)
Z_LIB_DIRS = -L$(ZINC_LIB_DIR) $(LIB_DIRS)
LIBRARIAN = ar
UNIX_LIB_OPTS = r
INCLUDE_FILES = $(ZINC_INC_DIR)/i18n.hpp
DAT_FILE = $(ZINC_BIN_DIR)/p_i18n.znc

TARGET = motif
OBJS = main.o
COLLISIONS = z_bnum_i18n$(CPP_EXTENSION) z_date_i18n$(CPP_EXTENSION) \
	z_date1_i18n$(CPP_EXTENSION) z_help_i18n$(CPP_EXTENSION) \
	z_int_i18n$(CPP_EXTENSION) z_error_i18n$(CPP_EXTENSION) \
	z_real_i18n$(CPP_EXTENSION) z_sys_i18n$(CPP_EXTENSION) \
	z_time_i18n$(CPP_EXTENSION) z_time1_i18n$(CPP_EXTENSION) \
	z_win_i18n$(CPP_EXTENSION)

LIB_OBJS = export.o i18n.o import.o language.o locale.o z_bnum_i18n.o \
	z_curr.o z_date_i18n.o z_date1_i18n.o z_day.o z_error_i18n.o \
	z_help_i18n.o z_int_i18n.o z_month.o z_msg.o z_num.o z_real_i18n.o \
	z_sys_i18n.o z_time_i18n.o z_time1_i18n.o z_time2.o z_win_i18n.o

.SUFFIXES:
.SUFFIXES: .o $(CPP_EXTENSION)

$(CPP_EXTENSION).o:
	$(CC) $(CC_FLAGS) $(Z_INCLUDE_DIR) -c $<

$(TARGET): $(COLLISIONS) $(INCLUDE_FILES) $(DAT_FILE) $(MODULE_LIBRARY)

$(PROG): $(OBJS) $(ZINC_LIB_PATH) $(MODULE_LIBRARY)
	$(LINK) $(LINK_FLAGS) -o $@ $(OBJS) $(Z_LIB_DIRS) $(Z_LIBS)

$(MODULE_LIBRARY): $(LIB_OBJS)
	$(LIBRARIAN) $(UNIX_LIB_OPTS) $@ $?
	$(RANLIB)

$(INCLUDE_FILES):$$(@F)
	-rm -f $@
	cp $? $@
	chmod 644 $@

$(DAT_FILE):p_i18n.dat
	cp $? $@
	chmod 666 $@

clean:
	-rm -f $(PROG) *.o $(MODULE_LIBRARY)
	-rm -f *_i18n$(CPP_EXTENSION)


#  These dependencies are for infantile compilers (like HP's) that won't
#  let you link in two libraries that have objects that came from source
#  files of the same name, eg: two libraries can't both have a z_win.cpp.
z_bnum_i18n$(CPP_EXTENSION): z_bnum$(CPP_EXTENSION)
	cp $? $@

z_date_i18n$(CPP_EXTENSION): z_date$(CPP_EXTENSION)
	cp $? $@

z_date1_i18n$(CPP_EXTENSION): z_date1$(CPP_EXTENSION)
	cp $? $@

z_error_i18n$(CPP_EXTENSION): z_error$(CPP_EXTENSION)
	cp $? $@

z_help_i18n$(CPP_EXTENSION): z_help$(CPP_EXTENSION)
	cp $? $@

z_int_i18n$(CPP_EXTENSION): z_int$(CPP_EXTENSION)
	cp $? $@

z_real_i18n$(CPP_EXTENSION): z_real$(CPP_EXTENSION)
	cp $? $@

z_sys_i18n$(CPP_EXTENSION): z_sys$(CPP_EXTENSION)
	cp $? $@

z_time_i18n$(CPP_EXTENSION): z_time$(CPP_EXTENSION)
	cp $? $@

z_time1_i18n$(CPP_EXTENSION): z_time1$(CPP_EXTENSION)
	cp $? $@

z_win_i18n$(CPP_EXTENSION): z_win$(CPP_EXTENSION)
	cp $? $@

