//  WINDOW.CPP (WINDOW) - Getting/Setting data in fields of a window.
//  COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//  Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//  May be freely copied, used and distributed.

#include <ui_win.hpp>
#define USE_DERIVED_OBJECTS
#include "window.hpp"

// This user function add a new world window to the window manager.
EVENT_TYPE view(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return(ccode);

	UI_WINDOW_OBJECT *viewWindow = UI_WINDOW_OBJECT::New("p_window.dat~VIEW_WINDOW");

	// Get the appropriate fields from both windows.
	UI_WINDOW_OBJECT *viewName = viewWindow->Get("VIEW_NAME");
	UI_WINDOW_OBJECT *viewAddress = viewWindow->Get("VIEW_ADDRESS");
	UI_WINDOW_OBJECT *viewCity = viewWindow->Get("VIEW_CITY");
	UI_WINDOW_OBJECT *viewPhone = viewWindow->Get("VIEW_PHONE");
	
	UI_WINDOW_OBJECT *editName = object->parent->Get("EDIT_NAME");
	UI_WINDOW_OBJECT *editAddress = object->parent->Get("EDIT_ADDRESS");
	UI_WINDOW_OBJECT *editCity = object->parent->Get("EDIT_CITY");
	UI_WINDOW_OBJECT *editPhone = object->parent->Get("EDIT_PHONE");

	viewName->Information(I_SET_TEXT,
		editName->Information(I_GET_TEXT, ZIL_NULLP(ZIL_ICHAR)));
	viewAddress->Information(I_SET_TEXT,
		editAddress->Information(I_GET_TEXT, ZIL_NULLP(ZIL_ICHAR)));
	viewCity->Information(I_SET_TEXT,
		editCity->Information(I_GET_TEXT, ZIL_NULLP(ZIL_ICHAR)));
	viewPhone->Information(I_SET_TEXT,
		editPhone->Information(I_GET_TEXT, ZIL_NULLP(ZIL_ICHAR)));
	
	*object->windowManager
		+ viewWindow;
	
	return(ccode);
}

// ----- UI_APPLICATION::Main -----------------------------------------------

int UI_APPLICATION::Main(void)
{
	// The UI_APPLICATION constructor automatically initializes the
	// display, eventManager, and windowManager variables.

	// This line fixes linkers that don't look for main in the .LIBs.
	UI_APPLICATION::LinkMain();

	UI_WINDOW_OBJECT::errorSystem = new UI_ERROR_SYSTEM;

	UI_WINDOW_OBJECT::defaultStorage = new ZIL_STORAGE("p_window.dat");

	// Check to see if the default storage was allocated.
	if (UI_WINDOW_OBJECT::defaultStorage->storageError)
	{
		UI_WINDOW_OBJECT::errorSystem->ReportError(windowManager, WOS_NO_STATUS,
			"ERROR: Unable to open or find the file \"p_window.dat\".");
		delete UI_WINDOW_OBJECT::defaultStorage;
		delete UI_WINDOW_OBJECT::errorSystem;
		return (0);
	}

	// Add the edit window to the window manager.
	UI_WINDOW_OBJECT *editWindow = UI_WINDOW_OBJECT::New("EDIT_WINDOW", UI_WINDOW_OBJECT::defaultStorage);
	*windowManager
		+ editWindow;
	
	// Process user responses.
	UI_APPLICATION::Control();

	// Clean up.
	delete UI_WINDOW_OBJECT::defaultStorage;
	delete UI_WINDOW_OBJECT::errorSystem;

	return (0);
}

// --------------------------------------------------------------------------
// From code file generated by designer -------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_LINKBUG)
void z_jump_dummy(void) { }   // Bug fix for broken linkers.
#endif

extern EVENT_TYPE view(UI_WINDOW_OBJECT *, UI_EVENT &, EVENT_TYPE);

static ZIL_ICHAR _view[] = { 'v','i','e','w',0 };

static UI_ITEM _userTable[] =
{
	{ 0, ZIL_VOIDF(view), _view, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::userTable = _userTable;

static UI_ITEM _objectTable[] =
{
	{ ID_BORDER, ZIL_VOIDF(UIW_BORDER::New), UIW_BORDER::_className, 0 },
	{ ID_BUTTON, ZIL_VOIDF(UIW_BUTTON::New), UIW_BUTTON::_className, 0 },
	{ ID_DATE, ZIL_VOIDF(UIW_DATE::New), UIW_DATE::_className, 0 },
	{ ID_FORMATTED_STRING, ZIL_VOIDF(UIW_FORMATTED_STRING::New), UIW_FORMATTED_STRING::_className, 0 },
	{ ID_MAXIMIZE_BUTTON, ZIL_VOIDF(UIW_MAXIMIZE_BUTTON::New), UIW_MAXIMIZE_BUTTON::_className, 0 },
	{ ID_MINIMIZE_BUTTON, ZIL_VOIDF(UIW_MINIMIZE_BUTTON::New), UIW_MINIMIZE_BUTTON::_className, 0 },
	{ ID_PROMPT, ZIL_VOIDF(UIW_PROMPT::New), UIW_PROMPT::_className, 0 },
	{ ID_STRING, ZIL_VOIDF(UIW_STRING::New), UIW_STRING::_className, 0 },
	{ ID_SYSTEM_BUTTON, ZIL_VOIDF(UIW_SYSTEM_BUTTON::New), UIW_SYSTEM_BUTTON::_className, 0 },
	{ ID_TITLE, ZIL_VOIDF(UIW_TITLE::New), UIW_TITLE::_className, 0 },
	{ ID_WINDOW, ZIL_VOIDF(UIW_WINDOW::New), UIW_WINDOW::_className, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::objectTable = _objectTable;
