//	Zinc Interface Library - Z_CURR.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "i18n.hpp"
#define USE_LOC_CURRENCY
#include "p_i18n.hpp"

// ----- LOC_CURRENCY -------------------------------------------------------

void ZAF_LOCALE_WINDOW::LOC_CURRENCY_DataLoad(void)
{
	// Load the object data.
	SetText(SYMBOL, table->currencySymbol);
	SetText(INTL_SYMBOL, table->intCurrencySymbol);
	SetText(DECIMAL, table->monDecimalSeparator);
	SetText(THOUSANDS, table->monThousandsSeparator);
	int grouping = (int)*table->monGrouping;
	SetValue(GROUPING, grouping);
}

void ZAF_LOCALE_WINDOW::LOC_CURRENCY_DataStore(void)
{
	// Store the object data.
	GetText(SYMBOL, table->currencySymbol);
	GetText(INTL_SYMBOL, table->intCurrencySymbol);
	GetText(DECIMAL, table->monDecimalSeparator);
	GetText(THOUSANDS, table->monThousandsSeparator);
	int grouping;
	GetValue(GROUPING, &grouping);
	*table->monGrouping = (char)grouping;
}

