//	AGENCY.HPP (AGENCY) - Simple travel agency program.
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//  May be freely copied, used and distributed.

//Events to open the corresponding windows.
const EVENT_TYPE CAR_EVENT			= 10000;
const EVENT_TYPE HOTEL_EVENT		= 10001;
const EVENT_TYPE PLANE_EVENT		= 10002;

// Events to add the objects to the vertical list.
const EVENT_TYPE ADD_CAR_EVENT   		= 10004;
const EVENT_TYPE ADD_HOTEL_EVENT 		= 10005;
const EVENT_TYPE ADD_PLANE_EVENT 		= 10006;
const EVENT_TYPE ADD_ITINERARY_ENTRY	= 10017;

// Events to do the various other things.
const EVENT_TYPE SAVE_EVENT		= 10008;
const EVENT_TYPE DELETE_EVENT	= 10010;


class ZIL_EXPORT_CLASS ITINERARY_WINDOW : public UIW_WINDOW
{
public:
	ITINERARY_WINDOW(const ZIL_ICHAR *name, ZIL_STORAGE *file,
		ZIL_STORAGE_OBJECT_READ_ONLY *object = ZIL_NULLP(ZIL_STORAGE_OBJECT_READ_ONLY),
		UI_ITEM *objectTable = ZIL_NULLP(UI_ITEM),
		UI_ITEM *userTable = ZIL_NULLP(UI_ITEM));

	virtual EVENT_TYPE Event(const UI_EVENT &event);

protected:
	UI_WINDOW_OBJECT *itinerary;
	ZIL_STORAGE *storage;
};

class ZIL_EXPORT_CLASS AGENCY_BUTTON : public UIW_BUTTON
{
public:
	ZIL_ICHAR *agencyString;
	ZIL_ICHAR *dateString;

	AGENCY_BUTTON(ZIL_ICHAR *bitmapString, ZIL_ICHAR *_agencyString, ZIL_ICHAR *_dateString);
	AGENCY_BUTTON(const ZIL_ICHAR *name,
		ZIL_STORAGE_READ_ONLY *file = ZIL_NULLP(ZIL_STORAGE_READ_ONLY),
		ZIL_STORAGE_OBJECT_READ_ONLY *object = ZIL_NULLP(ZIL_STORAGE_OBJECT_READ_ONLY),
		UI_ITEM *objectTable = ZIL_NULLP(UI_ITEM),
		UI_ITEM *userTable = ZIL_NULLP(UI_ITEM));
	~AGENCY_BUTTON();

	virtual EVENT_TYPE DrawItem(const UI_EVENT &event, EVENT_TYPE ccode);

	static UI_WINDOW_OBJECT *New(const ZIL_ICHAR *name,
		ZIL_STORAGE_READ_ONLY *file = ZIL_NULLP(ZIL_STORAGE_READ_ONLY),
		ZIL_STORAGE_OBJECT_READ_ONLY *object = ZIL_NULLP(ZIL_STORAGE_OBJECT_READ_ONLY),
		UI_ITEM *objectTable = ZIL_NULLP(UI_ITEM),
		UI_ITEM *userTable = ZIL_NULLP(UI_ITEM))
			{ return (new AGENCY_BUTTON(name, file, object, objectTable, userTable)); }
protected:
	virtual void Store(const ZIL_ICHAR *name,
		ZIL_STORAGE *file = ZIL_NULLP(ZIL_STORAGE),
		ZIL_STORAGE_OBJECT *object = ZIL_NULLP(ZIL_STORAGE_OBJECT),
		UI_ITEM *objectTable = ZIL_NULLP(UI_ITEM),
		UI_ITEM *userTable = ZIL_NULLP(UI_ITEM));
	virtual void Load(const ZIL_ICHAR *name,
		ZIL_STORAGE_READ_ONLY *file = ZIL_NULLP(ZIL_STORAGE_READ_ONLY),
		ZIL_STORAGE_OBJECT_READ_ONLY *object = ZIL_NULLP(ZIL_STORAGE_OBJECT_READ_ONLY),
		UI_ITEM *objectTable = ZIL_NULLP(UI_ITEM),
		UI_ITEM *userTable = ZIL_NULLP(UI_ITEM));
};

class ZIL_EXPORT_CLASS AGENCY_WINDOW : public UIW_WINDOW
{
public:
	AGENCY_WINDOW(const ZIL_ICHAR *name,
		ZIL_STORAGE_READ_ONLY *file = ZIL_NULLP(ZIL_STORAGE_READ_ONLY),
		ZIL_STORAGE_OBJECT_READ_ONLY *object = ZIL_NULLP(ZIL_STORAGE_OBJECT_READ_ONLY),
		UI_ITEM *objectTable = ZIL_NULLP(UI_ITEM),
		UI_ITEM *userTable = ZIL_NULLP(UI_ITEM));

	virtual EVENT_TYPE Event(const UI_EVENT &event);

	void AddItem(ZIL_ICHAR *bitmapString);

protected:
	UI_WINDOW_OBJECT *selection;
	UI_WINDOW_OBJECT *dateField;
};


// --------------------------------------------------------------------------
// From header file generated by designer -----------------------------------
// --------------------------------------------------------------------------
#ifdef USE_DERIVED_OBJECTS
const ZIL_OBJECTID	ID_AGENCY_BUTTON                   	 = 3500;
#endif



