//  STATUS.CPP (STATUS) - Checking, setting status of an object
//  COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//  Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//  May be freely copied, used and distributed.

#define SET_GROUP_DATA 10000
#define GET_GROUP_DATA 10001
#define SET_COMBO_DATA 10002
#define GET_COMBO_DATA 10003
#define SET_LIST_DATA  10004
#define GET_LIST_DATA  10005

#include <ui_win.hpp>
#include "status.hpp"

STATUS_WINDOW::STATUS_WINDOW() : UIW_WINDOW("GROUP_WINDOW", UI_WINDOW_OBJECT::defaultStorage)
{
	// Get a pointer to the fields on window we need to work with.
	group =  (UIW_GROUP *)Get("GROUP");
	combo =  (UIW_COMBO_BOX *)Get("COMBO");
	vlist =  (UIW_VT_LIST *)Get("VLIST");

	groupField =  Get("GROUP_FIELD");
	comboField =  Get("COMBO_FIELD");
	vlistField =  Get("VLIST_FIELD");
}

EVENT_TYPE STATUS_WINDOW::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object1, *object2;
	char *tString, *tString2;

	EVENT_TYPE ccode = LogicalEvent(event, ID_WINDOW);

	switch(ccode)
	{
	case GET_GROUP_DATA:
		for (object1 = group->First(); object1; object1 = object1->Next())
			if (FlagSet(object1->woStatus, WOS_SELECTED))
			{
				object1->Information(I_GET_TEXT, &tString);
				groupField->Information(I_SET_TEXT, tString);
			}
		break;

	case SET_GROUP_DATA:
		// Get a char * to user input.
		groupField->Information(I_GET_TEXT, &tString);

		for (object1 = group->First(); object1; object1 = object1->Next())
		{
			object1->Information(I_GET_TEXT, &tString2);
			if (!(strcmp(tString, tString2)))
			{
				// Set the item as selected.
				object1->woStatus |= WOS_SELECTED;
				object1->Information(I_CHANGED_STATUS, ZIL_NULLP(void));

				// Unselect the other items.
				for (object2 = object1->Previous(); object2; object2 = object2->Previous())
				{
					object2->woStatus &= ~WOS_SELECTED;
					object2->Information(I_CHANGED_STATUS, ZIL_NULLP(void));
				}
				for (object2 = object1->Next(); object2; object2 = object2->Next())
				{
					object2->woStatus &= ~WOS_SELECTED;
					object2->Information(I_CHANGED_STATUS, ZIL_NULLP(void));
				}
				break;
			}
		}
		break;

	case GET_COMBO_DATA:
		combo->Current()->Information(I_GET_TEXT, &tString);
		comboField->Information(I_SET_TEXT, tString);
		break;

	case SET_COMBO_DATA:
		// Get a char * to user input.
		comboField->Information(I_GET_TEXT, &tString);
		
		for (object1 = combo->First(); object1; object1 = object1->Next())
		{
			object1->Information(I_GET_TEXT, &tString2);
			if (!(strcmp(tString, tString2)))
				*combo + object1;   // Re-adding object1 back to parent makes it current.
		}
		combo->Event(S_REDISPLAY);
		break;

	case GET_LIST_DATA:
		vlist->Current()->Information(I_GET_TEXT, &tString);
		vlistField->Information(I_SET_TEXT, tString);
		break;

	case SET_LIST_DATA:
		// Get a char * to user input.
		vlistField->Information(I_GET_TEXT, &tString);

		for (object1 = vlist->First(); object1; object1 = object1->Next())
		{
			object1->Information(I_GET_TEXT, &tString2);
			if (!(strcmp(tString, tString2)))
				*vlist + object1;   // Re-adding object1 back to parent makes it current.
		}

		// After changing the current item, redisplay vt list to show change.
		vlist->Event(S_REDISPLAY);
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
	}

	return ccode;
}

int UI_APPLICATION::Main(void)
{
	// The UI_APPLICATION constructor automatically initializes the
	// display, eventManager, and windowManager variables.

	// This line fixes linkers that don't look for main in the .LIBs.
	UI_APPLICATION::LinkMain();

	UI_WINDOW_OBJECT::defaultStorage = new ZIL_STORAGE("p_status.dat");

	// Check to see if the default storage was allocated.
	if (UI_WINDOW_OBJECT::defaultStorage->storageError)
	{
		delete UI_WINDOW_OBJECT::defaultStorage;
		return(-1);
	}

	// Add  window to the window manager.
	STATUS_WINDOW *window = new STATUS_WINDOW();

	*windowManager
		+ window;

	// Process user responses.
	UI_APPLICATION::Control();

	delete UI_WINDOW_OBJECT::defaultStorage;
	return (0);
}


// ------------------------------------------------------------------------
// From code file generated by designer (.cpp) ----------------------------
// ------------------------------------------------------------------------
#if defined(ZIL_LINKBUG)
void z_jump_dummy(void) { }   // Bug fix for broken linkers.
#endif

static UI_ITEM _userTable[] =
{
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::userTable = _userTable;

static UI_ITEM _objectTable[] =
{
	{ ID_BORDER, ZIL_VOIDF(UIW_BORDER::New), UIW_BORDER::_className, 0 },
	{ ID_BUTTON, ZIL_VOIDF(UIW_BUTTON::New), UIW_BUTTON::_className, 0 },
	{ ID_COMBO_BOX, ZIL_VOIDF(UIW_COMBO_BOX::New), UIW_COMBO_BOX::_className, 0 },
	{ ID_GROUP, ZIL_VOIDF(UIW_GROUP::New), UIW_GROUP::_className, 0 },
	{ ID_ICON, ZIL_VOIDF(UIW_ICON::New), UIW_ICON::_className, 0 },
	{ ID_MAXIMIZE_BUTTON, ZIL_VOIDF(UIW_MAXIMIZE_BUTTON::New), UIW_MAXIMIZE_BUTTON::_className, 0 },
	{ ID_MINIMIZE_BUTTON, ZIL_VOIDF(UIW_MINIMIZE_BUTTON::New), UIW_MINIMIZE_BUTTON::_className, 0 },
	{ ID_PROMPT, ZIL_VOIDF(UIW_PROMPT::New), UIW_PROMPT::_className, 0 },
	{ ID_SCROLL_BAR, ZIL_VOIDF(UIW_SCROLL_BAR::New), UIW_SCROLL_BAR::_className, 0 },
	{ ID_STRING, ZIL_VOIDF(UIW_STRING::New), UIW_STRING::_className, 0 },
	{ ID_SYSTEM_BUTTON, ZIL_VOIDF(UIW_SYSTEM_BUTTON::New), UIW_SYSTEM_BUTTON::_className, 0 },
	{ ID_TITLE, ZIL_VOIDF(UIW_TITLE::New), UIW_TITLE::_className, 0 },
	{ ID_VT_LIST, ZIL_VOIDF(UIW_VT_LIST::New), UIW_VT_LIST::_className, 0 },
	{ ID_WINDOW, ZIL_VOIDF(UIW_WINDOW::New), UIW_WINDOW::_className, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::objectTable = _objectTable;



