//	LSTITM.CPP  (LSTITM) - List Items example program.
//  COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//	May be freely copied, used and distributed.
#	if __BORLANDC__ >= 0X0500
#		undef true
#		define true OSRegion
#	endif


#include <ui_win.hpp>
#include "lstitm.hpp"

LIST_ITEM::LIST_ITEM(TRANSPORT _tType, ZIL_ICHAR *_departure, ZIL_INT32 _cost) :
	UIW_BUTTON(0, 0, 0, ZIL_NULLP(ZIL_ICHAR), BTF_NO_3D)
{
	tType = _tType;
	departure = strdup(_departure);
	cost = _cost;

	woStatus |= WOS_OWNERDRAW;
}

LIST_ITEM::~LIST_ITEM()
{
	delete departure;
}

EVENT_TYPE LIST_ITEM::DrawItem(const UI_EVENT &, EVENT_TYPE ccode)
{
	UI_PALETTE *palette = LogicalPalette(ccode);

	display->VirtualGet(screenID, true);

	UI_REGION region = true;
	display->Rectangle(screenID, true, palette, 0, TRUE, FALSE, &clip);
	if (display->isText)
		display->Text(screenID, region.left + display->cellWidth,
			region.top + display->preSpace, tImage[tType].text, palette,
			-1, FALSE, FALSE, &clip);
	else
		display->Bitmap(screenID, region.left + display->cellWidth,
			region.top + display->preSpace, 16, 8, tImage[tType].graphic,
			ZIL_NULLP(UI_PALETTE), &clip);
			
	display->Text(screenID, region.left + display->cellWidth * 7,
		region.top + display->preSpace, departure, palette,
		-1, FALSE, FALSE, &clip);
	ZIL_ICHAR buffer[32];
	ZIL_BIGNUM formatter(cost);
	formatter.Export(buffer, NMF_CURRENCY | NMF_COMMAS);
	int left = region.right - display->TextWidth(buffer, screenID, font) - display->cellWidth;
	if (left < region.left + display->cellWidth * 30 - display->TextWidth(buffer, screenID, font))
		left = region.left + display->cellWidth * 30 - display->TextWidth(buffer, screenID, font);
	display->Text(screenID, left, region.top + display->preSpace, buffer,
		palette, -1, FALSE, FALSE, &clip);

	UI_WINDOW_OBJECT *object;
	for(object = this; object && FlagSet(object->woStatus, WOS_CURRENT);
		object = object->parent)
		;
	if (!object)
		DrawFocus(screenID, region, ccode);

	display->VirtualPut(screenID);

	return (TRUE);

}

int LIST_ITEM::Compare(void *p1, void *p2)
{
	LIST_ITEM *object1 = (LIST_ITEM *)p1;
	LIST_ITEM *object2 = (LIST_ITEM *)p2;

	if (object1->cost < object2->cost)
		return (-1);
	else if (object1->cost > object2->cost)
		return (1);
	else
		return (0);
}

TRANSPORT_IMAGE LIST_ITEM::tImage[5] =
{
#define _ (ZIL_UINT8)BACKGROUND
#define B (ZIL_UINT8)BLACK
	{ "Plane",
		{	_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
			_, _, _, _, _, _, B, B, B, B, B, _, _, _, B, B,
			_, _, _, _, B, B, B, _, _, _, _, _, _, B, B, B,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			_, _, _, _, B, B, B, _, _, _, _, _, _, _, _, _,
			_, _, _, _, _, _, B, B, B, B, B, _, _, _, _, _,
			_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _	}	},
	{ "Train",
		{	_, _, _, _, _, _, _, _, _, _, _, B, B, B, B, B,
			_, _, _, B, B, _, _, _, _, _, _, _, B, B, B, _,
			_, _, _, B, B, _, _, _, _, _, _, _, B, B, B, _,
			_, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			_, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			_, _, _, B, B, B, _, _, _, _, _, B, B, B, _, _,
			_, _, _, _, B, _, _, _, _, _, _, _, B, _, _, _	}	},
	{ "Bus",
		{	_, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			_, B, _, B, _, B, _, B, _, B, _, B, _, B, _, B,
			B, B, _, B, _, B, _, B, _, B, _, B, _, B, _, B,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			_, _, B, B, B, _, _, _, _, _, _, _, B, B, B, _,
			_, _, _, B, _, _, _, _, _, _, _, _, _, B, _, _	}	},
	{ "Ship",
		{	_, _, _, _, _, _, B, B, _, B, B, _, _, _, _, _,
			_, _, _, _, _, _, B, B, _, B, B, _, _, _, _, _,
			_, _, _, _, _, B, B, _, B, B, _, _, _, _, _, _,
			_, _, _, _, _, B, B, _, B, B, _, _, _, _, _, _,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			_, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			_, _, B, B, B, B, B, B, B, B, B, B, B, B, _, _,
			_, _, _, B, B, B, B, B, B, B, B, B, B, _, _, _ 	}	},
	{ "Cab",
		{	_, _, _, _, _, _, _, B, _, _, _, _, _, _, _, _,
			_, _, _, _, _, B, B, B, B, B, B, B, _, _, _, _,
			_, _, _, _, _, B, _, _, B, _, _, B, _, _, _, _,
			_, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			_, B, B, B, B, B, B, B, B, B, B, B, B, B, B, _,
			B, B, B, B, B, B, B, B, B, B, B, B, B, B, B, B,
			_, _, _, B, B, B, _, _, _, _, _, B, B, B, _, _,
			_, _, _, _, B, _, _, _, _, _, _, _, B, _, _, _	}	},
#undef B
#undef _
};

struct LIST_DATA
{
	TRANSPORT type;
	ZIL_ICHAR *departure;
	ZIL_INT32 cost;
};

static LIST_DATA entries[] =
{
	{ PLANE,	"Chicago",			400 },
	{ BUS,		"Los Angeles",		 99 },
	{ SHIP,		"Miami",			350 },
	{ TRAIN,	"Salt Lake City",	109 },
	{ CAB,		"New York City",	500 },
	{ NO_TRANSPORT, 0, 0 }
};

int UI_APPLICATION::Main(void)
{
	// This line fixes linkers that don't look for main in the .LIBs.
	UI_APPLICATION::LinkMain();

	UIW_WINDOW *window = UIW_WINDOW::Generic(1, 1, 35, 4, "Owner-draw List Items");

	UIW_VT_LIST *list = new UIW_VT_LIST(0, 0, 0, 0, LIST_ITEM::Compare,
		WNF_BITMAP_CHILDREN, WOF_NON_FIELD_REGION);
	*list + new UIW_SCROLL_BAR(0, 0, 0, 0);

	for (LIST_DATA *entry = entries; entry->type != NO_TRANSPORT; entry++)
		*list
			+ new LIST_ITEM(entry->type, entry->departure, entry->cost);

	*window
		+ list;

	*windowManager
		+ window;

	UI_APPLICATION::Control();

	return (0);
}
