//	Zinc Interface Library - I_STR5.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdlib.h>
#include "ui_gen.hpp"

#define LENGTHOF(x)	(sizeof(x)/sizeof((x)[0]))

int ZIL_INTERNATIONAL::strcmp(const ZIL_ICHAR *s1, const ZIL_ICHAR *s2)
{
#if defined(ZIL_DECOMPOSE)
	ZIL_ICHAR *tmp1 = DecomposeString(s1);
	ZIL_ICHAR *tmp2 = DecomposeString(s2);
	for (int i=0; tmp1[i] && tmp2[i] && tmp1[i] == tmp2[i]; i++)
		;
	i = (int)(tmp1[i] - tmp2[i]);
	delete tmp1;
	delete tmp2;
	return (i);
#else
	int i = 0;
	for (; s1[i] && s2[i] && s1[i] == s2[i]; i++)
		;
	return ((ZIL_INT16)s1[i] - (ZIL_INT16)s2[i]);
#endif
}

int ZIL_INTERNATIONAL::strncmp(const ZIL_ICHAR *s1, const ZIL_ICHAR *s2, int n)
{
#if defined(ZIL_DECOMPOSE)
	ZIL_ICHAR *tmp1 = DecomposeString(s1, n);
	ZIL_ICHAR *tmp2 = DecomposeString(s2, n);
	for (int i=0; tmp1[i] && tmp2[i] && tmp1[i] == tmp2[i]; i++)
		;
	i = (int)(tmp1[i] - tmp2[i]);
	delete tmp1;
	delete tmp2;
	return (i);
#else
	int i = 0;
	for (; n && s1[i] && s2[i] && s1[i] == s2[i]; i++, n--)
		;
	return (n ? (signed)s1[i] - (signed)s2[i] : 0);
#endif
}

#if defined(ZIL_DECOMPOSE)
static struct ZIL_DECOMPOSE_TABLE
{
	ZIL_ICHAR val;
	ZIL_ICHAR str[7];
}
ZIL_FARDATA decomposeTable[] =
{
	{ 0x005e,	{ 0x0020, 0x0302, 0 }},
	{ 0x005f,	{ 0x0020, 0x0332, 0 }},
	{ 0x0060,	{ 0x0020, 0x0300, 0 }},
	{ 0x00a0,	{ 0x0020, 0 }},
	{ 0x00a8,	{ 0x0020, 0x0308, 0 }},
	{ 0x00af,	{ 0x0020, 0x0304, 0 }},
	{ 0x00b4,	{ 0x0020, 0x0301, 0 }},
	{ 0x00b5,	{ 0x03BC, 0 }},
	{ 0x00b8,	{ 0x0020, 0x0327, 0 }},
	{ 0x00c0,	{ 0x0041, 0x0300, 0 }},
	{ 0x00c1,	{ 0x0041, 0x0301, 0 }},
	{ 0x00c2,	{ 0x0041, 0x0302, 0 }},
	{ 0x00c3,	{ 0x0041, 0x0303, 0 }},
	{ 0x00c4,	{ 0x0041, 0x0308, 0 }},
	{ 0x00c5,	{ 0x0041, 0x030A, 0 }},
	{ 0x00c7,	{ 0x0043, 0x0327, 0 }},
	{ 0x00c8,	{ 0x0045, 0x0300, 0 }},
	{ 0x00c9,	{ 0x0045, 0x0301, 0 }},
	{ 0x00ca,	{ 0x0045, 0x0302, 0 }},
	{ 0x00cb,	{ 0x0045, 0x0308, 0 }},
	{ 0x00cc,	{ 0x0049, 0x0300, 0 }},
	{ 0x00cd,	{ 0x0049, 0x0301, 0 }},
	{ 0x00ce,	{ 0x0049, 0x0302, 0 }},
	{ 0x00cf,	{ 0x0049, 0x0308, 0 }},
	{ 0x00d1,	{ 0x004E, 0x0303, 0 }},
	{ 0x00d2,	{ 0x004F, 0x0300, 0 }},
	{ 0x00d3,	{ 0x004F, 0x0301, 0 }},
	{ 0x00d4,	{ 0x004F, 0x0302, 0 }},
	{ 0x00d5,	{ 0x004F, 0x0303, 0 }},
	{ 0x00d6,	{ 0x004F, 0x0308, 0 }},
	{ 0x00d8,	{ 0x004F, 0x0338, 0 }},
	{ 0x00d9,	{ 0x0055, 0x0300, 0 }},
	{ 0x00da,	{ 0x0055, 0x0301, 0 }},
	{ 0x00db,	{ 0x0055, 0x0302, 0 }},
	{ 0x00dc,	{ 0x0055, 0x0308, 0 }},
	{ 0x00dd,	{ 0x0059, 0x0301, 0 }},
	{ 0x00e0,	{ 0x0061, 0x0300, 0 }},
	{ 0x00e1,	{ 0x0061, 0x0301, 0 }},
	{ 0x00e2,	{ 0x0061, 0x0302, 0 }},
	{ 0x00e3,	{ 0x0061, 0x0303, 0 }},
	{ 0x00e4,	{ 0x0061, 0x0308, 0 }},
	{ 0x00e5,	{ 0x0061, 0x030A, 0 }},
	{ 0x00e7,	{ 0x0063, 0x0327, 0 }},
	{ 0x00e8,	{ 0x0065, 0x0300, 0 }},
	{ 0x00e9,	{ 0x0065, 0x0301, 0 }},
	{ 0x00ea,	{ 0x0065, 0x0302, 0 }},
	{ 0x00eb,	{ 0x0065, 0x0308, 0 }},
	{ 0x00ec,	{ 0x0069, 0x0300, 0 }},
	{ 0x00ed,	{ 0x0069, 0x0301, 0 }},
	{ 0x00ee,	{ 0x0069, 0x0302, 0 }},
	{ 0x00ef,	{ 0x0069, 0x0308, 0 }},
	{ 0x00f1,	{ 0x006E, 0x0303, 0 }},
	{ 0x00f2,	{ 0x006F, 0x0300, 0 }},
	{ 0x00f3,	{ 0x006F, 0x0301, 0 }},
	{ 0x00f4,	{ 0x006F, 0x0302, 0 }},
	{ 0x00f5,	{ 0x006F, 0x0303, 0 }},
	{ 0x00f6,	{ 0x006F, 0x0308, 0 }},
	{ 0x00f8,	{ 0x006F, 0x0338, 0 }},
	{ 0x00f9,	{ 0x0075, 0x0300, 0 }},
	{ 0x00fa,	{ 0x0075, 0x0301, 0 }},
	{ 0x00fb,	{ 0x0075, 0x0302, 0 }},
	{ 0x00fc,	{ 0x0075, 0x0308, 0 }},
	{ 0x00fd,	{ 0x0079, 0x0301, 0 }},
	{ 0x00ff,	{ 0x0079, 0x0308, 0 }},
	{ 0x0100,	{ 0x0041, 0x0304, 0 }},
	{ 0x0101,	{ 0x0061, 0x0304, 0 }},
	{ 0x0102,	{ 0x0041, 0x0306, 0 }},
	{ 0x0103,	{ 0x0061, 0x0306, 0 }},
	{ 0x0104,	{ 0x0041, 0x0328, 0 }},
	{ 0x0105,	{ 0x0061, 0x0328, 0 }},
	{ 0x0106,	{ 0x0043, 0x0301, 0 }},
	{ 0x0107,	{ 0x0063, 0x0301, 0 }},
	{ 0x0108,	{ 0x0043, 0x0302, 0 }},
	{ 0x0109,	{ 0x0063, 0x0302, 0 }},
	{ 0x010a,	{ 0x0043, 0x0307, 0 }},
	{ 0x010b,	{ 0x0063, 0x0307, 0 }},
	{ 0x010c,	{ 0x0043, 0x030C, 0 }},
	{ 0x010d,	{ 0x0063, 0x030C, 0 }},
	{ 0x010e,	{ 0x0044, 0x030C, 0 }},
	{ 0x010f,	{ 0x0064, 0x030C, 0 }},
	{ 0x0110,	{ 0x0044, 0x0335, 0 }},
	{ 0x0111,	{ 0x0064, 0x0335, 0 }},
	{ 0x0112,	{ 0x0045, 0x0304, 0 }},
	{ 0x0113,	{ 0x0065, 0x0304, 0 }},
	{ 0x0114,	{ 0x0045, 0x0306, 0 }},
	{ 0x0115,	{ 0x0065, 0x0306, 0 }},
	{ 0x0116,	{ 0x0045, 0x0307, 0 }},
	{ 0x0117,	{ 0x0065, 0x0307, 0 }},
	{ 0x0118,	{ 0x0045, 0x0328, 0 }},
	{ 0x0119,	{ 0x0065, 0x0328, 0 }},
	{ 0x011a,	{ 0x0045, 0x030C, 0 }},
	{ 0x011b,	{ 0x0065, 0x030C, 0 }},
	{ 0x011c,	{ 0x0047, 0x0302, 0 }},
	{ 0x011d,	{ 0x0067, 0x0302, 0 }},
	{ 0x011e,	{ 0x0047, 0x0306, 0 }},
	{ 0x011f,	{ 0x0067, 0x0306, 0 }},
	{ 0x0120,	{ 0x0047, 0x0307, 0 }},
	{ 0x0121,	{ 0x0067, 0x0307, 0 }},
	{ 0x0122,	{ 0x0047, 0x0327, 0 }},
	{ 0x0123,	{ 0x0067, 0x0327, 0 }},
	{ 0x0124,	{ 0x0048, 0x0302, 0 }},
	{ 0x0125,	{ 0x0068, 0x0302, 0 }},
	{ 0x0126,	{ 0x0048, 0x0335, 0 }},
	{ 0x0127,	{ 0x0068, 0x0335, 0 }},
	{ 0x0128,	{ 0x0049, 0x0303, 0 }},
	{ 0x0129,	{ 0x0069, 0x0303, 0 }},
	{ 0x012a,	{ 0x0049, 0x0304, 0 }},
	{ 0x012b,	{ 0x0069, 0x0304, 0 }},
	{ 0x012c,	{ 0x0049, 0x0306, 0 }},
	{ 0x012d,	{ 0x0069, 0x0306, 0 }},
	{ 0x012e,	{ 0x0049, 0x0328, 0 }},
	{ 0x012f,	{ 0x0069, 0x0328, 0 }},
	{ 0x0130,	{ 0x0049, 0x0307, 0 }},
	{ 0x0132,	{ 0x0049, 0x004A, 0 }},
	{ 0x0133,	{ 0x0069, 0x006A, 0 }},
	{ 0x0134,	{ 0x004A, 0x0302, 0 }},
	{ 0x0135,	{ 0x006A, 0x0302, 0 }},
	{ 0x0136,	{ 0x004B, 0x0327, 0 }},
	{ 0x0137,	{ 0x006B, 0x0327, 0 }},
	{ 0x0139,	{ 0x004C, 0x0301, 0 }},
	{ 0x013a,	{ 0x006C, 0x0301, 0 }},
	{ 0x013b,	{ 0x004C, 0x0327, 0 }},
	{ 0x013c,	{ 0x006C, 0x0327, 0 }},
	{ 0x013d,	{ 0x004C, 0x030C, 0 }},
	{ 0x013e,	{ 0x006C, 0x030C, 0 }},
	{ 0x013f,	{ 0x004C, 0x00B7, 0 }},
	{ 0x0140,	{ 0x006C, 0x00B7, 0 }},
	{ 0x0141,	{ 0x004C, 0x0337, 0 }},
	{ 0x0142,	{ 0x006C, 0x0337, 0 }},
	{ 0x0143,	{ 0x004E, 0x0301, 0 }},
	{ 0x0144,	{ 0x006E, 0x0301, 0 }},
	{ 0x0145,	{ 0x004E, 0x0327, 0 }},
	{ 0x0146,	{ 0x006E, 0x0327, 0 }},
	{ 0x0147,	{ 0x004E, 0x030C, 0 }},
	{ 0x0148,	{ 0x006E, 0x030C, 0 }},
	{ 0x0149,	{ 0x0027, 0x006E, 0 }},
	{ 0x014c,	{ 0x004F, 0x0304, 0 }},
	{ 0x014d,	{ 0x006F, 0x0304, 0 }},
	{ 0x014e,	{ 0x004F, 0x0306, 0 }},
	{ 0x014f,	{ 0x006F, 0x0306, 0 }},
	{ 0x0150,	{ 0x004F, 0x030B, 0 }},
	{ 0x0151,	{ 0x006F, 0x030B, 0 }},
	{ 0x0154,	{ 0x0052, 0x0301, 0 }},
	{ 0x0155,	{ 0x0072, 0x0301, 0 }},
	{ 0x0156,	{ 0x0052, 0x0327, 0 }},
	{ 0x0157,	{ 0x0072, 0x0327, 0 }},
	{ 0x0158,	{ 0x0052, 0x030C, 0 }},
	{ 0x0159,	{ 0x0072, 0x030C, 0 }},
	{ 0x015a,	{ 0x0053, 0x0301, 0 }},
	{ 0x015b,	{ 0x0073, 0x0301, 0 }},
	{ 0x015c,	{ 0x0053, 0x0302, 0 }},
	{ 0x015d,	{ 0x0073, 0x0302, 0 }},
	{ 0x015e,	{ 0x0053, 0x0327, 0 }},
	{ 0x015f,	{ 0x0073, 0x0327, 0 }},
	{ 0x0160,	{ 0x0053, 0x030C, 0 }},
	{ 0x0161,	{ 0x0073, 0x030C, 0 }},
	{ 0x0162,	{ 0x0054, 0x0327, 0 }},
	{ 0x0163,	{ 0x0074, 0x0327, 0 }},
	{ 0x0164,	{ 0x0054, 0x030C, 0 }},
	{ 0x0165,	{ 0x0074, 0x030C, 0 }},
	{ 0x0166,	{ 0x0054, 0x0335, 0 }},
	{ 0x0167,	{ 0x0074, 0x0335, 0 }},
	{ 0x0168,	{ 0x0055, 0x0303, 0 }},
	{ 0x0169,	{ 0x0075, 0x0303, 0 }},
	{ 0x016a,	{ 0x0055, 0x0304, 0 }},
	{ 0x016b,	{ 0x0075, 0x0304, 0 }},
	{ 0x016c,	{ 0x0055, 0x0306, 0 }},
	{ 0x016d,	{ 0x0075, 0x0306, 0 }},
	{ 0x016e,	{ 0x0055, 0x030A, 0 }},
	{ 0x016f,	{ 0x0075, 0x030A, 0 }},
	{ 0x0170,	{ 0x0055, 0x030B, 0 }},
	{ 0x0171,	{ 0x0075, 0x030B, 0 }},
	{ 0x0172,	{ 0x0055, 0x0328, 0 }},
	{ 0x0173,	{ 0x0075, 0x0328, 0 }},
	{ 0x0174,	{ 0x0057, 0x0302, 0 }},
	{ 0x0175,	{ 0x0077, 0x0302, 0 }},
	{ 0x0176,	{ 0x0059, 0x0302, 0 }},
	{ 0x0177,	{ 0x0079, 0x0302, 0 }},
	{ 0x0178,	{ 0x0059, 0x0308, 0 }},
	{ 0x0179,	{ 0x005A, 0x0301, 0 }},
	{ 0x017a,	{ 0x007A, 0x0301, 0 }},
	{ 0x017b,	{ 0x005A, 0x0307, 0 }},
	{ 0x017c,	{ 0x007A, 0x0307, 0 }},
	{ 0x017d,	{ 0x005A, 0x030C, 0 }},
	{ 0x017e,	{ 0x007A, 0x030C, 0 }},
	{ 0x0180,	{ 0x0062, 0x0335, 0 }},
	{ 0x0197,	{ 0x0049, 0x0335, 0 }},
	{ 0x019a,	{ 0x006C, 0x0335, 0 }},
	{ 0x019b,	{ 0x03BB, 0x0335, 0 }},
	{ 0x01a0,	{ 0x004F, 0x031B, 0 }},
	{ 0x01a1,	{ 0x006F, 0x031B, 0 }},
	{ 0x01ab,	{ 0x0074, 0x0321, 0 }},
	{ 0x01ae,	{ 0x0054, 0x0322, 0 }},
	{ 0x01af,	{ 0x0055, 0x031B, 0 }},
	{ 0x01b0,	{ 0x0075, 0x031B, 0 }},
	{ 0x01c4,	{ 0x0044, 0x005A, 0x030C, 0 }},
	{ 0x01c5,	{ 0x0044, 0x007A, 0x030C, 0 }},
	{ 0x01c6,	{ 0x0064, 0x007A, 0x030C, 0 }},
	{ 0x01c7,	{ 0x004C, 0x004A, 0 }},
	{ 0x01c8,	{ 0x004C, 0x006A, 0 }},
	{ 0x01c9,	{ 0x006C, 0x006A, 0 }},
	{ 0x01ca,	{ 0x004E, 0x004A, 0 }},
	{ 0x01cb,	{ 0x004E, 0x006A, 0 }},
	{ 0x01cc,	{ 0x006E, 0x006A, 0 }},
	{ 0x01cd,	{ 0x0041, 0x030C, 0 }},
	{ 0x01ce,	{ 0x0061, 0x030C, 0 }},
	{ 0x01cf,	{ 0x0049, 0x030C, 0 }},
	{ 0x01d0,	{ 0x0069, 0x030C, 0 }},
	{ 0x01d1,	{ 0x004F, 0x030C, 0 }},
	{ 0x01d2,	{ 0x006F, 0x030C, 0 }},
	{ 0x01d3,	{ 0x0055, 0x030C, 0 }},
	{ 0x01d4,	{ 0x0075, 0x030C, 0 }},
	{ 0x01d5,	{ 0x0055, 0x0308, 0x0304, 0 }},
	{ 0x01d6,	{ 0x0075, 0x0308, 0x0304, 0 }},
	{ 0x01d7,	{ 0x0055, 0x0308, 0x0301, 0 }},
	{ 0x01d8,	{ 0x0075, 0x0308, 0x0301, 0 }},
	{ 0x01d9,	{ 0x0055, 0x0308, 0x030C, 0 }},
	{ 0x01da,	{ 0x0075, 0x0308, 0x030C, 0 }},
	{ 0x01db,	{ 0x0055, 0x0308, 0x0300, 0 }},
	{ 0x01dc,	{ 0x0075, 0x0308, 0x0300, 0 }},
	{ 0x01de,	{ 0x0041, 0x0308, 0x0304, 0 }},
	{ 0x01df,	{ 0x0061, 0x0308, 0x0304, 0 }},
	{ 0x01e0,	{ 0x0041, 0x0307, 0x0304, 0 }},
	{ 0x01e1,	{ 0x0061, 0x0307, 0x0304, 0 }},
	{ 0x01e2,	{ 0x00C6, 0x0304, 0 }},
	{ 0x01e3,	{ 0x00E6, 0x0304, 0 }},
	{ 0x01e4,	{ 0x0047, 0x0335, 0 }},
	{ 0x01e5,	{ 0x0067, 0x0335, 0 }},
	{ 0x01e6,	{ 0x0047, 0x030C, 0 }},
	{ 0x01e7,	{ 0x0067, 0x030C, 0 }},
	{ 0x01e8,	{ 0x004B, 0x030C, 0 }},
	{ 0x01e9,	{ 0x006B, 0x030C, 0 }},
	{ 0x01ea,	{ 0x004F, 0x0328, 0 }},
	{ 0x01eb,	{ 0x006F, 0x0328, 0 }},
	{ 0x01ec,	{ 0x004F, 0x0328, 0x0304, 0 }},
	{ 0x01ed,	{ 0x006F, 0x0328, 0x0304, 0 }},
	{ 0x01ee,	{ 0x01B7, 0x030C, 0 }},
	{ 0x01ef,	{ 0x0292, 0x030C, 0 }},
	{ 0x01f0,	{ 0x006A, 0x030C, 0 }},
	{ 0x01f1,	{ 0x0044, 0x005A, 0 }},
	{ 0x01f2,	{ 0x0044, 0x007A, 0 }},
	{ 0x01f3,	{ 0x0064, 0x007A, 0 }},
	{ 0x01f4,	{ 0x0047, 0x0301, 0 }},
	{ 0x01f5,	{ 0x0067, 0x0301, 0 }},
	{ 0x01fa,	{ 0x0041, 0x030A, 0x0301, 0 }},
	{ 0x01fb,	{ 0x0061, 0x030A, 0x0301, 0 }},
	{ 0x01fc,	{ 0x00C6, 0x0301, 0 }},
	{ 0x01fd,	{ 0x00E6, 0x0301, 0 }},
	{ 0x01fe,	{ 0x004F, 0x0338, 0x0301, 0 }},
	{ 0x01ff,	{ 0x006F, 0x0338, 0x0301, 0 }},
	{ 0x0200,	{ 0x0041, 0x030F, 0 }},
	{ 0x0201,	{ 0x0061, 0x030F, 0 }},
	{ 0x0202,	{ 0x0041, 0x0311, 0 }},
	{ 0x0203,	{ 0x0061, 0x0311, 0 }},
	{ 0x0204,	{ 0x0045, 0x030F, 0 }},
	{ 0x0205,	{ 0x0065, 0x030F, 0 }},
	{ 0x0206,	{ 0x0045, 0x0311, 0 }},
	{ 0x0207,	{ 0x0065, 0x0311, 0 }},
	{ 0x0208,	{ 0x0049, 0x030F, 0 }},
	{ 0x0209,	{ 0x0069, 0x030F, 0 }},
	{ 0x020a,	{ 0x0049, 0x0311, 0 }},
	{ 0x020b,	{ 0x0069, 0x0311, 0 }},
	{ 0x020c,	{ 0x004F, 0x030F, 0 }},
	{ 0x020d,	{ 0x006F, 0x030F, 0 }},
	{ 0x020e,	{ 0x004F, 0x0311, 0 }},
	{ 0x020f,	{ 0x006F, 0x0311, 0 }},
	{ 0x0210,	{ 0x0052, 0x030F, 0 }},
	{ 0x0211,	{ 0x0072, 0x030F, 0 }},
	{ 0x0212,	{ 0x0052, 0x0311, 0 }},
	{ 0x0213,	{ 0x0072, 0x0311, 0 }},
	{ 0x0214,	{ 0x0055, 0x030F, 0 }},
	{ 0x0215,	{ 0x0075, 0x030F, 0 }},
	{ 0x0216,	{ 0x0055, 0x0311, 0 }},
	{ 0x0217,	{ 0x0075, 0x0311, 0 }},
	{ 0x02c7,	{ 0x0020, 0x030C, 0 }},
	{ 0x02ca,	{ 0x0020, 0x0301, 0 }},
	{ 0x02cb,	{ 0x0020, 0x0300, 0 }},
	{ 0x02d8,	{ 0x0020, 0x0306, 0 }},
	{ 0x02d9,	{ 0x0020, 0x0307, 0 }},
	{ 0x02da,	{ 0x0020, 0x030A, 0 }},
	{ 0x02db,	{ 0x0020, 0x0328, 0 }},
	{ 0x02dc,	{ 0x0020, 0x0303, 0 }},
	{ 0x02dd,	{ 0x0020, 0x030B, 0 }},
	{ 0x0310,	{ 0x0306, 0x0307, 0 }},
	{ 0x0343,	{ 0x0313, 0 }},
	{ 0x0344,	{ 0x0308, 0x030D, 0 }},
	{ 0x0374,	{ 0x02B9, 0 }},
	{ 0x037e,	{ 0x003B, 0 }},
	{ 0x0386,	{ 0x0391, 0x0384, 0 }},
	{ 0x0387,	{ 0x00B7, 0 }},
	{ 0x0388,	{ 0x0395, 0x0384, 0 }},
	{ 0x0389,	{ 0x0397, 0x0384, 0 }},
	{ 0x038a,	{ 0x0399, 0x0384, 0 }},
	{ 0x038c,	{ 0x039F, 0x0384, 0 }},
	{ 0x038e,	{ 0x03A5, 0x0384, 0 }},
	{ 0x038f,	{ 0x03A9, 0x0384, 0 }},
	{ 0x0390,	{ 0x03B9, 0x0385, 0 }},
	{ 0x03aa,	{ 0x0399, 0x0308, 0 }},
	{ 0x03ab,	{ 0x03A5, 0x0308, 0 }},
	{ 0x03ac,	{ 0x03B1, 0x0384, 0 }},
	{ 0x03ad,	{ 0x03B5, 0x0384, 0 }},
	{ 0x03ae,	{ 0x03B7, 0x0384, 0 }},
	{ 0x03af,	{ 0x03B9, 0x0384, 0 }},
	{ 0x03b0,	{ 0x03C5, 0x0385, 0 }},
	{ 0x03ca,	{ 0x03B9, 0x0308, 0 }},
	{ 0x03cb,	{ 0x03C5, 0x0308, 0 }},
	{ 0x03cc,	{ 0x03BF, 0x0384, 0 }},
	{ 0x03cd,	{ 0x03C5, 0x0384, 0 }},
	{ 0x03ce,	{ 0x03C9, 0x0384, 0 }},
	{ 0x03d3,	{ 0x03D2, 0x0384, 0 }},
	{ 0x03d4,	{ 0x03D2, 0x0308, 0 }},
	{ 0x0401,	{ 0x0415, 0x0308, 0 }},
	{ 0x0403,	{ 0x0413, 0x0301, 0 }},
	{ 0x0407,	{ 0x0406, 0x0308, 0 }},
	{ 0x040c,	{ 0x041A, 0x0301, 0 }},
	{ 0x040e,	{ 0x0423, 0x0306, 0 }},
	{ 0x0419,	{ 0x0418, 0x0306, 0 }},
	{ 0x0439,	{ 0x0438, 0x0306, 0 }},
	{ 0x0451,	{ 0x0435, 0x0308, 0 }},
	{ 0x0453,	{ 0x0433, 0x0301, 0 }},
	{ 0x0457,	{ 0x0456, 0x0308, 0 }},
	{ 0x045c,	{ 0x043A, 0x0301, 0 }},
	{ 0x045e,	{ 0x0443, 0x0306, 0 }},
	{ 0x0476,	{ 0x0474, 0x030F, 0 }},
	{ 0x0477,	{ 0x0475, 0x030F, 0 }},
	{ 0x04be,	{ 0x04BC, 0x0328, 0 }},
	{ 0x04bf,	{ 0x04BD, 0x0328, 0 }},
	{ 0x04c1,	{ 0x0416, 0x0306, 0 }},
	{ 0x04c2,	{ 0x0436, 0x0306, 0 }},
	{ 0x04d0,	{ 0x0410, 0x0306, 0 }},
	{ 0x04d1,	{ 0x0430, 0x0306, 0 }},
	{ 0x04d2,	{ 0x0410, 0x0308, 0 }},
	{ 0x04d3,	{ 0x0430, 0x0308, 0 }},
	{ 0x04d4,	{ 0x00C6, 0 }},
	{ 0x04d5,	{ 0x00E6, 0 }},
	{ 0x04d6,	{ 0x0415, 0x0306, 0 }},
	{ 0x04d7,	{ 0x0435, 0x0306, 0 }},
	{ 0x04d8,	{ 0x018F, 0 }},
	{ 0x04d9,	{ 0x0259, 0 }},
	{ 0x04da,	{ 0x018F, 0x0308, 0 }},
	{ 0x04db,	{ 0x0259, 0x0308, 0 }},
	{ 0x04dc,	{ 0x0416, 0x0308, 0 }},
	{ 0x04dd,	{ 0x0436, 0x0308, 0 }},
	{ 0x04de,	{ 0x0417, 0x0308, 0 }},
	{ 0x04df,	{ 0x0437, 0x0308, 0 }},
	{ 0x04e0,	{ 0x0418, 0x0301, 0 }},
	{ 0x04e1,	{ 0x0438, 0x0301, 0 }},
	{ 0x04e2,	{ 0x0418, 0x0304, 0 }},
	{ 0x04e3,	{ 0x0438, 0x0304, 0 }},
	{ 0x04e4,	{ 0x0418, 0x0308, 0 }},
	{ 0x04e5,	{ 0x0438, 0x0308, 0 }},
	{ 0x04e6,	{ 0x041E, 0x0308, 0 }},
	{ 0x04e7,	{ 0x043E, 0x0308, 0 }},
	{ 0x04e8,	{ 0x019F, 0 }},
	{ 0x04e9,	{ 0x0275, 0 }},
	{ 0x04ea,	{ 0x019F, 0x0308, 0 }},
	{ 0x04eb,	{ 0x0275, 0x0308, 0 }},
	{ 0x04ee,	{ 0x0423, 0x0304, 0 }},
	{ 0x04ef,	{ 0x0443, 0x0304, 0 }},
	{ 0x04f0,	{ 0x0423, 0x0308, 0 }},
	{ 0x04f1,	{ 0x0443, 0x0308, 0 }},
	{ 0x04f2,	{ 0x0423, 0x030B, 0 }},
	{ 0x04f3,	{ 0x0443, 0x030B, 0 }},
	{ 0x04f4,	{ 0x0427, 0x0308, 0 }},
	{ 0x04f5,	{ 0x0447, 0x0308, 0 }},
	{ 0x04f8,	{ 0x042B, 0x0308, 0 }},
	{ 0x04f9,	{ 0x044B, 0x0308, 0 }},
	{ 0x0587,	{ 0x0565, 0x0582, 0 }},
	{ 0x0929,	{ 0x0928, 0x093C, 0 }},
	{ 0x0931,	{ 0x0930, 0x093C, 0 }},
	{ 0x0934,	{ 0x0933, 0x093C, 0 }},
	{ 0x0958,	{ 0x0915, 0x093C, 0 }},
	{ 0x0959,	{ 0x0916, 0x093C, 0 }},
	{ 0x095a,	{ 0x0917, 0x093C, 0 }},
	{ 0x095b,	{ 0x091C, 0x093C, 0 }},
	{ 0x095c,	{ 0x0921, 0x093C, 0 }},
	{ 0x095d,	{ 0x0922, 0x093C, 0 }},
	{ 0x095e,	{ 0x092B, 0x093C, 0 }},
	{ 0x095f,	{ 0x092F, 0x093C, 0 }},
	{ 0x09b0,	{ 0x09B0, 0x09BC, 0 }},
	{ 0x09cb,	{ 0x09C7, 0x09BE, 0 }},
	{ 0x09cc,	{ 0x09C7, 0x09D7, 0 }},
	{ 0x09dc,	{ 0x09A1, 0x09BC, 0 }},
	{ 0x09dd,	{ 0x09A2, 0x09BC, 0 }},
	{ 0x09df,	{ 0x09AF, 0x09BC, 0 }},
	{ 0x0a59,	{ 0x0A16, 0x0A3C, 0 }},
	{ 0x0a5a,	{ 0x0A17, 0x0A3C, 0 }},
	{ 0x0a5b,	{ 0x0A1C, 0x0A3C, 0 }},
	{ 0x0a5c,	{ 0x0A21, 0x0A3C, 0 }},
	{ 0x0a5e,	{ 0x0A2B, 0x0A3C, 0 }},
	{ 0x0b48,	{ 0x0B47, 0x0B56, 0 }},
	{ 0x0b4b,	{ 0x0B47, 0x0B3E, 0 }},
	{ 0x0b4c,	{ 0x0B47, 0x0B57, 0 }},
	{ 0x0b5c,	{ 0x0B21, 0x0B3C, 0 }},
	{ 0x0b5d,	{ 0x0B22, 0x0B3C, 0 }},
	{ 0x0b5f,	{ 0x0B2F, 0x0B3C, 0 }},
	{ 0x0b94,	{ 0x0BD7, 0x0B92, 0 }},
	{ 0x0bca,	{ 0x0BC6, 0x0BBE, 0 }},
	{ 0x0bcb,	{ 0x0BC7, 0x0BBE, 0 }},
	{ 0x0bcc,	{ 0x0BC6, 0x0BD7, 0 }},
	{ 0x0c48,	{ 0x0C46, 0x0C56, 0 }},
	{ 0x0cc0,	{ 0x0CBF, 0x0CD5, 0 }},
	{ 0x0cc7,	{ 0x0CC6, 0x0CD5, 0 }},
	{ 0x0cc8,	{ 0x0CC6, 0x0CD6, 0 }},
	{ 0x0cca,	{ 0x0CC6, 0x0CC2, 0 }},
	{ 0x0ccb,	{ 0x0CC6, 0x0CC2, 0x0CD5, 0 }},
	{ 0x0d4a,	{ 0x0D46, 0x0D3E, 0 }},
	{ 0x0d4b,	{ 0x0D47, 0x0D3E, 0 }},
	{ 0x0d4c,	{ 0x0D46, 0x0D57, 0 }},
	{ 0x0e33,	{ 0x0E4D, 0x0E32, 0 }},
	{ 0x0eb3,	{ 0x0ECD, 0x0EB2, 0 }},
	{ 0x0edc,	{ 0x0EAB, 0x0E99, 0 }},
	{ 0x0edd,	{ 0x0EAB, 0x0EA1, 0 }},
	{ 0x1e00,	{ 0x0041, 0x0325, 0 }},
	{ 0x1e01,	{ 0x0061, 0x0325, 0 }},
	{ 0x1e02,	{ 0x0042, 0x0307, 0 }},
	{ 0x1e03,	{ 0x0062, 0x0307, 0 }},
	{ 0x1e04,	{ 0x0042, 0x0323, 0 }},
	{ 0x1e05,	{ 0x0062, 0x0323, 0 }},
	{ 0x1e06,	{ 0x0042, 0x0331, 0 }},
	{ 0x1e07,	{ 0x0062, 0x0331, 0 }},
	{ 0x1e08,	{ 0x0043, 0x0327, 0x0301, 0 }},
	{ 0x1e09,	{ 0x0063, 0x0327, 0x0301, 0 }},
	{ 0x1e0a,	{ 0x0044, 0x0307, 0 }},
	{ 0x1e0b,	{ 0x0064, 0x0307, 0 }},
	{ 0x1e0c,	{ 0x0044, 0x0323, 0 }},
	{ 0x1e0d,	{ 0x0064, 0x0323, 0 }},
	{ 0x1e0e,	{ 0x0044, 0x0331, 0 }},
	{ 0x1e0f,	{ 0x0064, 0x0331, 0 }},
	{ 0x1e10,	{ 0x0044, 0x0327, 0 }},
	{ 0x1e11,	{ 0x0064, 0x0327, 0 }},
	{ 0x1e12,	{ 0x0044, 0x032D, 0 }},
	{ 0x1e13,	{ 0x0064, 0x032D, 0 }},
	{ 0x1e14,	{ 0x0045, 0x0304, 0x0300, 0 }},
	{ 0x1e15,	{ 0x0065, 0x0304, 0x0300, 0 }},
	{ 0x1e16,	{ 0x0045, 0x0304, 0x0301, 0 }},
	{ 0x1e17,	{ 0x0065, 0x0304, 0x0301, 0 }},
	{ 0x1e18,	{ 0x0045, 0x032D, 0 }},
	{ 0x1e19,	{ 0x0065, 0x032D, 0 }},
	{ 0x1e1a,	{ 0x0045, 0x0330, 0 }},
	{ 0x1e1b,	{ 0x0065, 0x0330, 0 }},
	{ 0x1e1c,	{ 0x0045, 0x0327, 0x0306, 0 }},
	{ 0x1e1d,	{ 0x0065, 0x0327, 0x0306, 0 }},
	{ 0x1e1e,	{ 0x0046, 0x0307, 0 }},
	{ 0x1e1f,	{ 0x0066, 0x0307, 0 }},
	{ 0x1e20,	{ 0x0047, 0x0304, 0 }},
	{ 0x1e21,	{ 0x0067, 0x0304, 0 }},
	{ 0x1e22,	{ 0x0048, 0x0307, 0 }},
	{ 0x1e23,	{ 0x0068, 0x0307, 0 }},
	{ 0x1e24,	{ 0x0048, 0x0323, 0 }},
	{ 0x1e25,	{ 0x0068, 0x0323, 0 }},
	{ 0x1e26,	{ 0x0048, 0x0308, 0 }},
	{ 0x1e27,	{ 0x0068, 0x0308, 0 }},
	{ 0x1e28,	{ 0x0048, 0x0327, 0 }},
	{ 0x1e29,	{ 0x0068, 0x0327, 0 }},
	{ 0x1e2a,	{ 0x0048, 0x032E, 0 }},
	{ 0x1e2b,	{ 0x0068, 0x032E, 0 }},
	{ 0x1e2c,	{ 0x0049, 0x0330, 0 }},
	{ 0x1e2d,	{ 0x0069, 0x0330, 0 }},
	{ 0x1e2e,	{ 0x0049, 0x0308, 0x0301, 0 }},
	{ 0x1e2f,	{ 0x0069, 0x0308, 0x0301, 0 }},
	{ 0x1e30,	{ 0x004B, 0x0301, 0 }},
	{ 0x1e31,	{ 0x006B, 0x0301, 0 }},
	{ 0x1e32,	{ 0x004B, 0x0323, 0 }},
	{ 0x1e33,	{ 0x006B, 0x0323, 0 }},
	{ 0x1e34,	{ 0x004B, 0x0331, 0 }},
	{ 0x1e35,	{ 0x006B, 0x0331, 0 }},
	{ 0x1e36,	{ 0x004C, 0x0323, 0 }},
	{ 0x1e37,	{ 0x006C, 0x0323, 0 }},
	{ 0x1e38,	{ 0x004C, 0x0323, 0x0304, 0 }},
	{ 0x1e39,	{ 0x006C, 0x0323, 0x0304, 0 }},
	{ 0x1e3a,	{ 0x004C, 0x0331, 0 }},
	{ 0x1e3b,	{ 0x006C, 0x0331, 0 }},
	{ 0x1e3c,	{ 0x004C, 0x032D, 0 }},
	{ 0x1e3d,	{ 0x006C, 0x032D, 0 }},
	{ 0x1e3e,	{ 0x004D, 0x0301, 0 }},
	{ 0x1e3f,	{ 0x006D, 0x0301, 0 }},
	{ 0x1e40,	{ 0x004D, 0x0307, 0 }},
	{ 0x1e41,	{ 0x006D, 0x0307, 0 }},
	{ 0x1e42,	{ 0x004D, 0x0323, 0 }},
	{ 0x1e43,	{ 0x006D, 0x0323, 0 }},
	{ 0x1e44,	{ 0x004E, 0x0307, 0 }},
	{ 0x1e45,	{ 0x006E, 0x0307, 0 }},
	{ 0x1e46,	{ 0x004E, 0x0323, 0 }},
	{ 0x1e47,	{ 0x006E, 0x0323, 0 }},
	{ 0x1e48,	{ 0x004E, 0x0331, 0 }},
	{ 0x1e49,	{ 0x006E, 0x0331, 0 }},
	{ 0x1e4a,	{ 0x004E, 0x032D, 0 }},
	{ 0x1e4b,	{ 0x006E, 0x032D, 0 }},
	{ 0x1e4c,	{ 0x004F, 0x0303, 0x0301, 0 }},
	{ 0x1e4d,	{ 0x006F, 0x0303, 0x0301, 0 }},
	{ 0x1e4e,	{ 0x004F, 0x0303, 0x0308, 0 }},
	{ 0x1e4f,	{ 0x006F, 0x0303, 0x0308, 0 }},
	{ 0x1e50,	{ 0x004F, 0x0304, 0x0300, 0 }},
	{ 0x1e51,	{ 0x006F, 0x0304, 0x0300, 0 }},
	{ 0x1e52,	{ 0x004F, 0x0304, 0x0301, 0 }},
	{ 0x1e53,	{ 0x006F, 0x0304, 0x0301, 0 }},
	{ 0x1e54,	{ 0x0050, 0x0301, 0 }},
	{ 0x1e55,	{ 0x0070, 0x0301, 0 }},
	{ 0x1e56,	{ 0x0050, 0x0307, 0 }},
	{ 0x1e57,	{ 0x0070, 0x0307, 0 }},
	{ 0x1e58,	{ 0x0052, 0x0307, 0 }},
	{ 0x1e59,	{ 0x0072, 0x0307, 0 }},
	{ 0x1e5a,	{ 0x0052, 0x0323, 0 }},
	{ 0x1e5b,	{ 0x0072, 0x0323, 0 }},
	{ 0x1e5c,	{ 0x0052, 0x0323, 0x0304, 0 }},
	{ 0x1e5d,	{ 0x0072, 0x0323, 0x0304, 0 }},
	{ 0x1e5e,	{ 0x0052, 0x0331, 0 }},
	{ 0x1e5f,	{ 0x0072, 0x0331, 0 }},
	{ 0x1e60,	{ 0x0053, 0x0307, 0 }},
	{ 0x1e61,	{ 0x0073, 0x0307, 0 }},
	{ 0x1e62,	{ 0x0053, 0x0323, 0 }},
	{ 0x1e63,	{ 0x0073, 0x0323, 0 }},
	{ 0x1e64,	{ 0x0053, 0x0301, 0x0307, 0 }},
	{ 0x1e65,	{ 0x0073, 0x0301, 0x0307, 0 }},
	{ 0x1e66,	{ 0x0053, 0x030C, 0x0307, 0 }},
	{ 0x1e67,	{ 0x0073, 0x030C, 0x0307, 0 }},
	{ 0x1e68,	{ 0x0053, 0x0323, 0x0307, 0 }},
	{ 0x1e69,	{ 0x0073, 0x0323, 0x0307, 0 }},
	{ 0x1e6a,	{ 0x0054, 0x0307, 0 }},
	{ 0x1e6b,	{ 0x0074, 0x0307, 0 }},
	{ 0x1e6c,	{ 0x0054, 0x0323, 0 }},
	{ 0x1e6d,	{ 0x0074, 0x0323, 0 }},
	{ 0x1e6e,	{ 0x0054, 0x0331, 0 }},
	{ 0x1e6f,	{ 0x0074, 0x0331, 0 }},
	{ 0x1e70,	{ 0x0054, 0x032D, 0 }},
	{ 0x1e71,	{ 0x0074, 0x032D, 0 }},
	{ 0x1e72,	{ 0x0055, 0x0324, 0 }},
	{ 0x1e73,	{ 0x0075, 0x0324, 0 }},
	{ 0x1e74,	{ 0x0055, 0x0330, 0 }},
	{ 0x1e75,	{ 0x0075, 0x0330, 0 }},
	{ 0x1e76,	{ 0x0055, 0x032D, 0 }},
	{ 0x1e77,	{ 0x0075, 0x032D, 0 }},
	{ 0x1e78,	{ 0x0055, 0x0303, 0x0301, 0 }},
	{ 0x1e79,	{ 0x0075, 0x0303, 0x0301, 0 }},
	{ 0x1e7a,	{ 0x0055, 0x0304, 0x0308, 0 }},
	{ 0x1e7b,	{ 0x0075, 0x0304, 0x0308, 0 }},
	{ 0x1e7c,	{ 0x0056, 0x0303, 0 }},
	{ 0x1e7d,	{ 0x0076, 0x0303, 0 }},
	{ 0x1e7e,	{ 0x0056, 0x0323, 0 }},
	{ 0x1e7f,	{ 0x0076, 0x0323, 0 }},
	{ 0x1e80,	{ 0x0057, 0x0300, 0 }},
	{ 0x1e81,	{ 0x0077, 0x0300, 0 }},
	{ 0x1e82,	{ 0x0057, 0x0301, 0 }},
	{ 0x1e83,	{ 0x0077, 0x0301, 0 }},
	{ 0x1e84,	{ 0x0057, 0x0308, 0 }},
	{ 0x1e85,	{ 0x0077, 0x0308, 0 }},
	{ 0x1e86,	{ 0x0057, 0x0307, 0 }},
	{ 0x1e87,	{ 0x0077, 0x0307, 0 }},
	{ 0x1e88,	{ 0x0057, 0x0323, 0 }},
	{ 0x1e89,	{ 0x0077, 0x0323, 0 }},
	{ 0x1e8a,	{ 0x0058, 0x0307, 0 }},
	{ 0x1e8b,	{ 0x0078, 0x0307, 0 }},
	{ 0x1e8c,	{ 0x0058, 0x0308, 0 }},
	{ 0x1e8d,	{ 0x0078, 0x0308, 0 }},
	{ 0x1e8e,	{ 0x0059, 0x0307, 0 }},
	{ 0x1e8f,	{ 0x0079, 0x0307, 0 }},
	{ 0x1e90,	{ 0x005A, 0x0302, 0 }},
	{ 0x1e91,	{ 0x007A, 0x0302, 0 }},
	{ 0x1e92,	{ 0x005A, 0x0323, 0 }},
	{ 0x1e93,	{ 0x007A, 0x0323, 0 }},
	{ 0x1e94,	{ 0x005A, 0x0331, 0 }},
	{ 0x1e95,	{ 0x007A, 0x0331, 0 }},
	{ 0x1e96,	{ 0x0068, 0x0331, 0 }},
	{ 0x1e97,	{ 0x0074, 0x0308, 0 }},
	{ 0x1e98,	{ 0x0077, 0x030A, 0 }},
	{ 0x1e99,	{ 0x0079, 0x030A, 0 }},
	{ 0x1ea0,	{ 0x0041, 0x0323, 0 }},
	{ 0x1ea1,	{ 0x0061, 0x0323, 0 }},
	{ 0x1ea2,	{ 0x0041, 0x0309, 0 }},
	{ 0x1ea3,	{ 0x0061, 0x0309, 0 }},
	{ 0x1ea4,	{ 0x0041, 0x0302, 0x0301, 0 }},
	{ 0x1ea5,	{ 0x0061, 0x0302, 0x0301, 0 }},
	{ 0x1ea6,	{ 0x0041, 0x0302, 0x0300, 0 }},
	{ 0x1ea7,	{ 0x0061, 0x0302, 0x0300, 0 }},
	{ 0x1ea8,	{ 0x0041, 0x0302, 0x0309, 0 }},
	{ 0x1ea9,	{ 0x0061, 0x0302, 0x0309, 0 }},
	{ 0x1eaa,	{ 0x0041, 0x0302, 0x0303, 0 }},
	{ 0x1eab,	{ 0x0061, 0x0302, 0x0303, 0 }},
	{ 0x1eac,	{ 0x0041, 0x0302, 0x0323, 0 }},
	{ 0x1ead,	{ 0x0061, 0x0302, 0x0323, 0 }},
	{ 0x1eae,	{ 0x0041, 0x0306, 0x0301, 0 }},
	{ 0x1eaf,	{ 0x0061, 0x0306, 0x0301, 0 }},
	{ 0x1eb0,	{ 0x0041, 0x0306, 0x0300, 0 }},
	{ 0x1eb1,	{ 0x0061, 0x0306, 0x0300, 0 }},
	{ 0x1eb2,	{ 0x0041, 0x0306, 0x0309, 0 }},
	{ 0x1eb3,	{ 0x0061, 0x0306, 0x0309, 0 }},
	{ 0x1eb4,	{ 0x0041, 0x0306, 0x0303, 0 }},
	{ 0x1eb5,	{ 0x0061, 0x0306, 0x0303, 0 }},
	{ 0x1eb6,	{ 0x0041, 0x0306, 0x0323, 0 }},
	{ 0x1eb7,	{ 0x0061, 0x0306, 0x0323, 0 }},
	{ 0x1eb8,	{ 0x0045, 0x0323, 0 }},
	{ 0x1eb9,	{ 0x0065, 0x0323, 0 }},
	{ 0x1eba,	{ 0x0045, 0x0309, 0 }},
	{ 0x1ebb,	{ 0x0065, 0x0309, 0 }},
	{ 0x1ebc,	{ 0x0045, 0x0303, 0 }},
	{ 0x1ebd,	{ 0x0065, 0x0303, 0 }},
	{ 0x1ebe,	{ 0x0045, 0x0302, 0x0301, 0 }},
	{ 0x1ebf,	{ 0x0065, 0x0302, 0x0301, 0 }},
	{ 0x1ec0,	{ 0x0045, 0x0302, 0x0300, 0 }},
	{ 0x1ec1,	{ 0x0065, 0x0302, 0x0300, 0 }},
	{ 0x1ec2,	{ 0x0045, 0x0302, 0x0309, 0 }},
	{ 0x1ec3,	{ 0x0065, 0x0302, 0x0309, 0 }},
	{ 0x1ec4,	{ 0x0045, 0x0302, 0x0303, 0 }},
	{ 0x1ec5,	{ 0x0065, 0x0302, 0x0303, 0 }},
	{ 0x1ec6,	{ 0x0045, 0x0302, 0x0323, 0 }},
	{ 0x1ec7,	{ 0x0065, 0x0302, 0x0323, 0 }},
	{ 0x1ec8,	{ 0x0049, 0x0309, 0 }},
	{ 0x1ec9,	{ 0x0069, 0x0309, 0 }},
	{ 0x1eca,	{ 0x0049, 0x0323, 0 }},
	{ 0x1ecb,	{ 0x0069, 0x0323, 0 }},
	{ 0x1ecc,	{ 0x004F, 0x0323, 0 }},
	{ 0x1ecd,	{ 0x006F, 0x0323, 0 }},
	{ 0x1ece,	{ 0x004F, 0x0309, 0 }},
	{ 0x1ecf,	{ 0x006F, 0x0309, 0 }},
	{ 0x1ed0,	{ 0x004F, 0x0302, 0x0301, 0 }},
	{ 0x1ed1,	{ 0x006F, 0x0302, 0x0301, 0 }},
	{ 0x1ed2,	{ 0x004F, 0x0302, 0x0300, 0 }},
	{ 0x1ed3,	{ 0x006F, 0x0302, 0x0300, 0 }},
	{ 0x1ed4,	{ 0x004F, 0x0302, 0x0309, 0 }},
	{ 0x1ed5,	{ 0x006F, 0x0302, 0x0309, 0 }},
	{ 0x1ed6,	{ 0x004F, 0x0302, 0x0303, 0 }},
	{ 0x1ed7,	{ 0x006F, 0x0302, 0x0303, 0 }},
	{ 0x1ed8,	{ 0x004F, 0x0302, 0x0323, 0 }},
	{ 0x1ed9,	{ 0x006F, 0x0302, 0x0323, 0 }},
	{ 0x1eda,	{ 0x004F, 0x031B, 0x0301, 0 }},
	{ 0x1edb,	{ 0x006F, 0x031B, 0x0301, 0 }},
	{ 0x1edc,	{ 0x004F, 0x031B, 0x0300, 0 }},
	{ 0x1edd,	{ 0x006F, 0x031B, 0x0300, 0 }},
	{ 0x1ede,	{ 0x004F, 0x031B, 0x0309, 0 }},
	{ 0x1edf,	{ 0x006F, 0x031B, 0x0309, 0 }},
	{ 0x1ee0,	{ 0x004F, 0x031B, 0x0303, 0 }},
	{ 0x1ee1,	{ 0x006F, 0x031B, 0x0303, 0 }},
	{ 0x1ee2,	{ 0x004F, 0x031B, 0x0323, 0 }},
	{ 0x1ee3,	{ 0x006F, 0x031B, 0x0323, 0 }},
	{ 0x1ee4,	{ 0x0055, 0x0323, 0 }},
	{ 0x1ee5,	{ 0x0075, 0x0323, 0 }},
	{ 0x1ee6,	{ 0x0055, 0x0309, 0 }},
	{ 0x1ee7,	{ 0x0075, 0x0309, 0 }},
	{ 0x1ee8,	{ 0x0055, 0x031B, 0x0301, 0 }},
	{ 0x1ee9,	{ 0x0075, 0x031B, 0x0301, 0 }},
	{ 0x1eea,	{ 0x0055, 0x031B, 0x0300, 0 }},
	{ 0x1eeb,	{ 0x0075, 0x031B, 0x0300, 0 }},
	{ 0x1eec,	{ 0x0055, 0x031B, 0x0309, 0 }},
	{ 0x1eed,	{ 0x0075, 0x031B, 0x0309, 0 }},
	{ 0x1eee,	{ 0x0055, 0x031B, 0x0303, 0 }},
	{ 0x1eef,	{ 0x0075, 0x031B, 0x0303, 0 }},
	{ 0x1ef0,	{ 0x0055, 0x031B, 0x0323, 0 }},
	{ 0x1ef1,	{ 0x0075, 0x031B, 0x0323, 0 }},
	{ 0x1ef2,	{ 0x0059, 0x0300, 0 }},
	{ 0x1ef3,	{ 0x0079, 0x0300, 0 }},
	{ 0x1ef4,	{ 0x0059, 0x0323, 0 }},
	{ 0x1ef5,	{ 0x0079, 0x0323, 0 }},
	{ 0x1ef6,	{ 0x0059, 0x0309, 0 }},
	{ 0x1ef7,	{ 0x0079, 0x0309, 0 }},
	{ 0x1ef8,	{ 0x0059, 0x0303, 0 }},
	{ 0x1ef9,	{ 0x0079, 0x0303, 0 }},
	{ 0x1f00,	{ 0x03B1, 0x0313, 0 }},
	{ 0x1f01,	{ 0x03B1, 0x0314, 0 }},
	{ 0x1f02,	{ 0x03B1, 0x0313, 0x0300, 0 }},
	{ 0x1f03,	{ 0x03B1, 0x0314, 0x0300, 0 }},
	{ 0x1f04,	{ 0x03B1, 0x0313, 0x0301, 0 }},
	{ 0x1f05,	{ 0x03B1, 0x0314, 0x0301, 0 }},
	{ 0x1f06,	{ 0x03B1, 0x0313, 0x0342, 0 }},
	{ 0x1f07,	{ 0x03B1, 0x0314, 0x0342, 0 }},
	{ 0x1f08,	{ 0x0391, 0x0313, 0 }},
	{ 0x1f09,	{ 0x0391, 0x0314, 0 }},
	{ 0x1f0a,	{ 0x0391, 0x0313, 0x0300, 0 }},
	{ 0x1f0b,	{ 0x0391, 0x0314, 0x0300, 0 }},
	{ 0x1f0c,	{ 0x0391, 0x0313, 0x0301, 0 }},
	{ 0x1f0d,	{ 0x0391, 0x0314, 0x0301, 0 }},
	{ 0x1f0e,	{ 0x0391, 0x0313, 0x0342, 0 }},
	{ 0x1f0f,	{ 0x0391, 0x0314, 0x0342, 0 }},
	{ 0x1f10,	{ 0x03B5, 0x0313, 0 }},
	{ 0x1f11,	{ 0x03B5, 0x0314, 0 }},
	{ 0x1f12,	{ 0x03B5, 0x0313, 0x0300, 0 }},
	{ 0x1f13,	{ 0x03B5, 0x0314, 0x0300, 0 }},
	{ 0x1f14,	{ 0x03B5, 0x0313, 0x0301, 0 }},
	{ 0x1f15,	{ 0x03B5, 0x0314, 0x0301, 0 }},
	{ 0x1f18,	{ 0x0395, 0x0313, 0 }},
	{ 0x1f19,	{ 0x0395, 0x0314, 0 }},
	{ 0x1f1a,	{ 0x0395, 0x0313, 0x0300, 0 }},
	{ 0x1f1b,	{ 0x0395, 0x0314, 0x0300, 0 }},
	{ 0x1f1c,	{ 0x0395, 0x0313, 0x0301, 0 }},
	{ 0x1f1d,	{ 0x0395, 0x0314, 0x0301, 0 }},
	{ 0x1f20,	{ 0x03B7, 0x0313, 0 }},
	{ 0x1f21,	{ 0x03B7, 0x0314, 0 }},
	{ 0x1f22,	{ 0x03B7, 0x0313, 0x0300, 0 }},
	{ 0x1f23,	{ 0x03B7, 0x0314, 0x0300, 0 }},
	{ 0x1f24,	{ 0x03B7, 0x0313, 0x0301, 0 }},
	{ 0x1f25,	{ 0x03B7, 0x0314, 0x0301, 0 }},
	{ 0x1f26,	{ 0x03B7, 0x0313, 0x0342, 0 }},
	{ 0x1f27,	{ 0x03B7, 0x0314, 0x0342, 0 }},
	{ 0x1f28,	{ 0x0397, 0x0313, 0 }},
	{ 0x1f29,	{ 0x0397, 0x0314, 0 }},
	{ 0x1f2a,	{ 0x0397, 0x0313, 0x0300, 0 }},
	{ 0x1f2b,	{ 0x0397, 0x0314, 0x0300, 0 }},
	{ 0x1f2c,	{ 0x0397, 0x0313, 0x0301, 0 }},
	{ 0x1f2d,	{ 0x0397, 0x0314, 0x0301, 0 }},
	{ 0x1f2e,	{ 0x0397, 0x0313, 0x0342, 0 }},
	{ 0x1f2f,	{ 0x0397, 0x0314, 0x0342, 0 }},
	{ 0x1f30,	{ 0x03B9, 0x0313, 0 }},
	{ 0x1f31,	{ 0x03B9, 0x0314, 0 }},
	{ 0x1f32,	{ 0x03B9, 0x0313, 0x0300, 0 }},
	{ 0x1f33,	{ 0x03B9, 0x0314, 0x0300, 0 }},
	{ 0x1f34,	{ 0x03B9, 0x0313, 0x0301, 0 }},
	{ 0x1f35,	{ 0x03B9, 0x0314, 0x0301, 0 }},
	{ 0x1f36,	{ 0x03B9, 0x0313, 0x0342, 0 }},
	{ 0x1f37,	{ 0x03B9, 0x0314, 0x0342, 0 }},
	{ 0x1f38,	{ 0x0399, 0x0313, 0 }},
	{ 0x1f39,	{ 0x0399, 0x0314, 0 }},
	{ 0x1f3a,	{ 0x0399, 0x0313, 0x0300, 0 }},
	{ 0x1f3b,	{ 0x0399, 0x0314, 0x0300, 0 }},
	{ 0x1f3c,	{ 0x0399, 0x0313, 0x0301, 0 }},
	{ 0x1f3d,	{ 0x0399, 0x0314, 0x0301, 0 }},
	{ 0x1f3e,	{ 0x0399, 0x0313, 0x0342, 0 }},
	{ 0x1f3f,	{ 0x0399, 0x0314, 0x0342, 0 }},
	{ 0x1f40,	{ 0x03BF, 0x0313, 0 }},
	{ 0x1f41,	{ 0x03BF, 0x0314, 0 }},
	{ 0x1f42,	{ 0x03BF, 0x0313, 0x0300, 0 }},
	{ 0x1f43,	{ 0x03BF, 0x0314, 0x0300, 0 }},
	{ 0x1f44,	{ 0x03BF, 0x0313, 0x0301, 0 }},
	{ 0x1f45,	{ 0x03BF, 0x0314, 0x0301, 0 }},
	{ 0x1f48,	{ 0x039F, 0x0313, 0 }},
	{ 0x1f49,	{ 0x039F, 0x0314, 0 }},
	{ 0x1f4a,	{ 0x039F, 0x0313, 0x0300, 0 }},
	{ 0x1f4b,	{ 0x039F, 0x0314, 0x0300, 0 }},
	{ 0x1f4c,	{ 0x039F, 0x0313, 0x0301, 0 }},
	{ 0x1f4d,	{ 0x039F, 0x0314, 0x0301, 0 }},
	{ 0x1f50,	{ 0x03C5, 0x0313, 0 }},
	{ 0x1f51,	{ 0x03C5, 0x0314, 0 }},
	{ 0x1f52,	{ 0x03C5, 0x0313, 0x0300, 0 }},
	{ 0x1f53,	{ 0x03C5, 0x0314, 0x0300, 0 }},
	{ 0x1f54,	{ 0x03C5, 0x0313, 0x0301, 0 }},
	{ 0x1f55,	{ 0x03C5, 0x0314, 0x0301, 0 }},
	{ 0x1f56,	{ 0x03C5, 0x0313, 0x0342, 0 }},
	{ 0x1f57,	{ 0x03C5, 0x0314, 0x0342, 0 }},
	{ 0x1f59,	{ 0x03A5, 0x0314, 0 }},
	{ 0x1f5b,	{ 0x03A5, 0x0314, 0x0300, 0 }},
	{ 0x1f5d,	{ 0x03A5, 0x0314, 0x0301, 0 }},
	{ 0x1f5f,	{ 0x03A5, 0x0314, 0x0342, 0 }},
	{ 0x1f60,	{ 0x03C9, 0x0313, 0 }},
	{ 0x1f61,	{ 0x03C9, 0x0314, 0 }},
	{ 0x1f62,	{ 0x03C9, 0x0313, 0x0300, 0 }},
	{ 0x1f63,	{ 0x03C9, 0x0314, 0x0300, 0 }},
	{ 0x1f64,	{ 0x03C9, 0x0313, 0x0301, 0 }},
	{ 0x1f65,	{ 0x03C9, 0x0314, 0x0301, 0 }},
	{ 0x1f66,	{ 0x03C9, 0x0313, 0x0342, 0 }},
	{ 0x1f67,	{ 0x03C9, 0x0314, 0x0342, 0 }},
	{ 0x1f68,	{ 0x03A9, 0x0313, 0 }},
	{ 0x1f69,	{ 0x03A9, 0x0314, 0 }},
	{ 0x1f6a,	{ 0x03A9, 0x0313, 0x0300, 0 }},
	{ 0x1f6b,	{ 0x03A9, 0x0314, 0x0300, 0 }},
	{ 0x1f6c,	{ 0x03A9, 0x0313, 0x0301, 0 }},
	{ 0x1f6d,	{ 0x03A9, 0x0314, 0x0301, 0 }},
	{ 0x1f6e,	{ 0x03A9, 0x0313, 0x0342, 0 }},
	{ 0x1f6f,	{ 0x03A9, 0x0314, 0x0342, 0 }},
	{ 0x1f70,	{ 0x03B1, 0x0300, 0 }},
	{ 0x1f71,	{ 0x03B1, 0x0301, 0 }},
	{ 0x1f72,	{ 0x03B5, 0x0300, 0 }},
	{ 0x1f73,	{ 0x03B5, 0x0301, 0 }},
	{ 0x1f74,	{ 0x03B7, 0x0300, 0 }},
	{ 0x1f75,	{ 0x03B7, 0x0301, 0 }},
	{ 0x1f76,	{ 0x03B9, 0x0300, 0 }},
	{ 0x1f77,	{ 0x03B9, 0x0301, 0 }},
	{ 0x1f78,	{ 0x03BF, 0x0300, 0 }},
	{ 0x1f79,	{ 0x03BF, 0x0301, 0 }},
	{ 0x1f7a,	{ 0x03C5, 0x0300, 0 }},
	{ 0x1f7b,	{ 0x03C5, 0x0301, 0 }},
	{ 0x1f7c,	{ 0x03C9, 0x0300, 0 }},
	{ 0x1f7d,	{ 0x03C9, 0x0301, 0 }},
	{ 0x1f80,	{ 0x03B1, 0x0313, 0x0345, 0 }},
	{ 0x1f81,	{ 0x03B1, 0x0314, 0x0345, 0 }},
	{ 0x1f82,	{ 0x03B1, 0x0313, 0x0300, 0x0345, 0 }},
	{ 0x1f83,	{ 0x03B1, 0x0314, 0x0300, 0x0345, 0 }},
	{ 0x1f84,	{ 0x03B1, 0x0313, 0x0301, 0x0345, 0 }},
	{ 0x1f85,	{ 0x03B1, 0x0314, 0x0301, 0x0345, 0 }},
	{ 0x1f86,	{ 0x03B1, 0x0313, 0x0342, 0x0345, 0 }},
	{ 0x1f87,	{ 0x03B1, 0x0314, 0x0342, 0x0345, 0 }},
	{ 0x1f88,	{ 0x0391, 0x0313, 0x0399, 0 }},
	{ 0x1f89,	{ 0x0391, 0x0314, 0x0399, 0 }},
	{ 0x1f8a,	{ 0x0391, 0x0313, 0x0300, 0x0399, 0 }},
	{ 0x1f8b,	{ 0x0391, 0x0314, 0x0300, 0x0399, 0 }},
	{ 0x1f8c,	{ 0x0391, 0x0313, 0x0301, 0x0399, 0 }},
	{ 0x1f8d,	{ 0x0391, 0x0314, 0x0301, 0x0399, 0 }},
	{ 0x1f8e,	{ 0x0391, 0x0313, 0x0342, 0x0399, 0 }},
	{ 0x1f8f,	{ 0x0391, 0x0314, 0x0342, 0x0399, 0 }},
	{ 0x1f90,	{ 0x03B7, 0x0313, 0x0345, 0 }},
	{ 0x1f91,	{ 0x03B7, 0x0314, 0x0345, 0 }},
	{ 0x1f92,	{ 0x03B7, 0x0313, 0x0300, 0x0345, 0 }},
	{ 0x1f93,	{ 0x03B7, 0x0314, 0x0300, 0x0345, 0 }},
	{ 0x1f94,	{ 0x03B7, 0x0313, 0x0301, 0x0345, 0 }},
	{ 0x1f95,	{ 0x03B7, 0x0314, 0x0301, 0x0345, 0 }},
	{ 0x1f96,	{ 0x03B7, 0x0313, 0x0342, 0x0345, 0 }},
	{ 0x1f97,	{ 0x03B7, 0x0314, 0x0342, 0x0345, 0 }},
	{ 0x1f98,	{ 0x0397, 0x0313, 0x0399, 0 }},
	{ 0x1f99,	{ 0x0397, 0x0314, 0x0399, 0 }},
	{ 0x1f9a,	{ 0x0397, 0x0313, 0x0300, 0x0399, 0 }},
	{ 0x1f9b,	{ 0x0397, 0x0314, 0x0300, 0x0399, 0 }},
	{ 0x1f9c,	{ 0x0397, 0x0313, 0x0301, 0x0399, 0 }},
	{ 0x1f9d,	{ 0x0397, 0x0314, 0x0301, 0x0399, 0 }},
	{ 0x1f9e,	{ 0x0397, 0x0313, 0x0342, 0x0399, 0 }},
	{ 0x1f9f,	{ 0x0397, 0x0314, 0x0342, 0x0399, 0 }},
	{ 0x1fa0,	{ 0x03C9, 0x0313, 0x0345, 0 }},
	{ 0x1fa1,	{ 0x03C9, 0x0314, 0x0345, 0 }},
	{ 0x1fa2,	{ 0x03C9, 0x0313, 0x0300, 0x0345, 0 }},
	{ 0x1fa3,	{ 0x03C9, 0x0314, 0x0300, 0x0345, 0 }},
	{ 0x1fa4,	{ 0x03C9, 0x0313, 0x0301, 0x0345, 0 }},
	{ 0x1fa5,	{ 0x03C9, 0x0314, 0x0301, 0x0345, 0 }},
	{ 0x1fa6,	{ 0x03C9, 0x0313, 0x0342, 0x0345, 0 }},
	{ 0x1fa7,	{ 0x03C9, 0x0314, 0x0342, 0x0345, 0 }},
	{ 0x1fa8,	{ 0x03A9, 0x0313, 0x0399, 0 }},
	{ 0x1fa9,	{ 0x03A9, 0x0314, 0x0399, 0 }},
	{ 0x1faa,	{ 0x03A9, 0x0313, 0x0300, 0x0399, 0 }},
	{ 0x1fab,	{ 0x03A9, 0x0314, 0x0300, 0x0399, 0 }},
	{ 0x1fac,	{ 0x03A9, 0x0313, 0x0301, 0x0399, 0 }},
	{ 0x1fad,	{ 0x03A9, 0x0314, 0x0301, 0x0399, 0 }},
	{ 0x1fae,	{ 0x03A9, 0x0313, 0x0342, 0x0399, 0 }},
	{ 0x1faf,	{ 0x03A9, 0x0314, 0x0342, 0x0399, 0 }},
	{ 0x1fb0,	{ 0x03B1, 0x0306, 0 }},
	{ 0x1fb1,	{ 0x03B1, 0x0304, 0 }},
	{ 0x1fb2,	{ 0x03B1, 0x0300, 0x0345, 0 }},
	{ 0x1fb3,	{ 0x03B1, 0x0345, 0 }},
	{ 0x1fb4,	{ 0x03B1, 0x0301, 0x0345, 0 }},
	{ 0x1fb6,	{ 0x03B1, 0x0342, 0 }},
	{ 0x1fb7,	{ 0x03B1, 0x0342, 0x0345, 0 }},
	{ 0x1fb8,	{ 0x0391, 0x0306, 0 }},
	{ 0x1fb9,	{ 0x0391, 0x0304, 0 }},
	{ 0x1fba,	{ 0x0391, 0x0300, 0 }},
	{ 0x1fbb,	{ 0x0391, 0x0301, 0 }},
	{ 0x1fbc,	{ 0x0391, 0x0399, 0 }},
	{ 0x1fbd,	{ 0x0020, 0x0313, 0 }},
	{ 0x1fbe,	{ 0x0399, 0 }},
	{ 0x1fbf,	{ 0x0020, 0x0313, 0 }},
	{ 0x1fc0,	{ 0x0020, 0x0342, 0 }},
	{ 0x1fc1,	{ 0x0020, 0x0308, 0x0342, 0 }},
	{ 0x1fc2,	{ 0x03B7, 0x0300, 0x0345, 0 }},
	{ 0x1fc3,	{ 0x03B7, 0x0345, 0 }},
	{ 0x1fc4,	{ 0x03B7, 0x0301, 0x0345, 0 }},
	{ 0x1fc6,	{ 0x03B7, 0x0342, 0 }},
	{ 0x1fc7,	{ 0x03B7, 0x0342, 0x0345, 0 }},
	{ 0x1fc8,	{ 0x0395, 0x0300, 0 }},
	{ 0x1fc9,	{ 0x0395, 0x0301, 0 }},
	{ 0x1fca,	{ 0x0397, 0x0300, 0 }},
	{ 0x1fcb,	{ 0x0397, 0x0301, 0 }},
	{ 0x1fcc,	{ 0x0397, 0x0399, 0 }},
	{ 0x1fcd,	{ 0x0020, 0x0313, 0x0300, 0 }},
	{ 0x1fce,	{ 0x0020, 0x0313, 0x0301, 0 }},
	{ 0x1fcf,	{ 0x0020, 0x0313, 0x0342, 0 }},
	{ 0x1fd0,	{ 0x03B9, 0x0306, 0 }},
	{ 0x1fd1,	{ 0x03B9, 0x0304, 0 }},
	{ 0x1fd2,	{ 0x03B9, 0x0308, 0x0300, 0 }},
	{ 0x1fd3,	{ 0x03B9, 0x0308, 0x0301, 0 }},
	{ 0x1fd6,	{ 0x03B9, 0x0342, 0 }},
	{ 0x1fd7,	{ 0x03B9, 0x0308, 0x0342, 0 }},
	{ 0x1fd8,	{ 0x0399, 0x0306, 0 }},
	{ 0x1fd9,	{ 0x0399, 0x0304, 0 }},
	{ 0x1fda,	{ 0x0399, 0x0300, 0 }},
	{ 0x1fdb,	{ 0x0399, 0x0301, 0 }},
	{ 0x1fdd,	{ 0x0020, 0x0314, 0x0300, 0 }},
	{ 0x1fde,	{ 0x0020, 0x0314, 0x0301, 0 }},
	{ 0x1fdf,	{ 0x0020, 0x0314, 0x0342, 0 }},
	{ 0x1fe0,	{ 0x03C5, 0x0306, 0 }},
	{ 0x1fe1,	{ 0x03C5, 0x0304, 0 }},
	{ 0x1fe2,	{ 0x03C5, 0x0308, 0x0300, 0 }},
	{ 0x1fe3,	{ 0x03C5, 0x0308, 0x0301, 0 }},
	{ 0x1fe4,	{ 0x03C1, 0x0313, 0 }},
	{ 0x1fe5,	{ 0x03C1, 0x0314, 0 }},
	{ 0x1fe6,	{ 0x03C5, 0x0342, 0 }},
	{ 0x1fe7,	{ 0x03C5, 0x0308, 0x0342, 0 }},
	{ 0x1fe8,	{ 0x03A5, 0x0306, 0 }},
	{ 0x1fe9,	{ 0x03A5, 0x0304, 0 }},
	{ 0x1fea,	{ 0x03A5, 0x0300, 0 }},
	{ 0x1feb,	{ 0x03A5, 0x0301, 0 }},
	{ 0x1fec,	{ 0x03A1, 0x0314, 0 }},
	{ 0x1fed,	{ 0x0020, 0x0308, 0x0300, 0 }},
	{ 0x1fee,	{ 0x0020, 0x0308, 0x0301, 0 }},
	{ 0x1fef,	{ 0x0060, 0 }},
	{ 0x1ff2,	{ 0x03C9, 0x0300, 0x0345, 0 }},
	{ 0x1ff3,	{ 0x03C9, 0x0345, 0 }},
	{ 0x1ff4,	{ 0x03C9, 0x0301, 0x0345, 0 }},
	{ 0x1ff6,	{ 0x03C9, 0x0342, 0 }},
	{ 0x1ff7,	{ 0x03C9, 0x0342, 0x0345, 0 }},
	{ 0x1ff8,	{ 0x039F, 0x0300, 0 }},
	{ 0x1ff9,	{ 0x039F, 0x0301, 0 }},
	{ 0x1ffa,	{ 0x03A9, 0x0300, 0 }},
	{ 0x1ffb,	{ 0x03A9, 0x0301, 0 }},
	{ 0x1ffc,	{ 0x03A9, 0x0399, 0 }},
	{ 0x1ffd,	{ 0x00B4, 0 }},
	{ 0x1ffe,	{ 0x0020, 0x0314, 0 }},
	{ 0x2000,	{ 0x0020, 0 }},
	{ 0x2001,	{ 0x0020, 0 }},
	{ 0x2002,	{ 0x0020, 0 }},
	{ 0x2003,	{ 0x0020, 0 }},
	{ 0x2004,	{ 0x0020, 0 }},
	{ 0x2005,	{ 0x0020, 0 }},
	{ 0x2006,	{ 0x0020, 0 }},
	{ 0x2007,	{ 0x0020, 0 }},
	{ 0x2008,	{ 0x0020, 0 }},
	{ 0x2009,	{ 0x0020, 0 }},
	{ 0x200a,	{ 0x0020, 0 }},
	{ 0x2011,	{ 0x2010, 0 }},
	{ 0x2017,	{ 0x0020, 0x0333, 0 }},
	{ 0x2024,	{ 0x002E, 0 }},
	{ 0x2025,	{ 0x002E, 0x002E, 0 }},
	{ 0x2026,	{ 0x002E, 0x002E, 0x002E, 0 }},
	{ 0x2033,	{ 0x2032, 0x2032, 0 }},
	{ 0x2034,	{ 0x2032, 0x2032, 0x2032, 0 }},
	{ 0x2036,	{ 0x2035, 0x2035, 0 }},
	{ 0x2037,	{ 0x2035, 0x2035, 0x2035, 0 }},
	{ 0x203c,	{ 0x0021, 0x0021, 0 }},
	{ 0x203e,	{ 0x0020, 0x0305, 0 }},
	{ 0x20a8,	{ 0x0052, 0x0073, 0 }},
	{ 0x2102,	{ 0x0043, 0 }},
	{ 0x2103,	{ 0x00B0, 0x0043, 0 }},
	{ 0x2107,	{ 0x0190, 0 }},
	{ 0x2109,	{ 0x00B0, 0x0046, 0 }},
	{ 0x210a,	{ 0x0067, 0 }},
	{ 0x210b,	{ 0x0048, 0 }},
	{ 0x210c,	{ 0x0048, 0 }},
	{ 0x210d,	{ 0x0048, 0 }},
	{ 0x210e,	{ 0x0068, 0 }},
	{ 0x210f,	{ 0x0127, 0 }},
	{ 0x2110,	{ 0x0049, 0 }},
	{ 0x2111,	{ 0x0049, 0 }},
	{ 0x2112,	{ 0x004C, 0 }},
	{ 0x2113,	{ 0x006C, 0 }},
	{ 0x2115,	{ 0x004E, 0 }},
	{ 0x2118,	{ 0x0050, 0 }},
	{ 0x2119,	{ 0x0050, 0 }},
	{ 0x211a,	{ 0x0051, 0 }},
	{ 0x211b,	{ 0x0052, 0 }},
	{ 0x211c,	{ 0x0052, 0 }},
	{ 0x211d,	{ 0x0052, 0 }},
	{ 0x2124,	{ 0x005A, 0 }},
	{ 0x2126,	{ 0x03A9, 0x03A9, 0 }},
	{ 0x2128,	{ 0x005A, 0 }},
	{ 0x212a,	{ 0x004B, 0 }},
	{ 0x212b,	{ 0x00C5, 0 }},
	{ 0x212c,	{ 0x0042, 0 }},
	{ 0x212d,	{ 0x0043, 0 }},
	{ 0x212e,	{ 0x0065, 0 }},
	{ 0x212f,	{ 0x0065, 0 }},
	{ 0x2130,	{ 0x0045, 0 }},
	{ 0x2131,	{ 0x0046, 0 }},
	{ 0x2133,	{ 0x004D, 0 }},
	{ 0x2134,	{ 0x006F, 0 }},
	{ 0x2135,	{ 0x05D0, 0 }},
	{ 0x2136,	{ 0x05D1, 0 }},
	{ 0x2137,	{ 0x05D2, 0 }},
	{ 0x2138,	{ 0x05D3, 0 }},
	{ 0x2160,	{ 0x0049, 0 }},
	{ 0x2161,	{ 0x0049, 0x0049, 0 }},
	{ 0x2162,	{ 0x0049, 0x0049, 0 }},
	{ 0x2163,	{ 0x0049, 0x0056, 0 }},
	{ 0x2164,	{ 0x0056, 0 }},
	{ 0x2165,	{ 0x0056, 0x0049, 0 }},
	{ 0x2166,	{ 0x0056, 0x0049, 0x0049, 0 }},
	{ 0x2167,	{ 0x0056, 0x0049, 0x0049, 0x0049, 0 }},
	{ 0x2168,	{ 0x0049, 0x0058, 0 }},
	{ 0x2169,	{ 0x0058, 0 }},
	{ 0x216a,	{ 0x0058, 0x0049, 0 }},
	{ 0x216b,	{ 0x0058, 0x0049, 0x0049, 0 }},
	{ 0x216c,	{ 0x004C, 0 }},
	{ 0x216d,	{ 0x0043, 0 }},
	{ 0x216e,	{ 0x0044, 0 }},
	{ 0x216f,	{ 0x004D, 0 }},
	{ 0x2170,	{ 0x0069, 0 }},
	{ 0x2171,	{ 0x0069, 0x0069, 0 }},
	{ 0x2172,	{ 0x0069, 0x0069, 0 }},
	{ 0x2173,	{ 0x0069, 0x0076, 0 }},
	{ 0x2174,	{ 0x0076, 0 }},
	{ 0x2175,	{ 0x0076, 0x0069, 0 }},
	{ 0x2176,	{ 0x0076, 0x0069, 0x0069, 0 }},
	{ 0x2177,	{ 0x0076, 0x0069, 0x0069, 0x0069, 0 }},
	{ 0x2178,	{ 0x0069, 0x0078, 0 }},
	{ 0x2179,	{ 0x0078, 0 }},
	{ 0x217a,	{ 0x0078, 0x0069, 0 }},
	{ 0x217b,	{ 0x0078, 0x0069, 0x0069, 0 }},
	{ 0x217c,	{ 0x006C, 0 }},
	{ 0x217d,	{ 0x0063, 0 }},
	{ 0x217e,	{ 0x0064, 0 }},
	{ 0x217f,	{ 0x006D, 0 }},
	{ 0x2204,	{ 0x2203, 0x0338, 0 }},
	{ 0x2206,	{ 0x0394, 0 }},
	{ 0x2209,	{ 0x2208, 0x0338, 0 }},
	{ 0x220a,	{ 0x03B5, 0 }},
	{ 0x220c,	{ 0x220B, 0x0338, 0 }},
	{ 0x220f,	{ 0x03A0, 0 }},
	{ 0x2211,	{ 0x03A3, 0 }},
	{ 0x2224,	{ 0x2223, 0x0338, 0 }},
	{ 0x2226,	{ 0x2225, 0x0338, 0 }},
	{ 0x2241,	{ 0x007E, 0x0338, 0 }},
	{ 0x2244,	{ 0x2243, 0x0338, 0 }},
	{ 0x2247,	{ 0x2246, 0x0338, 0 }},
	{ 0x2249,	{ 0x2248, 0x0338, 0 }},
	{ 0x2260,	{ 0x003D, 0x0338, 0 }},
	{ 0x2262,	{ 0x2261, 0x0338, 0 }},
	{ 0x226d,	{ 0x224D, 0x0338, 0 }},
	{ 0x226e,	{ 0x003C, 0x0338, 0 }},
	{ 0x226f,	{ 0x003E, 0x0338, 0 }},
	{ 0x2270,	{ 0x2264, 0x0338, 0 }},
	{ 0x2271,	{ 0x2265, 0x0338, 0 }},
	{ 0x2274,	{ 0x2272, 0x0338, 0 }},
	{ 0x2275,	{ 0x2273, 0x0338, 0 }},
	{ 0x2278,	{ 0x2276, 0x0338, 0 }},
	{ 0x2279,	{ 0x2277, 0x0338, 0 }},
	{ 0x2280,	{ 0x227A, 0x0338, 0 }},
	{ 0x2281,	{ 0x227B, 0x0338, 0 }},
	{ 0x2284,	{ 0x2282, 0x0338, 0 }},
	{ 0x2285,	{ 0x2283, 0x0338, 0 }},
	{ 0x2288,	{ 0x2286, 0x0338, 0 }},
	{ 0x2289,	{ 0x2287, 0x0338, 0 }},
	{ 0x22ac,	{ 0x22A2, 0x0338, 0 }},
	{ 0x22ad,	{ 0x22A8, 0x0338, 0 }},
	{ 0x22ae,	{ 0x22A9, 0x0338, 0 }},
	{ 0x22af,	{ 0x22AB, 0x0338, 0 }},
	{ 0x22e0,	{ 0x22DE, 0x0338, 0 }},
	{ 0x22e1,	{ 0x22DF, 0x0338, 0 }},
	{ 0x22e2,	{ 0x2291, 0x0338, 0 }},
	{ 0x22e3,	{ 0x2292, 0x0338, 0 }},
	{ 0x22ea,	{ 0x22B2, 0x0338, 0 }},
	{ 0x22eb,	{ 0x22B3, 0x0338, 0 }},
	{ 0x22ec,	{ 0x22B4, 0x0338, 0 }},
	{ 0x22ed,	{ 0x22B5, 0x0338, 0 }},
	{ 0x2329,	{ 0x3008, 0 }},
	{ 0x232a,	{ 0x3009, 0 }},
	{ 0x2474,	{ 0x0028, 0x0031, 0x0029, 0 }},
	{ 0x2475,	{ 0x0028, 0x0032, 0x0029, 0 }},
	{ 0x2476,	{ 0x0028, 0x0033, 0x0029, 0 }},
	{ 0x2477,	{ 0x0028, 0x0034, 0x0029, 0 }},
	{ 0x2478,	{ 0x0028, 0x0035, 0x0029, 0 }},
	{ 0x2479,	{ 0x0028, 0x0036, 0x0029, 0 }},
	{ 0x247a,	{ 0x0028, 0x0037, 0x0029, 0 }},
	{ 0x247b,	{ 0x0028, 0x0038, 0x0029, 0 }},
	{ 0x247c,	{ 0x0028, 0x0039, 0x0029, 0 }},
	{ 0x247d,	{ 0x0028, 0x0031, 0x0030, 0x0029, 0 }},
	{ 0x247e,	{ 0x0028, 0x0031, 0x0031, 0x0029, 0 }},
	{ 0x247f,	{ 0x0028, 0x0031, 0x0032, 0x0029, 0 }},
	{ 0x2480,	{ 0x0028, 0x0031, 0x0033, 0x0029, 0 }},
	{ 0x2481,	{ 0x0028, 0x0031, 0x0034, 0x0029, 0 }},
	{ 0x2482,	{ 0x0028, 0x0031, 0x0035, 0x0029, 0 }},
	{ 0x2483,	{ 0x0028, 0x0031, 0x0036, 0x0029, 0 }},
	{ 0x2484,	{ 0x0028, 0x0031, 0x0037, 0x0029, 0 }},
	{ 0x2485,	{ 0x0028, 0x0031, 0x0038, 0x0029, 0 }},
	{ 0x2486,	{ 0x0028, 0x0031, 0x0039, 0x0029, 0 }},
	{ 0x2487,	{ 0x0028, 0x0032, 0x0030, 0x0029, 0 }},
	{ 0x2488,	{ 0x0031, 0x002E, 0 }},
	{ 0x2489,	{ 0x0032, 0x002E, 0 }},
	{ 0x248a,	{ 0x0033, 0x002E, 0 }},
	{ 0x248b,	{ 0x0034, 0x002E, 0 }},
	{ 0x248c,	{ 0x0035, 0x002E, 0 }},
	{ 0x248d,	{ 0x0036, 0x002E, 0 }},
	{ 0x248e,	{ 0x0037, 0x002E, 0 }},
	{ 0x248f,	{ 0x0038, 0x002E, 0 }},
	{ 0x2490,	{ 0x0039, 0x002E, 0 }},
	{ 0x2491,	{ 0x0031, 0x0030, 0x002E, 0 }},
	{ 0x2492,	{ 0x0031, 0x0031, 0x002E, 0 }},
	{ 0x2493,	{ 0x0031, 0x0032, 0x002E, 0 }},
	{ 0x2494,	{ 0x0031, 0x0033, 0x002E, 0 }},
	{ 0x2495,	{ 0x0031, 0x0034, 0x002E, 0 }},
	{ 0x2496,	{ 0x0031, 0x0035, 0x002E, 0 }},
	{ 0x2497,	{ 0x0031, 0x0036, 0x002E, 0 }},
	{ 0x2498,	{ 0x0031, 0x0037, 0x002E, 0 }},
	{ 0x2499,	{ 0x0031, 0x0038, 0x002E, 0 }},
	{ 0x249a,	{ 0x0031, 0x0039, 0x002E, 0 }},
	{ 0x249b,	{ 0x0032, 0x0030, 0x002E, 0 }},
	{ 0x249c,	{ 0x0028, 0x0061, 0x0029, 0 }},
	{ 0x249d,	{ 0x0028, 0x0062, 0x0029, 0 }},
	{ 0x249e,	{ 0x0028, 0x0063, 0x0029, 0 }},
	{ 0x249f,	{ 0x0028, 0x0064, 0x0029, 0 }},
	{ 0x24a0,	{ 0x0028, 0x0065, 0x0029, 0 }},
	{ 0x24a1,	{ 0x0028, 0x0066, 0x0029, 0 }},
	{ 0x24a2,	{ 0x0028, 0x0067, 0x0029, 0 }},
	{ 0x24a3,	{ 0x0028, 0x0068, 0x0029, 0 }},
	{ 0x24a4,	{ 0x0028, 0x0069, 0x0029, 0 }},
	{ 0x24a5,	{ 0x0028, 0x006A, 0x0029, 0 }},
	{ 0x24a6,	{ 0x0028, 0x006B, 0x0029, 0 }},
	{ 0x24a7,	{ 0x0028, 0x006C, 0x0029, 0 }},
	{ 0x24a8,	{ 0x0028, 0x006D, 0x0029, 0 }},
	{ 0x24a9,	{ 0x0028, 0x006E, 0x0029, 0 }},
	{ 0x24aa,	{ 0x0028, 0x006F, 0x0029, 0 }},
	{ 0x24ab,	{ 0x0028, 0x0070, 0x0029, 0 }},
	{ 0x24ac,	{ 0x0028, 0x0071, 0x0029, 0 }},
	{ 0x24ad,	{ 0x0028, 0x0072, 0x0029, 0 }},
	{ 0x24ae,	{ 0x0028, 0x0073, 0x0029, 0 }},
	{ 0x24af,	{ 0x0028, 0x0074, 0x0029, 0 }},
	{ 0x24b0,	{ 0x0028, 0x0075, 0x0029, 0 }},
	{ 0x24b1,	{ 0x0028, 0x0076, 0x0029, 0 }},
	{ 0x24b2,	{ 0x0028, 0x0077, 0x0029, 0 }},
	{ 0x24b3,	{ 0x0028, 0x0078, 0x0029, 0 }},
	{ 0x24b4,	{ 0x0028, 0x0079, 0x0029, 0 }},
	{ 0x24b5,	{ 0x0028, 0x007A, 0x0029, 0 }},
	{ 0x3000,	{ 0x0020, 0 }},
	{ 0x3031,	{ 0x3033, 0x3035, 0 }},
	{ 0x3032,	{ 0x3034, 0x3035, 0 }},
	{ 0x304c,	{ 0x304B, 0x3099, 0 }},
	{ 0x304e,	{ 0x304D, 0x3099, 0 }},
	{ 0x3050,	{ 0x304F, 0x3099, 0 }},
	{ 0x3052,	{ 0x3051, 0x3099, 0 }},
	{ 0x3054,	{ 0x3053, 0x3099, 0 }},
	{ 0x3056,	{ 0x3055, 0x3099, 0 }},
	{ 0x3058,	{ 0x3057, 0x3099, 0 }},
	{ 0x305a,	{ 0x3059, 0x3099, 0 }},
	{ 0x305c,	{ 0x305B, 0x3099, 0 }},
	{ 0x305e,	{ 0x305D, 0x3099, 0 }},
	{ 0x3060,	{ 0x305F, 0x3099, 0 }},
	{ 0x3062,	{ 0x3061, 0x3099, 0 }},
	{ 0x3065,	{ 0x3064, 0x3099, 0 }},
	{ 0x3067,	{ 0x3066, 0x3099, 0 }},
	{ 0x3069,	{ 0x3068, 0x3099, 0 }},
	{ 0x3070,	{ 0x306F, 0x3099, 0 }},
	{ 0x3071,	{ 0x306F, 0x309A, 0 }},
	{ 0x3073,	{ 0x3072, 0x3099, 0 }},
	{ 0x3074,	{ 0x3072, 0x309A, 0 }},
	{ 0x3076,	{ 0x3075, 0x3099, 0 }},
	{ 0x3077,	{ 0x3075, 0x309A, 0 }},
	{ 0x3079,	{ 0x3078, 0x3099, 0 }},
	{ 0x307a,	{ 0x3078, 0x309A, 0 }},
	{ 0x307c,	{ 0x307B, 0x3099, 0 }},
	{ 0x307d,	{ 0x307B, 0x309A, 0 }},
	{ 0x3094,	{ 0x3046, 0x3099, 0 }},
	{ 0x309b,	{ 0x0020, 0x3099, 0 }},
	{ 0x309c,	{ 0x0020, 0x309A, 0 }},
	{ 0x309e,	{ 0x309D, 0x3099, 0 }},
	{ 0x30ac,	{ 0x30AB, 0x3099, 0 }},
	{ 0x30ae,	{ 0x30AD, 0x3099, 0 }},
	{ 0x30b0,	{ 0x30AF, 0x3099, 0 }},
	{ 0x30b2,	{ 0x30B1, 0x3099, 0 }},
	{ 0x30b4,	{ 0x30B3, 0x3099, 0 }},
	{ 0x30b6,	{ 0x30B5, 0x3099, 0 }},
	{ 0x30b8,	{ 0x30B7, 0x3099, 0 }},
	{ 0x30ba,	{ 0x30B9, 0x3099, 0 }},
	{ 0x30bc,	{ 0x30BB, 0x3099, 0 }},
	{ 0x30be,	{ 0x30BD, 0x3099, 0 }},
	{ 0x30c0,	{ 0x30BF, 0x3099, 0 }},
	{ 0x30c2,	{ 0x30C1, 0x3099, 0 }},
	{ 0x30c5,	{ 0x30C4, 0x3099, 0 }},
	{ 0x30c7,	{ 0x30C6, 0x3099, 0 }},
	{ 0x30c9,	{ 0x30C8, 0x3099, 0 }},
	{ 0x30d0,	{ 0x30CF, 0x3099, 0 }},
	{ 0x30d1,	{ 0x30CF, 0x309A, 0 }},
	{ 0x30d3,	{ 0x30D2, 0x3099, 0 }},
	{ 0x30d4,	{ 0x30D2, 0x309A, 0 }},
	{ 0x30d6,	{ 0x30D5, 0x3099, 0 }},
	{ 0x30d7,	{ 0x30D5, 0x309A, 0 }},
	{ 0x30d9,	{ 0x30D8, 0x3099, 0 }},
	{ 0x30da,	{ 0x30D8, 0x309A, 0 }},
	{ 0x30dc,	{ 0x30DB, 0x3099, 0 }},
	{ 0x30dd,	{ 0x30DB, 0x309A, 0 }},
	{ 0x30f4,	{ 0x30A6, 0x3099, 0 }},
	{ 0x30f7,	{ 0x30EF, 0x3099, 0 }},
	{ 0x30f8,	{ 0x30F0, 0x3099, 0 }},
	{ 0x30f9,	{ 0x30F1, 0x3099, 0 }},
	{ 0x30fa,	{ 0x30F2, 0x3099, 0 }},
	{ 0x30fb,	{ 0x00B7, 0 }},
	{ 0x30fe,	{ 0x30FD, 0x3099, 0 }},
	{ 0x3131,	{ 0x1100, 0 }},
	{ 0x3132,	{ 0x1101, 0 }},
	{ 0x3133,	{ 0x11AA, 0 }},
	{ 0x3134,	{ 0x1102, 0 }},
	{ 0x3135,	{ 0x11AC, 0 }},
	{ 0x3136,	{ 0x11AD, 0 }},
	{ 0x3137,	{ 0x1103, 0 }},
	{ 0x3138,	{ 0x1104, 0 }},
	{ 0x3139,	{ 0x1105, 0 }},
	{ 0x313a,	{ 0x11B0, 0 }},
	{ 0x313b,	{ 0x11B1, 0 }},
	{ 0x313c,	{ 0x11B2, 0 }},
	{ 0x313d,	{ 0x11B3, 0 }},
	{ 0x313e,	{ 0x11B4, 0 }},
	{ 0x313f,	{ 0x11B5, 0 }},
	{ 0x3140,	{ 0x111A, 0 }},
	{ 0x3141,	{ 0x1106, 0 }},
	{ 0x3142,	{ 0x1107, 0 }},
	{ 0x3143,	{ 0x1108, 0 }},
	{ 0x3144,	{ 0x1121, 0 }},
	{ 0x3145,	{ 0x1109, 0 }},
	{ 0x3146,	{ 0x110A, 0 }},
	{ 0x3147,	{ 0x110B, 0 }},
	{ 0x3148,	{ 0x110C, 0 }},
	{ 0x3149,	{ 0x110D, 0 }},
	{ 0x314a,	{ 0x110E, 0 }},
	{ 0x314b,	{ 0x110F, 0 }},
	{ 0x314c,	{ 0x1110, 0 }},
	{ 0x314d,	{ 0x1111, 0 }},
	{ 0x314e,	{ 0x1112, 0 }},
	{ 0x314f,	{ 0x1161, 0 }},
	{ 0x3150,	{ 0x1162, 0 }},
	{ 0x3151,	{ 0x1163, 0 }},
	{ 0x3152,	{ 0x1164, 0 }},
	{ 0x3153,	{ 0x1165, 0 }},
	{ 0x3154,	{ 0x1166, 0 }},
	{ 0x3155,	{ 0x1167, 0 }},
	{ 0x3156,	{ 0x1168, 0 }},
	{ 0x3157,	{ 0x1169, 0 }},
	{ 0x3158,	{ 0x116A, 0 }},
	{ 0x3159,	{ 0x116B, 0 }},
	{ 0x315a,	{ 0x116C, 0 }},
	{ 0x315b,	{ 0x116D, 0 }},
	{ 0x315c,	{ 0x116E, 0 }},
	{ 0x315d,	{ 0x116F, 0 }},
	{ 0x315e,	{ 0x1170, 0 }},
	{ 0x315f,	{ 0x1171, 0 }},
	{ 0x3160,	{ 0x1172, 0 }},
	{ 0x3161,	{ 0x1173, 0 }},
	{ 0x3162,	{ 0x1174, 0 }},
	{ 0x3163,	{ 0x1175, 0 }},
	{ 0x3164,	{ 0x1160, 0 }},
	{ 0x3165,	{ 0x1114, 0 }},
	{ 0x3166,	{ 0x1115, 0 }},
	{ 0x3167,	{ 0x11C7, 0 }},
	{ 0x3168,	{ 0x11C8, 0 }},
	{ 0x3169,	{ 0x11CC, 0 }},
	{ 0x316a,	{ 0x11CE, 0 }},
	{ 0x316b,	{ 0x11D3, 0 }},
	{ 0x316c,	{ 0x11D7, 0 }},
	{ 0x316d,	{ 0x11D9, 0 }},
	{ 0x316e,	{ 0x111C, 0 }},
	{ 0x316f,	{ 0x11DD, 0 }},
	{ 0x3170,	{ 0x11DF, 0 }},
	{ 0x3171,	{ 0x111D, 0 }},
	{ 0x3172,	{ 0x111E, 0 }},
	{ 0x3173,	{ 0x1120, 0 }},
	{ 0x3174,	{ 0x1122, 0 }},
	{ 0x3175,	{ 0x1123, 0 }},
	{ 0x3176,	{ 0x1127, 0 }},
	{ 0x3177,	{ 0x1129, 0 }},
	{ 0x3178,	{ 0x112B, 0 }},
	{ 0x3179,	{ 0x112C, 0 }},
	{ 0x317a,	{ 0x112D, 0 }},
	{ 0x317b,	{ 0x112E, 0 }},
	{ 0x317c,	{ 0x112F, 0 }},
	{ 0x317d,	{ 0x1132, 0 }},
	{ 0x317e,	{ 0x1136, 0 }},
	{ 0x317f,	{ 0x1140, 0 }},
	{ 0x3180,	{ 0x1147, 0 }},
	{ 0x3181,	{ 0x114C, 0 }},
	{ 0x3182,	{ 0x11F1, 0 }},
	{ 0x3183,	{ 0x11F2, 0 }},
	{ 0x3184,	{ 0x1157, 0 }},
	{ 0x3185,	{ 0x1158, 0 }},
	{ 0x3186,	{ 0x1159, 0 }},
	{ 0x3187,	{ 0x1184, 0 }},
	{ 0x3188,	{ 0x1185, 0 }},
	{ 0x3189,	{ 0x1188, 0 }},
	{ 0x318a,	{ 0x1191, 0 }},
	{ 0x318b,	{ 0x1192, 0 }},
	{ 0x318c,	{ 0x1194, 0 }},
	{ 0x318d,	{ 0x119E, 0 }},
	{ 0x318e,	{ 0x11A1, 0 }},
	{ 0x3200,	{ 0x0028, 0x1100, 0x0029, 0 }},
	{ 0x3201,	{ 0x0028, 0x1102, 0x0029, 0 }},
	{ 0x3202,	{ 0x0028, 0x1103, 0x0029, 0 }},
	{ 0x3203,	{ 0x0028, 0x1105, 0x0029, 0 }},
	{ 0x3204,	{ 0x0028, 0x1106, 0x0029, 0 }},
	{ 0x3205,	{ 0x0028, 0x1107, 0x0029, 0 }},
	{ 0x3206,	{ 0x0028, 0x1109, 0x0029, 0 }},
	{ 0x3207,	{ 0x0028, 0x110B, 0x0029, 0 }},
	{ 0x3208,	{ 0x0028, 0x110C, 0x0029, 0 }},
	{ 0x3209,	{ 0x0028, 0x110E, 0x0029, 0 }},
	{ 0x320a,	{ 0x0028, 0x110F, 0x0029, 0 }},
	{ 0x320b,	{ 0x0028, 0x1110, 0x0029, 0 }},
	{ 0x320c,	{ 0x0028, 0x1111, 0x0029, 0 }},
	{ 0x320d,	{ 0x0028, 0x1112, 0x0029, 0 }},
	{ 0x320e,	{ 0x0028, 0x1100, 0x1161, 0x0029, 0 }},
	{ 0x320f,	{ 0x0028, 0x1102, 0x1161, 0x0029, 0 }},
	{ 0x3210,	{ 0x0028, 0x1103, 0x1161, 0x0029, 0 }},
	{ 0x3211,	{ 0x0028, 0x1105, 0x1161, 0x0029, 0 }},
	{ 0x3212,	{ 0x0028, 0x1106, 0x1161, 0x0029, 0 }},
	{ 0x3213,	{ 0x0028, 0x1107, 0x1161, 0x0029, 0 }},
	{ 0x3214,	{ 0x0028, 0x1109, 0x1161, 0x0029, 0 }},
	{ 0x3215,	{ 0x0028, 0x110B, 0x1161, 0x0029, 0 }},
	{ 0x3216,	{ 0x0028, 0x110C, 0x1161, 0x0029, 0 }},
	{ 0x3217,	{ 0x0028, 0x110E, 0x1161, 0x0029, 0 }},
	{ 0x3218,	{ 0x0028, 0x110F, 0x1161, 0x0029, 0 }},
	{ 0x3219,	{ 0x0028, 0x1110, 0x1161, 0x0029, 0 }},
	{ 0x321a,	{ 0x0028, 0x1111, 0x1161, 0x0029, 0 }},
	{ 0x321b,	{ 0x0028, 0x1112, 0x1161, 0x0029, 0 }},
	{ 0x321c,	{ 0x0028, 0x110C, 0x1161, 0x0029, 0 }},
	{ 0x3220,	{ 0x0028, 0x4E00, 0x0029, 0 }},
	{ 0x3221,	{ 0x0028, 0x4E8C, 0x0029, 0 }},
	{ 0x3222,	{ 0x0028, 0x4E09, 0x0029, 0 }},
	{ 0x3223,	{ 0x0028, 0x56DB, 0x0029, 0 }},
	{ 0x3224,	{ 0x0028, 0x4E94, 0x0029, 0 }},
	{ 0x3225,	{ 0x0028, 0x516D, 0x0029, 0 }},
	{ 0x3226,	{ 0x0028, 0x4E03, 0x0029, 0 }},
	{ 0x3227,	{ 0x0028, 0x516B, 0x0029, 0 }},
	{ 0x3228,	{ 0x0028, 0x4E5D, 0x0029, 0 }},
	{ 0x3229,	{ 0x0028, 0x5341, 0x0029, 0 }},
	{ 0x322a,	{ 0x0028, 0x6708, 0x0029, 0 }},
	{ 0x322b,	{ 0x0028, 0x706B, 0x0029, 0 }},
	{ 0x322c,	{ 0x0028, 0x6C34, 0x0029, 0 }},
	{ 0x322d,	{ 0x0028, 0x6728, 0x0029, 0 }},
	{ 0x322e,	{ 0x0028, 0x91D1, 0x0029, 0 }},
	{ 0x322f,	{ 0x0028, 0x571F, 0x0029, 0 }},
	{ 0x3230,	{ 0x0028, 0x65E5, 0x0029, 0 }},
	{ 0x3231,	{ 0x0028, 0x682A, 0x0029, 0 }},
	{ 0x3232,	{ 0x0028, 0x6709, 0x0029, 0 }},
	{ 0x3233,	{ 0x0028, 0x793E, 0x0029, 0 }},
	{ 0x3234,	{ 0x0028, 0x540D, 0x0029, 0 }},
	{ 0x3235,	{ 0x0028, 0x7279, 0x0029, 0 }},
	{ 0x3236,	{ 0x0028, 0x8CA1, 0x0029, 0 }},
	{ 0x3237,	{ 0x0028, 0x795D, 0x0029, 0 }},
	{ 0x3238,	{ 0x0028, 0x52B4, 0x0029, 0 }},
	{ 0x3239,	{ 0x0028, 0x4EE3, 0x0029, 0 }},
	{ 0x323a,	{ 0x0028, 0x547C, 0x0029, 0 }},
	{ 0x323b,	{ 0x0028, 0x5B66, 0x0029, 0 }},
	{ 0x323c,	{ 0x0028, 0x76E3, 0x0029, 0 }},
	{ 0x323d,	{ 0x0028, 0x4F01, 0x0029, 0 }},
	{ 0x323e,	{ 0x0028, 0x8CC7, 0x0029, 0 }},
	{ 0x323f,	{ 0x0028, 0x5354, 0x0029, 0 }},
	{ 0x3240,	{ 0x0028, 0x796D, 0x0029, 0 }},
	{ 0x3241,	{ 0x0028, 0x4F11, 0x0029, 0 }},
	{ 0x3242,	{ 0x0028, 0x81EA, 0x0029, 0 }},
	{ 0x3243,	{ 0x0028, 0x81F3, 0x0029, 0 }},
	{ 0x32c0,	{ 0x0031, 0x6708, 0 }},
	{ 0x32c1,	{ 0x0032, 0x6708, 0 }},
	{ 0x32c2,	{ 0x0033, 0x6708, 0 }},
	{ 0x32c3,	{ 0x0034, 0x6708, 0 }},
	{ 0x32c4,	{ 0x0035, 0x6708, 0 }},
	{ 0x32c5,	{ 0x0036, 0x6708, 0 }},
	{ 0x32c6,	{ 0x0037, 0x6708, 0 }},
	{ 0x32c7,	{ 0x0038, 0x6708, 0 }},
	{ 0x32c8,	{ 0x0039, 0x6708, 0 }},
	{ 0x32c9,	{ 0x0031, 0x0030, 0x6708, 0 }},
	{ 0x32ca,	{ 0x0031, 0x0031, 0x6708, 0 }},
	{ 0x32cb,	{ 0x0031, 0x0032, 0x6708, 0 }},
	{ 0x3300,	{ 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0 }},
	{ 0x3301,	{ 0x30A2, 0x30EB, 0x30D5, 0x30A2, 0 }},
	{ 0x3302,	{ 0x30A2, 0x30F3, 0x30D8, 0x309A, 0x30A2, 0 }},
	{ 0x3303,	{ 0x30A2, 0x30FC, 0x30EB, 0 }},
	{ 0x3304,	{ 0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x3099, 0 }},
	{ 0x3305,	{ 0x30A4, 0x30F3, 0x30C1, 0 }},
	{ 0x3306,	{ 0x30A6, 0x30AA, 0x30F3, 0 }},
	{ 0x3307,	{ 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x3099, 0 }},
	{ 0x3308,	{ 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0 }},
	{ 0x3309,	{ 0x30AA, 0x30F3, 0x30B9, 0 }},
	{ 0x330a,	{ 0x30AA, 0x30FC, 0x30E0, 0 }},
	{ 0x330b,	{ 0x30AB, 0x30A4, 0x30EA, 0 }},
	{ 0x330c,	{ 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0 }},
	{ 0x330d,	{ 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0 }},
	{ 0x330e,	{ 0x30AB, 0x3099, 0x30ED, 0x30F3, 0 }},
	{ 0x330f,	{ 0x30AB, 0x3099, 0x30F3, 0x30DE, 0 }},
	{ 0x3310,	{ 0x30AD, 0x3099, 0x30AB, 0x3099, 0 }},
	{ 0x3311,	{ 0x30AD, 0x3099, 0x30CB, 0x30FC, 0 }},
	{ 0x3312,	{ 0x30AD, 0x30E6, 0x30EA, 0x30FC, 0 }},
	{ 0x3313,	{ 0x30AD, 0x3099, 0x30EB, 0x30BF, 0x3099, 0x30FC, 0 }},
	{ 0x3314,	{ 0x30AD, 0x30ED, 0 }},
	{ 0x3315,	{ 0x30AD, 0x30ED, 0x30AF, 0x3099, 0x30E9, 0x30E0, 0 }},
	{ 0x3316,	{ 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0 }},
	{ 0x3317,	{ 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0 }},
	{ 0x3318,	{ 0x30AF, 0x3099, 0x30E9, 0x30E0, 0 }},
	{ 0x3319,	{ 0x30AF, 0x3099, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0 }},
	{ 0x331a,	{ 0x30AF, 0x30EB, 0x30BB, 0x3099, 0x30A4, 0x30ED, 0 }},
	{ 0x331b,	{ 0x30AF, 0x30ED, 0x30FC, 0x30F3, 0x30A8, 0 }},
	{ 0x331c,	{ 0x30B1, 0x30FC, 0x30B9, 0 }},
	{ 0x331d,	{ 0x30B3, 0x30EB, 0x30CA, 0 }},
	{ 0x331e,	{ 0x30B3, 0x30FC, 0x30DB, 0x309A, 0 }},
	{ 0x331f,	{ 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0 }},
	{ 0x3320,	{ 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0 }},
	{ 0x3321,	{ 0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x3099, 0 }},
	{ 0x3322,	{ 0x30BB, 0x30F3, 0x30C1, 0 }},
	{ 0x3323,	{ 0x30BB, 0x30F3, 0x30C8, 0 }},
	{ 0x3324,	{ 0x30BF, 0x3099, 0x30FC, 0x30B9, 0 }},
	{ 0x3325,	{ 0x30C6, 0x3099, 0x30B7, 0 }},
	{ 0x3326,	{ 0x30C8, 0x3099, 0x30EB, 0 }},
	{ 0x3327,	{ 0x30C8, 0x30F3, 0 }},
	{ 0x3328,	{ 0x30F3, 0x30A2, 0x30CE, 0 }},
	{ 0x3329,	{ 0x30F3, 0x30AA, 0 }},
	{ 0x332a,	{ 0x30CF, 0x30A4, 0x30C4, 0 }},
	{ 0x332b,	{ 0x30CF, 0x309A, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0 }},
	{ 0x332c,	{ 0x30CF, 0x309A, 0x30FC, 0x30C4, 0x30F3, 0x30C8, 0 }},
	{ 0x332d,	{ 0x30CF, 0x3099, 0x30FC, 0x30EC, 0x30EB, 0x30C8, 0 }},
	{ 0x332e,	{ 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0 }},
	{ 0x332f,	{ 0x30D2, 0x309A, 0x30AF, 0x30EB, 0 }},
	{ 0x3330,	{ 0x30D2, 0x309A, 0x30B3, 0 }},
	{ 0x3331,	{ 0x30D2, 0x3099, 0x30EB, 0 }},
	{ 0x3332,	{ 0x30D5, 0x30A2, 0x30E9, 0 }},
	{ 0x3333,	{ 0x30D5, 0x30A4, 0x30FC, 0x30C8, 0 }},
	{ 0x3334,	{ 0x30D5, 0x3099, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0 }},
	{ 0x3335,	{ 0x30D5, 0x30E9, 0x30F3, 0 }},
	{ 0x3336,	{ 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0 }},
	{ 0x3337,	{ 0x30D8, 0x309A, 0x30BD, 0 }},
	{ 0x3338,	{ 0x30D8, 0x309A, 0x30CB, 0x30D2, 0 }},
	{ 0x3339,	{ 0x30D8, 0x30EB, 0x30C4, 0 }},
	{ 0x333a,	{ 0x30D8, 0x309A, 0x30F3, 0x30B9, 0 }},
	{ 0x333b,	{ 0x30D8, 0x309A, 0x30FC, 0x30B7, 0x3099, 0 }},
	{ 0x333c,	{ 0x30D8, 0x3099, 0x30FC, 0x30BF, 0 }},
	{ 0x333d,	{ 0x30DB, 0x309A, 0x30A4, 0x30F3, 0x30C8, 0 }},
	{ 0x333e,	{ 0x30DB, 0x3099, 0x30EB, 0x30C8, 0 }},
	{ 0x333f,	{ 0x30DB, 0x30F3, 0 }},
	{ 0x3340,	{ 0x30DB, 0x309A, 0x30F3, 0x30C8, 0x3099, 0 }},
	{ 0x3341,	{ 0x30DB, 0x30FC, 0x30EB, 0 }},
	{ 0x3342,	{ 0x30DB, 0x30FC, 0x30F3, 0 }},
	{ 0x3343,	{ 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0 }},
	{ 0x3344,	{ 0x30DE, 0x30A4, 0x30EB, 0 }},
	{ 0x3345,	{ 0x30DE, 0x30C3, 0x30CF, 0 }},
	{ 0x3346,	{ 0x30DE, 0x30EB, 0x30AF, 0 }},
	{ 0x3347,	{ 0x30DE, 0x30F3, 0x30B7, 0x30E8, 0x30F3, 0 }},
	{ 0x3348,	{ 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0 }},
	{ 0x3349,	{ 0x30DF, 0x30EA, 0 }},
	{ 0x334a,	{ 0x30DF, 0x30EA, 0x30CF, 0x3099, 0x30FC, 0x30EB, 0 }},
	{ 0x334b,	{ 0x30E1, 0x30AB, 0x3099, 0x30EB, 0 }},
	{ 0x334c,	{ 0x30E1, 0x30AB, 0x3099, 0x30C8, 0x30F3, 0 }},
	{ 0x334d,	{ 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0 }},
	{ 0x334e,	{ 0x30E4, 0x30FC, 0x30C8, 0x3099, 0 }},
	{ 0x334f,	{ 0x30E4, 0x30FC, 0x30EB, 0 }},
	{ 0x3350,	{ 0x30E6, 0x30A2, 0x30F3, 0 }},
	{ 0x3351,	{ 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0 }},
	{ 0x3352,	{ 0x30EA, 0x30E9, 0 }},
	{ 0x3353,	{ 0x30EB, 0x30D2, 0x309A, 0x30FC, 0 }},
	{ 0x3354,	{ 0x30EB, 0x30FC, 0x30D5, 0x3099, 0x30EB, 0 }},
	{ 0x3355,	{ 0x30EC, 0x30E0, 0 }},
	{ 0x3356,	{ 0x30EC, 0x30F3, 0x30C8, 0x30B1, 0x3099, 0x30F3, 0 }},
	{ 0x3357,	{ 0x30EF, 0x30C3, 0x30C8, 0 }},
	{ 0x3358,	{ 0x0030, 0x70B9, 0 }},
	{ 0x3359,	{ 0x0031, 0x70B9, 0 }},
	{ 0x335a,	{ 0x0032, 0x70B9, 0 }},
	{ 0x335b,	{ 0x0033, 0x70B9, 0 }},
	{ 0x335c,	{ 0x0034, 0x70B9, 0 }},
	{ 0x335d,	{ 0x0035, 0x70B9, 0 }},
	{ 0x335e,	{ 0x0036, 0x70B9, 0 }},
	{ 0x335f,	{ 0x0037, 0x70B9, 0 }},
	{ 0x3360,	{ 0x0038, 0x70B9, 0 }},
	{ 0x3361,	{ 0x0039, 0x70B9, 0 }},
	{ 0x3362,	{ 0x0031, 0x0030, 0x70B9, 0 }},
	{ 0x3363,	{ 0x0031, 0x0031, 0x70B9, 0 }},
	{ 0x3364,	{ 0x0031, 0x0032, 0x70B9, 0 }},
	{ 0x3365,	{ 0x0031, 0x0033, 0x70B9, 0 }},
	{ 0x3366,	{ 0x0031, 0x0034, 0x70B9, 0 }},
	{ 0x3367,	{ 0x0031, 0x0035, 0x70B9, 0 }},
	{ 0x3368,	{ 0x0031, 0x0036, 0x70B9, 0 }},
	{ 0x3369,	{ 0x0031, 0x0037, 0x70B9, 0 }},
	{ 0x336a,	{ 0x0031, 0x0038, 0x70B9, 0 }},
	{ 0x336b,	{ 0x0031, 0x0039, 0x70B9, 0 }},
	{ 0x336c,	{ 0x0032, 0x0030, 0x70B9, 0 }},
	{ 0x336d,	{ 0x0032, 0x0031, 0x70B9, 0 }},
	{ 0x336e,	{ 0x0032, 0x0032, 0x70B9, 0 }},
	{ 0x336f,	{ 0x0032, 0x0033, 0x70B9, 0 }},
	{ 0x3370,	{ 0x0032, 0x0034, 0x70B9, 0 }},
	{ 0x3371,	{ 0x0068, 0x0050, 0x0061, 0 }},
	{ 0x3372,	{ 0x0064, 0x0061, 0 }},
	{ 0x3373,	{ 0x0041, 0x0055, 0 }},
	{ 0x3374,	{ 0x0062, 0x0061, 0x0072, 0 }},
	{ 0x3375,	{ 0x006F, 0x0056, 0 }},
	{ 0x3376,	{ 0x0070, 0x0063, 0 }},
	{ 0x337b,	{ 0x5E73, 0x6210, 0 }},
	{ 0x337c,	{ 0x662D, 0x77E5, 0 }},
	{ 0x337d,	{ 0x5927, 0x6B63, 0 }},
	{ 0x337e,	{ 0x660E, 0x6CBB, 0 }},
	{ 0x337f,	{ 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0 }},
	{ 0x3380,	{ 0x0070, 0x0041, 0 }},
	{ 0x3381,	{ 0x006E, 0x0041, 0 }},
	{ 0x3382,	{ 0x03BC, 0x0041, 0 }},
	{ 0x3383,	{ 0x006D, 0x0041, 0 }},
	{ 0x3384,	{ 0x006B, 0x0041, 0 }},
	{ 0x3385,	{ 0x004B, 0x0042, 0 }},
	{ 0x3386,	{ 0x004D, 0x0042, 0 }},
	{ 0x3387,	{ 0x0047, 0x0042, 0 }},
	{ 0x3388,	{ 0x0063, 0x0061, 0x006C, 0 }},
	{ 0x3389,	{ 0x006B, 0x0063, 0x0061, 0x006C, 0 }},
	{ 0x338a,	{ 0x0070, 0x0046, 0 }},
	{ 0x338b,	{ 0x006E, 0x0046, 0 }},
	{ 0x338c,	{ 0x03BC, 0x0046, 0 }},
	{ 0x338d,	{ 0x03BC, 0x0067, 0 }},
	{ 0x338e,	{ 0x006D, 0x0067, 0 }},
	{ 0x338f,	{ 0x006B, 0x0067, 0 }},
	{ 0x3390,	{ 0x0048, 0x007A, 0 }},
	{ 0x3391,	{ 0x006B, 0x0048, 0x007A, 0 }},
	{ 0x3392,	{ 0x004D, 0x0048, 0x007A, 0 }},
	{ 0x3393,	{ 0x0047, 0x0048, 0x007A, 0 }},
	{ 0x3394,	{ 0x0054, 0x0048, 0x007A, 0 }},
	{ 0x3395,	{ 0x03BC, 0x2113, 0 }},
	{ 0x3396,	{ 0x006D, 0x2113, 0 }},
	{ 0x3397,	{ 0x0064, 0x2113, 0 }},
	{ 0x3398,	{ 0x006B, 0x2113, 0 }},
	{ 0x3399,	{ 0x0066, 0x006D, 0 }},
	{ 0x339a,	{ 0x006E, 0x006D, 0 }},
	{ 0x339b,	{ 0x03BC, 0x006D, 0 }},
	{ 0x339c,	{ 0x006D, 0x006D, 0 }},
	{ 0x339d,	{ 0x0063, 0x006D, 0 }},
	{ 0x339e,	{ 0x006B, 0x006D, 0 }},
	{ 0x339f,	{ 0x006D, 0x006D, 0x00B2, 0 }},
	{ 0x33a0,	{ 0x0063, 0x006D, 0x00B2, 0 }},
	{ 0x33a1,	{ 0x006D, 0x00B2, 0 }},
	{ 0x33a2,	{ 0x006B, 0x006D, 0x00B2, 0 }},
	{ 0x33a3,	{ 0x006D, 0x006D, 0x00B3, 0 }},
	{ 0x33a4,	{ 0x0063, 0x006D, 0x00B3, 0 }},
	{ 0x33a5,	{ 0x006D, 0x00B3, 0 }},
	{ 0x33a6,	{ 0x006B, 0x006D, 0x00B3, 0 }},
	{ 0x33a7,	{ 0x006D, 0x2215, 0x0073, 0 }},
	{ 0x33a8,	{ 0x006D, 0x2215, 0x0073, 0x00B2, 0 }},
	{ 0x33a9,	{ 0x0050, 0x0061, 0 }},
	{ 0x33aa,	{ 0x006B, 0x0050, 0x0061, 0 }},
	{ 0x33ab,	{ 0x004D, 0x0050, 0x0061, 0 }},
	{ 0x33ac,	{ 0x0047, 0x0050, 0x0061, 0 }},
	{ 0x33ad,	{ 0x0072, 0x0061, 0x0064, 0 }},
	{ 0x33ae,	{ 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0 }},
	{ 0x33af,	{ 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2, 0 }},
	{ 0x33b0,	{ 0x0070, 0x0073, 0 }},
	{ 0x33b1,	{ 0x006E, 0x0073, 0 }},
	{ 0x33b2,	{ 0x03BC, 0x0073, 0 }},
	{ 0x33b3,	{ 0x006D, 0x0073, 0 }},
	{ 0x33b4,	{ 0x0070, 0x0056, 0 }},
	{ 0x33b5,	{ 0x006E, 0x0056, 0 }},
	{ 0x33b6,	{ 0x03BC, 0x0056, 0 }},
	{ 0x33b7,	{ 0x006D, 0x0056, 0 }},
	{ 0x33b8,	{ 0x006B, 0x0056, 0 }},
	{ 0x33b9,	{ 0x004D, 0x0056, 0 }},
	{ 0x33ba,	{ 0x0070, 0x0057, 0 }},
	{ 0x33bb,	{ 0x006E, 0x0057, 0 }},
	{ 0x33bc,	{ 0x03BC, 0x0057, 0 }},
	{ 0x33bd,	{ 0x006D, 0x0057, 0 }},
	{ 0x33be,	{ 0x006B, 0x0057, 0 }},
	{ 0x33bf,	{ 0x004D, 0x0057, 0 }},
	{ 0x33c0,	{ 0x006B, 0x03A9, 0 }},
	{ 0x33c1,	{ 0x004D, 0x03A9, 0 }},
	{ 0x33c2,	{ 0x0061, 0x002E, 0x006D, 0x002E, 0 }},
	{ 0x33c3,	{ 0x0042, 0x0071, 0 }},
	{ 0x33c4,	{ 0x0063, 0x0063, 0 }},
	{ 0x33c5,	{ 0x0063, 0x0064, 0 }},
	{ 0x33c6,	{ 0x0043, 0x2215, 0x006B, 0x0067, 0 }},
	{ 0x33c7,	{ 0x0043, 0x006F, 0 }},
	{ 0x33c8,	{ 0x0064, 0x0042, 0 }},
	{ 0x33c9,	{ 0x0047, 0x0079, 0 }},
	{ 0x33ca,	{ 0x0068, 0x0061, 0 }},
	{ 0x33cb,	{ 0x0048, 0x0050, 0 }},
	{ 0x33cc,	{ 0x0069, 0x006E, 0 }},
	{ 0x33cd,	{ 0x004B, 0x004B, 0 }},
	{ 0x33ce,	{ 0x004B, 0x004D, 0 }},
	{ 0x33cf,	{ 0x006B, 0x0074, 0 }},
	{ 0x33d0,	{ 0x006C, 0x006D, 0 }},
	{ 0x33d1,	{ 0x006C, 0x006E, 0 }},
	{ 0x33d2,	{ 0x006C, 0x006F, 0x0067, 0 }},
	{ 0x33d3,	{ 0x006C, 0x0078, 0 }},
	{ 0x33d4,	{ 0x006D, 0x0062, 0 }},
	{ 0x33d5,	{ 0x006D, 0x0069, 0x006C, 0 }},
	{ 0x33d6,	{ 0x006D, 0x006F, 0x006C, 0 }},
	{ 0x33d7,	{ 0x0050, 0x0048, 0 }},
	{ 0x33d8,	{ 0x0070, 0x002E, 0x006D, 0x002E, 0 }},
	{ 0x33d9,	{ 0x0050, 0x0050, 0x004D, 0 }},
	{ 0x33da,	{ 0x0050, 0x0052, 0 }},
	{ 0x33db,	{ 0x0073, 0x0072, 0 }},
	{ 0x33dc,	{ 0x0053, 0x0076, 0 }},
	{ 0x33dd,	{ 0x0057, 0x0062, 0 }},
	{ 0x33e0,	{ 0x0031, 0x65E5, 0 }},
	{ 0x33e1,	{ 0x0032, 0x65E5, 0 }},
	{ 0x33e2,	{ 0x0033, 0x65E5, 0 }},
	{ 0x33e3,	{ 0x0034, 0x65E5, 0 }},
	{ 0x33e4,	{ 0x0035, 0x65E5, 0 }},
	{ 0x33e5,	{ 0x0036, 0x65E5, 0 }},
	{ 0x33e6,	{ 0x0037, 0x65E5, 0 }},
	{ 0x33e7,	{ 0x0038, 0x65E5, 0 }},
	{ 0x33e8,	{ 0x0039, 0x65E5, 0 }},
	{ 0x33e9,	{ 0x0031, 0x0030, 0x65E5, 0 }},
	{ 0x33ea,	{ 0x0031, 0x0031, 0x65E5, 0 }},
	{ 0x33eb,	{ 0x0031, 0x0032, 0x65E5, 0 }},
	{ 0x33ec,	{ 0x0031, 0x0033, 0x65E5, 0 }},
	{ 0x33ed,	{ 0x0031, 0x0034, 0x65E5, 0 }},
	{ 0x33ee,	{ 0x0031, 0x0035, 0x65E5, 0 }},
	{ 0x33ef,	{ 0x0031, 0x0036, 0x65E5, 0 }},
	{ 0x33f0,	{ 0x0031, 0x0037, 0x65E5, 0 }},
	{ 0x33f1,	{ 0x0031, 0x0038, 0x65E5, 0 }},
	{ 0x33f2,	{ 0x0031, 0x0039, 0x65E5, 0 }},
	{ 0x33f3,	{ 0x0032, 0x0030, 0x65E5, 0 }},
	{ 0x33f4,	{ 0x0032, 0x0031, 0x65E5, 0 }},
	{ 0x33f5,	{ 0x0032, 0x0032, 0x65E5, 0 }},
	{ 0x33f6,	{ 0x0032, 0x0033, 0x65E5, 0 }},
	{ 0x33f7,	{ 0x0032, 0x0034, 0x65E5, 0 }},
	{ 0x33f8,	{ 0x0032, 0x0035, 0x65E5, 0 }},
	{ 0x33f9,	{ 0x0032, 0x0036, 0x65E5, 0 }},
	{ 0x33fa,	{ 0x0032, 0x0037, 0x65E5, 0 }},
	{ 0x33fb,	{ 0x0032, 0x0038, 0x65E5, 0 }},
	{ 0x33fc,	{ 0x0032, 0x0039, 0x65E5, 0 }},
	{ 0x33fd,	{ 0x0033, 0x0030, 0x65E5, 0 }},
	{ 0x33fe,	{ 0x0033, 0x0031, 0x65E5, 0 }},
	{ 0xfb00,	{ 0x0066, 0x0066, 0 }},
	{ 0xfb01,	{ 0x0066, 0x0069, 0 }},
	{ 0xfb02,	{ 0x0066, 0x006C, 0 }},
	{ 0xfb03,	{ 0x0066, 0x0066, 0x0069, 0 }},
	{ 0xfb04,	{ 0x0066, 0x0066, 0x006C, 0 }},
	{ 0xfb05,	{ 0x0073, 0x0074, 0 }},
	{ 0xfb06,	{ 0x0073, 0x0074, 0 }},
	{ 0xfb13,	{ 0x0574, 0x0576, 0 }},
	{ 0xfb14,	{ 0x0574, 0x0565, 0 }},
	{ 0xfb15,	{ 0x0574, 0x056B, 0 }},
	{ 0xfb16,	{ 0x057E, 0x0576, 0 }},
	{ 0xfb17,	{ 0x0574, 0x056D, 0 }},
	{ 0xfb1f,	{ 0x05D9, 0x05D9, 0x05B7, 0 }},
	{ 0xfb20,	{ 0x05E2, 0 }},
	{ 0xfb21,	{ 0x05D0, 0 }},
	{ 0xfb22,	{ 0x05D3, 0 }},
	{ 0xfb23,	{ 0x05D4, 0 }},
	{ 0xfb24,	{ 0x05DB, 0 }},
	{ 0xfb25,	{ 0x05DC, 0 }},
	{ 0xfb26,	{ 0x05DD, 0 }},
	{ 0xfb27,	{ 0x05E8, 0 }},
	{ 0xfb28,	{ 0x05EA, 0 }},
	{ 0xfb29,	{ 0x002B, 0 }},
	{ 0xfb2a,	{ 0x05E9, 0x05C1, 0 }},
	{ 0xfb2b,	{ 0x05E9, 0x05C2, 0 }},
	{ 0xfb2c,	{ 0x05E9, 0x05BC, 0x05C1, 0 }},
	{ 0xfb2d,	{ 0x05E9, 0x05BC, 0x05C2, 0 }},
	{ 0xfb2e,	{ 0x05D0, 0x05B7, 0 }},
	{ 0xfb2f,	{ 0x05D0, 0x05B8, 0 }},
	{ 0xfb30,	{ 0x05D0, 0x05BC, 0 }},
	{ 0xfb31,	{ 0x05D1, 0x05BC, 0 }},
	{ 0xfb32,	{ 0x05D2, 0x05BC, 0 }},
	{ 0xfb33,	{ 0x05D3, 0x05BC, 0 }},
	{ 0xfb34,	{ 0x05D4, 0x05BC, 0 }},
	{ 0xfb35,	{ 0x05D5, 0x05BC, 0 }},
	{ 0xfb36,	{ 0x05D6, 0x05BC, 0 }},
	{ 0xfb38,	{ 0x05D8, 0x05BC, 0 }},
	{ 0xfb39,	{ 0x05D9, 0x05BC, 0 }},
	{ 0xfb3a,	{ 0x05DA, 0x05BC, 0 }},
	{ 0xfb3b,	{ 0x05DB, 0x05BC, 0 }},
	{ 0xfb3c,	{ 0x05DC, 0x05BC, 0 }},
	{ 0xfb3e,	{ 0x05DE, 0x05BC, 0 }},
	{ 0xfb40,	{ 0x05E0, 0x05BC, 0 }},
	{ 0xfb41,	{ 0x05E1, 0x05BC, 0 }},
	{ 0xfb43,	{ 0x05E3, 0x05BC, 0 }},
	{ 0xfb44,	{ 0x05E4, 0x05BC, 0 }},
	{ 0xfb46,	{ 0x05E6, 0x05BC, 0 }},
	{ 0xfb47,	{ 0x05E7, 0x05BC, 0 }},
	{ 0xfb48,	{ 0x05E8, 0x05BC, 0 }},
	{ 0xfb49,	{ 0x05E9, 0x05BC, 0 }},
	{ 0xfb4a,	{ 0x05EA, 0x05BC, 0 }},
	{ 0xfb4b,	{ 0x05D5, 0x05B9, 0 }},
	{ 0xfb4c,	{ 0x05D1, 0x05BF, 0 }},
	{ 0xfb4d,	{ 0x05DB, 0x05BF, 0 }},
	{ 0xfb4e,	{ 0x05E4, 0x05BF, 0 }},
	{ 0xfb4f,	{ 0x05D0, 0x05DC, 0 }},
	{ 0xfe30,	{ 0x2025, 0 }},
	{ 0xfe31,	{ 0x2014, 0 }},
	{ 0xfe32,	{ 0x2013, 0 }},
	{ 0xfe33,	{ 0x005F, 0 }},
	{ 0xfe34,	{ 0x005F, 0 }},
	{ 0xfe35,	{ 0x0028, 0 }},
	{ 0xfe36,	{ 0x0029, 0 }},
	{ 0xfe37,	{ 0x007B, 0 }},
	{ 0xfe38,	{ 0x007D, 0 }},
	{ 0xfe39,	{ 0x3014, 0 }},
	{ 0xfe3a,	{ 0x3015, 0 }},
	{ 0xfe3b,	{ 0x3010, 0 }},
	{ 0xfe3c,	{ 0x3011, 0 }},
	{ 0xfe3d,	{ 0x300A, 0 }},
	{ 0xfe3e,	{ 0x300B, 0 }},
	{ 0xfe3f,	{ 0x3008, 0 }},
	{ 0xfe40,	{ 0x3009, 0 }},
	{ 0xfe41,	{ 0x300C, 0 }},
	{ 0xfe42,	{ 0x300D, 0 }},
	{ 0xfe43,	{ 0x300E, 0 }},
	{ 0xfe44,	{ 0x300F, 0 }},
	{ 0xfe49,	{ 0x203E, 0 }},
	{ 0xfe4a,	{ 0x203E, 0 }},
	{ 0xfe4b,	{ 0x203E, 0 }},
	{ 0xfe4c,	{ 0x203E, 0 }},
	{ 0xfe4d,	{ 0x005F, 0 }},
	{ 0xfe4e,	{ 0x005F, 0 }},
	{ 0xfe4f,	{ 0x005F, 0 }},
	{ 0xfe50,	{ 0x002C, 0 }},
	{ 0xfe51,	{ 0x3001, 0 }},
	{ 0xfe52,	{ 0x002E, 0 }},
	{ 0xfe54,	{ 0x003B, 0 }},
	{ 0xfe55,	{ 0x003A, 0 }},
	{ 0xfe56,	{ 0x003F, 0 }},
	{ 0xfe57,	{ 0x0021, 0 }},
	{ 0xfe58,	{ 0x2014, 0 }},
	{ 0xfe59,	{ 0x0028, 0 }},
	{ 0xfe5a,	{ 0x0029, 0 }},
	{ 0xfe5b,	{ 0x007B, 0 }},
	{ 0xfe5c,	{ 0x007D, 0 }},
	{ 0xfe5d,	{ 0x3014, 0 }},
	{ 0xfe5e,	{ 0x3015, 0 }},
	{ 0xfe5f,	{ 0x0023, 0 }},
	{ 0xfe60,	{ 0x0026, 0 }},
	{ 0xfe61,	{ 0x002A, 0 }},
	{ 0xfe62,	{ 0x002B, 0 }},
	{ 0xfe63,	{ 0x002D, 0 }},
	{ 0xfe64,	{ 0x003C, 0 }},
	{ 0xfe65,	{ 0x003E, 0 }},
	{ 0xfe66,	{ 0x003D, 0 }},
	{ 0xfe68,	{ 0x005C, 0 }},
	{ 0xfe69,	{ 0x0024, 0 }},
	{ 0xfe6a,	{ 0x0025, 0 }},
	{ 0xfe6b,	{ 0x0040, 0 }},
	{ 0xfe70,	{ 0x0020, 0x064B, 0 }},
	{ 0xfe71,	{ 0x0640, 0x064B, 0 }},
	{ 0xfe72,	{ 0x0020, 0x064C, 0 }},
	{ 0xfe74,	{ 0x0020, 0x064D, 0 }},
	{ 0xfe76,	{ 0x0020, 0x064E, 0 }},
	{ 0xfe77,	{ 0x0640, 0x064E, 0 }},
	{ 0xfe78,	{ 0x0020, 0x064F, 0 }},
	{ 0xfe79,	{ 0x0640, 0x064F, 0 }},
	{ 0xfe7a,	{ 0x0020, 0x0650, 0 }},
	{ 0xfe7b,	{ 0x0640, 0x0650, 0 }},
	{ 0xfe7c,	{ 0x0020, 0x0651, 0 }},
	{ 0xfe7d,	{ 0x0640, 0x0651, 0 }},
	{ 0xfe7e,	{ 0x0020, 0x0652, 0 }},
	{ 0xfe7f,	{ 0x0640, 0x0652, 0 }},
	{ 0xff01,	{ 0x0021, 0 }},
	{ 0xff02,	{ 0x0022, 0 }},
	{ 0xff03,	{ 0x0023, 0 }},
	{ 0xff04,	{ 0x0024, 0 }},
	{ 0xff05,	{ 0x0025, 0 }},
	{ 0xff06,	{ 0x0026, 0 }},
	{ 0xff07,	{ 0x0027, 0 }},
	{ 0xff08,	{ 0x0028, 0 }},
	{ 0xff09,	{ 0x0029, 0 }},
	{ 0xff0a,	{ 0x002A, 0 }},
	{ 0xff0b,	{ 0x002B, 0 }},
	{ 0xff0c,	{ 0x002C, 0 }},
	{ 0xff0d,	{ 0x002D, 0 }},
	{ 0xff0e,	{ 0x002E, 0 }},
	{ 0xff0f,	{ 0x002F, 0 }},
	{ 0xff10,	{ 0x0030, 0 }},
	{ 0xff11,	{ 0x0031, 0 }},
	{ 0xff12,	{ 0x0032, 0 }},
	{ 0xff13,	{ 0x0033, 0 }},
	{ 0xff14,	{ 0x0034, 0 }},
	{ 0xff15,	{ 0x0035, 0 }},
	{ 0xff16,	{ 0x0036, 0 }},
	{ 0xff17,	{ 0x0037, 0 }},
	{ 0xff18,	{ 0x0038, 0 }},
	{ 0xff19,	{ 0x0039, 0 }},
	{ 0xff1a,	{ 0x003A, 0 }},
	{ 0xff1b,	{ 0x003B, 0 }},
	{ 0xff1c,	{ 0x003C, 0 }},
	{ 0xff1d,	{ 0x003D, 0 }},
	{ 0xff1e,	{ 0x003E, 0 }},
	{ 0xff1f,	{ 0x003F, 0 }},
	{ 0xff20,	{ 0x0040, 0 }},
	{ 0xff21,	{ 0x0041, 0 }},
	{ 0xff22,	{ 0x0042, 0 }},
	{ 0xff23,	{ 0x0043, 0 }},
	{ 0xff24,	{ 0x0044, 0 }},
	{ 0xff25,	{ 0x0045, 0 }},
	{ 0xff26,	{ 0x0046, 0 }},
	{ 0xff27,	{ 0x0047, 0 }},
	{ 0xff28,	{ 0x0048, 0 }},
	{ 0xff29,	{ 0x0049, 0 }},
	{ 0xff2a,	{ 0x004A, 0 }},
	{ 0xff2b,	{ 0x004B, 0 }},
	{ 0xff2c,	{ 0x004C, 0 }},
	{ 0xff2d,	{ 0x004D, 0 }},
	{ 0xff2e,	{ 0x004E, 0 }},
	{ 0xff2f,	{ 0x004F, 0 }},
	{ 0xff30,	{ 0x0050, 0 }},
	{ 0xff31,	{ 0x0051, 0 }},
	{ 0xff32,	{ 0x0052, 0 }},
	{ 0xff33,	{ 0x0053, 0 }},
	{ 0xff34,	{ 0x0054, 0 }},
	{ 0xff35,	{ 0x0055, 0 }},
	{ 0xff36,	{ 0x0056, 0 }},
	{ 0xff37,	{ 0x0057, 0 }},
	{ 0xff38,	{ 0x0058, 0 }},
	{ 0xff39,	{ 0x0059, 0 }},
	{ 0xff3a,	{ 0x005A, 0 }},
	{ 0xff3b,	{ 0x005B, 0 }},
	{ 0xff3c,	{ 0x005C, 0 }},
	{ 0xff3d,	{ 0x005D, 0 }},
	{ 0xff3e,	{ 0x005E, 0 }},
	{ 0xff3f,	{ 0x005F, 0 }},
	{ 0xff40,	{ 0x0060, 0 }},
	{ 0xff41,	{ 0x0061, 0 }},
	{ 0xff42,	{ 0x0062, 0 }},
	{ 0xff43,	{ 0x0063, 0 }},
	{ 0xff44,	{ 0x0064, 0 }},
	{ 0xff45,	{ 0x0065, 0 }},
	{ 0xff46,	{ 0x0066, 0 }},
	{ 0xff47,	{ 0x0067, 0 }},
	{ 0xff48,	{ 0x0068, 0 }},
	{ 0xff49,	{ 0x0069, 0 }},
	{ 0xff4a,	{ 0x006A, 0 }},
	{ 0xff4b,	{ 0x006B, 0 }},
	{ 0xff4c,	{ 0x006C, 0 }},
	{ 0xff4d,	{ 0x006D, 0 }},
	{ 0xff4e,	{ 0x006E, 0 }},
	{ 0xff4f,	{ 0x006F, 0 }},
	{ 0xff50,	{ 0x0070, 0 }},
	{ 0xff51,	{ 0x0071, 0 }},
	{ 0xff52,	{ 0x0072, 0 }},
	{ 0xff53,	{ 0x0073, 0 }},
	{ 0xff54,	{ 0x0074, 0 }},
	{ 0xff55,	{ 0x0075, 0 }},
	{ 0xff56,	{ 0x0076, 0 }},
	{ 0xff57,	{ 0x0077, 0 }},
	{ 0xff58,	{ 0x0078, 0 }},
	{ 0xff59,	{ 0x0079, 0 }},
	{ 0xff5a,	{ 0x007A, 0 }},
	{ 0xff5b,	{ 0x007B, 0 }},
	{ 0xff5c,	{ 0x007C, 0 }},
	{ 0xff5d,	{ 0x007D, 0 }},
	{ 0xff5e,	{ 0x007E, 0 }},
	{ 0xff61,	{ 0x3002, 0 }},
	{ 0xff62,	{ 0x300C, 0 }},
	{ 0xff63,	{ 0x300D, 0 }},
	{ 0xff64,	{ 0x3001, 0 }},
	{ 0xff65,	{ 0x30FB, 0 }},
	{ 0xff66,	{ 0x30F2, 0 }},
	{ 0xff67,	{ 0x30A1, 0 }},
	{ 0xff68,	{ 0x30A3, 0 }},
	{ 0xff69,	{ 0x30A5, 0 }},
	{ 0xff6a,	{ 0x30A7, 0 }},
	{ 0xff6b,	{ 0x30A9, 0 }},
	{ 0xff6c,	{ 0x30E3, 0 }},
	{ 0xff6d,	{ 0x30E5, 0 }},
	{ 0xff6e,	{ 0x30E7, 0 }},
	{ 0xff6f,	{ 0x30C3, 0 }},
	{ 0xff70,	{ 0x30FC, 0 }},
	{ 0xff71,	{ 0x30A2, 0 }},
	{ 0xff72,	{ 0x30A4, 0 }},
	{ 0xff73,	{ 0x30A6, 0 }},
	{ 0xff74,	{ 0x30A8, 0 }},
	{ 0xff75,	{ 0x30AA, 0 }},
	{ 0xff76,	{ 0x30AB, 0 }},
	{ 0xff77,	{ 0x30AD, 0 }},
	{ 0xff78,	{ 0x30AF, 0 }},
	{ 0xff79,	{ 0x30B1, 0 }},
	{ 0xff7a,	{ 0x30B3, 0 }},
	{ 0xff7b,	{ 0x30B5, 0 }},
	{ 0xff7c,	{ 0x30B7, 0 }},
	{ 0xff7d,	{ 0x30B9, 0 }},
	{ 0xff7e,	{ 0x30BB, 0 }},
	{ 0xff7f,	{ 0x30BD, 0 }},
	{ 0xff80,	{ 0x30BF, 0 }},
	{ 0xff81,	{ 0x30C1, 0 }},
	{ 0xff82,	{ 0x30C4, 0 }},
	{ 0xff83,	{ 0x30C6, 0 }},
	{ 0xff84,	{ 0x30C8, 0 }},
	{ 0xff85,	{ 0x30CA, 0 }},
	{ 0xff86,	{ 0x30CB, 0 }},
	{ 0xff87,	{ 0x30CC, 0 }},
	{ 0xff88,	{ 0x30CD, 0 }},
	{ 0xff89,	{ 0x30CE, 0 }},
	{ 0xff8a,	{ 0x30CF, 0 }},
	{ 0xff8b,	{ 0x30D2, 0 }},
	{ 0xff8c,	{ 0x30D5, 0 }},
	{ 0xff8d,	{ 0x30D8, 0 }},
	{ 0xff8e,	{ 0x30DB, 0 }},
	{ 0xff8f,	{ 0x30DE, 0 }},
	{ 0xff90,	{ 0x30DF, 0 }},
	{ 0xff91,	{ 0x30E0, 0 }},
	{ 0xff92,	{ 0x30E1, 0 }},
	{ 0xff93,	{ 0x30E2, 0 }},
	{ 0xff94,	{ 0x30E4, 0 }},
	{ 0xff95,	{ 0x30E6, 0 }},
	{ 0xff96,	{ 0x30E8, 0 }},
	{ 0xff97,	{ 0x30E9, 0 }},
	{ 0xff98,	{ 0x30EA, 0 }},
	{ 0xff99,	{ 0x30EB, 0 }},
	{ 0xff9a,	{ 0x30EC, 0 }},
	{ 0xff9b,	{ 0x30ED, 0 }},
	{ 0xff9c,	{ 0x30EF, 0 }},
	{ 0xff9d,	{ 0x30F3, 0 }},
	{ 0xff9e,	{ 0x309B, 0 }},
	{ 0xff9f,	{ 0x309C, 0 }},
	{ 0xffa0,	{ 0x3164, 0 }},
	{ 0xffa1,	{ 0x3131, 0 }},
	{ 0xffa2,	{ 0x3132, 0 }},
	{ 0xffa3,	{ 0x3133, 0 }},
	{ 0xffa4,	{ 0x3134, 0 }},
	{ 0xffa5,	{ 0x3135, 0 }},
	{ 0xffa6,	{ 0x3136, 0 }},
	{ 0xffa7,	{ 0x3137, 0 }},
	{ 0xffa8,	{ 0x3138, 0 }},
	{ 0xffa9,	{ 0x3139, 0 }},
	{ 0xffaa,	{ 0x313A, 0 }},
	{ 0xffab,	{ 0x313B, 0 }},
	{ 0xffac,	{ 0x313C, 0 }},
	{ 0xffad,	{ 0x313D, 0 }},
	{ 0xffae,	{ 0x313E, 0 }},
	{ 0xffaf,	{ 0x313F, 0 }},
	{ 0xffb0,	{ 0x3140, 0 }},
	{ 0xffb1,	{ 0x3141, 0 }},
	{ 0xffb2,	{ 0x3142, 0 }},
	{ 0xffb3,	{ 0x3143, 0 }},
	{ 0xffb4,	{ 0x3144, 0 }},
	{ 0xffb5,	{ 0x3145, 0 }},
	{ 0xffb6,	{ 0x3146, 0 }},
	{ 0xffb7,	{ 0x3147, 0 }},
	{ 0xffb8,	{ 0x3148, 0 }},
	{ 0xffb9,	{ 0x3149, 0 }},
	{ 0xffba,	{ 0x314A, 0 }},
	{ 0xffbb,	{ 0x314B, 0 }},
	{ 0xffbc,	{ 0x314C, 0 }},
	{ 0xffbd,	{ 0x314D, 0 }},
	{ 0xffbe,	{ 0x314E, 0 }},
	{ 0xffc2,	{ 0x314F, 0 }},
	{ 0xffc3,	{ 0x3150, 0 }},
	{ 0xffc4,	{ 0x3151, 0 }},
	{ 0xffc5,	{ 0x3152, 0 }},
	{ 0xffc6,	{ 0x3153, 0 }},
	{ 0xffc7,	{ 0x3154, 0 }},
	{ 0xffca,	{ 0x3155, 0 }},
	{ 0xffcb,	{ 0x3156, 0 }},
	{ 0xffcc,	{ 0x3157, 0 }},
	{ 0xffcd,	{ 0x3158, 0 }},
	{ 0xffce,	{ 0x3159, 0 }},
	{ 0xffcf,	{ 0x315A, 0 }},
	{ 0xffd2,	{ 0x315B, 0 }},
	{ 0xffd3,	{ 0x315C, 0 }},
	{ 0xffd4,	{ 0x315D, 0 }},
	{ 0xffd5,	{ 0x315E, 0 }},
	{ 0xffd6,	{ 0x315F, 0 }},
	{ 0xffd7,	{ 0x3160, 0 }},
	{ 0xffda,	{ 0x3161, 0 }},
	{ 0xffdb,	{ 0x3162, 0 }},
	{ 0xffdc,	{ 0x3163, 0 }},
	{ 0xffe0,	{ 0x00A2, 0 }},
	{ 0xffe1,	{ 0x00A3, 0 }},
	{ 0xffe2,	{ 0x00AC, 0 }},
	{ 0xffe3,	{ 0x00AF, 0 }},
	{ 0xffe4,	{ 0x00A6, 0 }},
	{ 0xffe5,	{ 0x00A5, 0 }},
	{ 0xffe6,	{ 0x20A9, 0 }},
	{ 0xffe8,	{ 0x2502, 0 }},
	{ 0xffe9,	{ 0x2190, 0 }},
	{ 0xffea,	{ 0x2191, 0 }},
	{ 0xffeb,	{ 0x2192, 0 }},
	{ 0xffec,	{ 0x2193, 0 }},
	{ 0xffed,	{ 0x25A0, 0 }},
	{ 0xffee,	{ 0x25CB, 0 }},
};

static int fcomp(const void *a, const void *b)
{
	return (*(ZIL_ICHAR *)a - *(ZIL_ICHAR *)b);
}


ZIL_ICHAR *ZIL_INTERNATIONAL::DecomposeCharacter(ZIL_ICHAR val)
{
#if defined(__WATCOMC__)
	for (int i=0; i < LENGTHOF(decomposeTable); i++)
		if (decomposeTable[i].val == val)
			return (decomposeTable[i].str);
#else
	ZIL_DECOMPOSE_TABLE *tmp = (ZIL_DECOMPOSE_TABLE *)bsearch(&val, decomposeTable, LENGTHOF(decomposeTable), sizeof(decomposeTable[0]), fcomp);
	if (tmp)
		return (tmp->str);
#endif
	static ZIL_ICHAR dBuff[2];
	dBuff[0] = val;
	dBuff[1] = 0;
	return (dBuff);
}

ZIL_ICHAR *ZIL_INTERNATIONAL::DecomposeString(const ZIL_ICHAR *str, int n)
{
	if (n < 0)
		n = strlen(str);
	ZIL_ICHAR *retStr = new ZIL_ICHAR[n*6+1];
	int len = 0;
	for (int i=0; n && str[i]; i++, n--)
	{
		strcpy(&retStr[len], DecomposeCharacter(str[i]));
		len += strlen(&retStr[len]);
	}
	retStr[len] = 0;
	return (retStr);
}
#endif

ZIL_ICHAR *ZIL_INTERNATIONAL::strstr(const ZIL_ICHAR *s1, const ZIL_ICHAR *s2)
{
	ZIL_ICHAR *val;

	if (!*s2)
		return ((ZIL_ICHAR *)s1);
	for (int i = 0; s1[i]; i++)
	{
		val = strchr(s1, s2[0]);
		if (val && strncmp(val, s2, strlen(s2)) == 0)
			return (val);
	}
	return (ZIL_NULLP(ZIL_ICHAR));
}

