# INTERPOL tutorial makefile

#    smake -fsccpp700.mak dos  	      	(makes all the DOS intrpol tutorials)
#    smake -fsccpp700.mak dosovl      	(makes all the DOS VCM overlay intrpol tutorials)
#    smake -fsccpp700.mak dos32	      	(makes all the DOS extender intrpol tutorials)
#    smake -fsccpp700.mak windows      	(makes all the Windows intrpol tutorials)

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\SC\INCLUDE
#    set LIB=.;C:\ZINC\LIB\SCCPP700;C:\SC\LIB

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP=sc
DOS_LINK=link
DOS_CPP_OPTS=-c -a1 -ml -o+space
DOS_LINK_OPTS=/NOI /SEG:300
DOS_OBJS=
DOS_LIBS=dos_zil dos_gfx sc_lgfx

.c.obj:
	$(DOS_CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(DOS_CPP) $(DOS_CPP_OPTS) $<

# ----- DOS Overlay (VCM) compiler options ----------------------------------
OVL_CPP=sc
OVL_LINK=link
OVL_CPP_OPTS=-c -a1 -mv -o+space -R
OVL_LINK_OPTS=/NOI /F /PAC
OVL_OBJS=
OVL_LIBS=dos_zilv dos_gfxv sc_lgfxv

.c.ovl:
	$(OVL_CPP) $(OVL_CPP_OPTS) -o$*.ovl $<

.cpp.ovl:
	$(OVL_CPP) $(OVL_CPP_OPTS) -o$*.ovl $<

# ----- DOS extender compiler options ---------------------------------------
D32_CPP=sc
D32_LINK=link
D32_CPP_OPTS=-c -bx -mx -D$(FONT)
D32_LINK_OPTS=/NOI
D32_LIB_OPTS=/C /N /B
D32_OBJS=cx
D32_LIBS=d32_zil d32_gfx sc_32gfx

.cpp.o32:
	$(D32_CPP) $(D32_CPP_OPTS) -o$@ $<

.c.o32:
	$(D32_CPP) $(D32_CPP_OPTS) -o$@ $<

# ----- Windows compiler options --------------------------------------------
WIN_CPP=sc
WIN_LINK=link
WIN_RC=rc

WIN_CPP_OPTS=-c -a1 -bx -ml -W2
WIN_RC_OPTS=-k
WIN_LINK_OPTS=/NOI
WIN_OBJS=
WIN_LIBS=win_zil libw

.c.obw:
	$(WIN_CPP) $(WIN_CPP_OPTS) -o$*.obw $<

.cpp.obw:
	$(WIN_CPP) $(WIN_CPP_OPTS) -o$*.obw $<


# ----- Usage ---------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc tutorial for Symantec C++ type:
	@echo smake -fsccpp700.mak dos
	@echo smake -fsccpp700.mak dosovl
	@echo smake -fsccpp700.mak dos32
	@echo smake -fsccpp700.mak windows
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean.bat

# ----- DOS -----------------------------------------------------------------
dos: intrpol1.exe intrpol2.exe

intrpol1.exe: intrpol1.obj ipolwin1.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+intrpol1.obj+ipolwin1.obj,$*,NUL,$(DOS_LIBS),NUL

intrpol2.exe: intrpol2.obj ipolwin2.obj
	$(DOS_LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+intrpol2.obj+ipolwin2.obj,$*,NUL,$(DOS_LIBS),NUL

# ----- DOS Overlay (VCM) ---------------------------------------------------
dosovl: intrpo1v.exe intrpo2v.exe

intrpo1v.exe: intrpol1.ovl ipolwin1.ovl
	$(OVL_LINK) $(OVL_LINK_OPTS) $(OVL_OBJS)+intrpol1.ovl+ipolwin1.ovl,$*, ,$(OVL_LIBS)

intrpo2v.exe: intrpol2.ovl ipolwin2.ovl
	$(OVL_LINK) $(OVL_LINK_OPTS) $(OVL_OBJS)+intrpol2.ovl+ipolwin2.ovl,$*, ,$(OVL_LIBS)

# ----- Dos extender --------------------------------------------------------
dos32: intrp132.exe intrp232.exe

intrp132.exe: intrpol1.o32 ipolwin1.o32
	$(D32_LINK) $(D32_LINK_OPTS) $(D32_OBJS)+intrpol1.o32+ipolwin1.o32,$*, ,$(D32_LIBS)

intrp232.exe: intrpol2.o32 ipolwin2.o32
	$(D32_LINK) $(D32_LINK_OPTS) $(D32_OBJS)+intrpol2.o32+ipolwin2.o32,$*, ,$(D32_LIBS)

# ----- Windows -------------------------------------------------------------
windows: wintrpo1.exe wintrpo2.exe

wintrpo1.exe: intrpol1.obw ipolwin1.obw
	$(WIN_LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+intrpol1.obw+ipolwin1.obw,$*,NUL,$(WIN_LIBS),wintrpol.def
	$(WIN_RC) $(WIN_RC_OPTS) wintrpol.rc $*.exe

wintrpo2.exe: intrpol2.obw ipolwin2.obw
	$(WIN_LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+intrpol2.obw+ipolwin2.obw,$*,NUL,$(WIN_LIBS),wintrpol.def
	$(WIN_RC) $(WIN_RC_OPTS) wintrpol.rc $*.exe

