//	Zinc Interface Library - W_GROUP.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

#	if __BORLANDC__ >= 0X0500
#		undef true
#		define true OSRegion
#	endif

#include "ui_win.hpp"

// ----- UIW_GROUP ---------------------------------------------------------

static WNDPROC _groupCallback = ZIL_NULLF(WNDPROC);

EVENT_TYPE UIW_GROUP::DrawItem(const UI_EVENT &event, EVENT_TYPE ccode)
{

	display->VirtualGet(screenID, true);
	UIW_WINDOW::DrawItem(event, ccode);

	int gap = display->TextHeight(text, screenID, font) / 2 + 1;

	display->Rectangle(screenID, true.left + 1, true.top + gap,
		true.right - 2, true.bottom - 2, LogicalPalette(ccode, ID_DARK_SHADOW));
	display->Rectangle(screenID, true.left + 2, true.top + gap + 1,
		true.right - 1, true.bottom - 1, LogicalPalette(ccode, ID_WHITE_SHADOW));

	display->Text(screenID, true.left + 5, true.top + 1, text, lastPalette, -1,
		TRUE, FALSE, ZIL_NULLP(UI_REGION), font);

	display->VirtualPut(screenID);

	return (TRUE);
}

EVENT_TYPE UIW_GROUP::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	int processed = FALSE;
	EVENT_TYPE ccode = S_UNKNOWN;

	if (event.type == E_MSWINDOWS)
	{
		UINT message = event.message.message;
		WPARAM wParam = event.message.wParam;

		processed = TRUE;

		switch (message)
		{

			case WM_ERASEBKGND:
				if (!FlagSet(woStatus, WOS_OWNERDRAW))
				{
					UI_WINDOW_OBJECT *oObject = NULL;
					for (oObject = parent; oObject &&
						(oObject->LogicalPalette(S_DISPLAY_ACTIVE)->colorBackground == BACKGROUND ||
						oObject->LogicalPalette(S_DISPLAY_ACTIVE)->fillPattern == PTN_RGB_COLOR);
						oObject = oObject->parent)
						;
					UI_PALETTE *outPalette = oObject->LogicalPalette(S_DISPLAY_ACTIVE);

					UI_WINDOW_OBJECT *bObject = NULL;
					for (bObject = this; bObject &&
						(bObject->LogicalPalette(S_DISPLAY_ACTIVE)->colorBackground == BACKGROUND ||
						bObject->LogicalPalette(S_DISPLAY_ACTIVE)->fillPattern == PTN_RGB_COLOR);
						bObject = bObject->parent)
						;
					lastPalette = bObject->LogicalPalette(ccode);

					int outsideTop = 8;
					UI_MSWINDOWS_DISPLAY::hDC = (HDC)wParam;
					display->VirtualGet(ID_DIRECT, true);
					display->Rectangle(screenID, true.left, true.top,
						true.right, true.top + outsideTop, outPalette, 0, TRUE);
					display->Rectangle(screenID, true.left, true.top + outsideTop,
						true.right, true.bottom, lastPalette, 0, TRUE);
					display->VirtualPut(ID_DIRECT);
					UI_MSWINDOWS_DISPLAY::hDC = 0;
				}
				ccode = TRUE;
				break;

			// Ambiguous cases.
			case WM_KEYDOWN:
			case WM_KEYUP:
			case WM_CHAR:
				processed = FALSE;
				break;

			default:
				ccode = UIW_WINDOW::Event(event);
				break;
		}
	}

	if (!processed)
	{
		// Switch on the event type.
		ccode = LogicalEvent(event, ID_GROUP);
		switch (ccode)
		{
		case S_INITIALIZE:
			UIW_WINDOW::Event(event);
			dwStyle |= BS_GROUPBOX;
			break;

		case S_CREATE:
			UI_WINDOW_OBJECT::Event(event);
			// Fall through to S_REGISTER_OBJECT.

		case S_REGISTER_OBJECT:
			{
			RegisterObject("UIW_GROUP", "BUTTON", &_groupCallback, text);

			clipList.Destroy();

			RECT cRect;
			GetClientRect(screenID, &cRect);
			UI_REGION region;
			region.Assign(cRect);
			clipList.Add(new UI_REGION_ELEMENT(screenID, region));

			if (ccode == S_CREATE)
			{
				// Compute the list object regions.
				for (object = First(); object; object = object->Next())
					object->Event(event);
			}
			}
			break;

/* START BLOCK COMMENT
**			case S_CHANGED:
**				{
**				ccode = UI_WINDOW_OBJECT::Event(event);
**				clipList.Destroy();
**	
**				RECT cRect;
**				GetClientRect(screenID, &cRect);
**				UI_REGION region;
**				region.Assign(cRect);
**				clipList.Add(new UI_REGION_ELEMENT(screenID, region));
**	
**				// Compute the list object regions.
**				for (object = First(); object; object = object->Next())
**					object->Event(event);
**				}
**				break;
END BLOCK COMMENT */

		case L_PREVIOUS:
		case L_NEXT:
/* START BLOCK COMMENT
**			if (!HasWrappedData())
**			{
**				EVENT_TYPE tCode = ccode;
**				UI_WINDOW_OBJECT *object = Current();
**				ccode = UIW_WINDOW::Event(event);
**				if (tCode != ccode)
**				{
**					object = (tCode == L_NEXT) ? First() : Last();
**					while (object && (object->IsNonselectable() || object->IsNoncurrent()))
**						object = (tCode == L_NEXT) ? object->Next() : object->Previous();
**					if (object)
**						SetCurrent(object);
**					ccode = S_UNKNOWN;
**				}
**			}
**			else
END BLOCK COMMENT */
			ccode = S_UNKNOWN;
		break;

		default:
			ccode = UIW_WINDOW::Event(event);
			break;
		}
	}

	// Return the control code.
	return (ccode);
}

// ----- OS Specific Functions ----------------------------------------------

void UIW_GROUP::OSDataSet(void)
{
	// Redisplay the string.
	if (screenID)
	{
		InvalidateRect(screenID, ZIL_NULLP(RECT), TRUE);
		SendMessage(screenID, WM_SETTEXT, 0, (LONG)text);
	}
}

void UIW_GROUP::OSUpdateSettings(ZIL_OBJECTID objectID)
{
		// See if the field needs to be re-computed.
		if (objectID == ID_GROUP && FlagSet(woStatus, WOS_REDISPLAY))
		{
			Event(UI_EVENT(S_INITIALIZE));
			Event(UI_EVENT(S_CREATE));
		}
}


#	if __BORLANDC__ >= 0X0500
#		undef true
#	endif

