//	Zinc Interface Library - W_TITLE.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

#	if __BORLANDC__ >= 0X0500
#		undef true
#		define true OSRegion
#	endif

#include "ui_win.hpp"

// ----- UIW_TITLE ----------------------------------------------------------

EVENT_TYPE UIW_TITLE::Event(const UI_EVENT &event)
{
	// Initialize the title.
	if (event.type == S_INITIALIZE)
	{
		UI_WINDOW_OBJECT::Event(event);
		dwStyle = WS_CAPTION;
		parent->Information(I_SET_TITLE, this);
		parent->Information(I_SET_DWSTYLE, &dwStyle);
	}
	return (event.type);
}

// ----- OS Specific Functions ----------------------------------------------

void UIW_TITLE::OSDataSet(void)
{
	if (parent && parent->screenID)
	{
		ZIL_SCREENID parentID;
		parent->Information(I_GET_FRAMEID, &parentID);
		SendMessage(parentID, WM_SETTEXT, 0, (LPARAM)text);
	}
}

void UIW_TITLE::OSUpdateSettings(ZIL_OBJECTID objectID)
{
	if (parent)
	{
		parent->Information(I_SET_TITLE, this);
		parent->Information(I_SET_DWSTYLE, &dwStyle);
	}
}


#	if __BORLANDC__ >= 0X0500
#		undef true
#	endif

