//	Zinc Interface Library - Z_NUM.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "i18n.hpp"
#define USE_LOC_NUMBER
#include "p_i18n.hpp"

// ----- LOC_NUMBER -----------------------------------------------------------

void ZAF_LOCALE_WINDOW::LOC_NUMBER_DataLoad(void)
{
	// Load the object data.
	SetText(DECIMAL, table->decimalSeparator);
	SetText(THOUSANDS, table->thousandsSeparator);
	int grouping = *(int *)table->grouping;
	SetValue(GROUPING, grouping);
	SetText(LEFT_PAREN, table->bnumLeftParen);
	SetText(RIGHT_PAREN, table->bnumRightParen);
	SetText(DEFDIGITS, table->defDigits);
	SetText(ALTDIGITS, table->altDigits);
	SetValue(FRACTIONS_DIGIT, table->fractionDigits);
	SetValue(INT_FRACTIONS_DIGIT, table->intFractionDigits);

	// Load the default flags.
	// positive format
	SetText(POSITIVE_SIGN, table->positiveSign);
	SetValue(P_CS_PRECEDES, table->posCurrencyPrecedes);
	SetValue(P_SIGN_POSN, table->posSignPrecedes);
	SetValue(P_SEP_BY_SPACE, table->posSpaceSeparation);
	// negative format
	SetText(NEGATIVE_SIGN, table->negativeSign);
	SetValue(N_CS_PRECEDES, table->negCurrencyPrecedes);
	SetValue(N_SIGN_POSN, table->negSignPrecedes);
	SetValue(N_SEP_BY_SPACE, table->negSpaceSeparation);
}

void ZAF_LOCALE_WINDOW::LOC_NUMBER_DataStore(void)
{
	// Store the object data.
	GetText(DECIMAL, table->decimalSeparator);
	GetText(THOUSANDS, table->thousandsSeparator);
	int grouping;
	GetValue(GROUPING, &grouping);
	*(int *)table->grouping = grouping;
	GetText(LEFT_PAREN, &table->bnumLeftParen);
	GetText(RIGHT_PAREN, &table->bnumRightParen);
	GetText(DEFDIGITS, &table->defDigits);
	GetText(ALTDIGITS, &table->altDigits);
	GetValue(FRACTIONS_DIGIT, &table->fractionDigits);
	GetValue(INT_FRACTIONS_DIGIT, &table->intFractionDigits);

	// Load the default flags.
	// positive format
	GetText(POSITIVE_SIGN, table->positiveSign);
	GetValue(P_CS_PRECEDES, &table->posCurrencyPrecedes);
	GetValue(P_SIGN_POSN, &table->posSignPrecedes);
	GetValue(P_SEP_BY_SPACE, &table->posSpaceSeparation);
	// negative format
	GetText(NEGATIVE_SIGN, table->negativeSign);
	GetValue(N_CS_PRECEDES, &table->negCurrencyPrecedes);
	GetValue(N_SIGN_POSN, &table->negSignPrecedes);
	GetValue(N_SEP_BY_SPACE, &table->negSpaceSeparation);
}

